/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.contentclass;

import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.ui.title.server.specification.UIAssetSpecificationBuilder;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import com.tandbergtv.watchpoint.pmm.title.conf.AutofillProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.BooleanVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.DateVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.FloatVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.IntegerVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class UIContentClassFactory {
    private static final String DISPLAY_NAME_TRUE = "Y";
    private static final String DISPLAY_NAME_FALSE = "N";
    private static Logger logger = Logger.getLogger(UIContentClassFactory.class);

    public static UIContentClassAsset createUIAsset(String path, ContentClassAsset asset) {
        UIContentClassAsset uiAsset = new UIContentClassAsset(path);
        uiAsset.setDisabled(true);
        if (asset != null) {
            uiAsset.setDisabled(asset.isDisabled());
            uiAsset.setMin(asset.getMin());
            uiAsset.setMax(asset.getMax());
            uiAsset.setBatchMin(asset.getBatchMin());
            uiAsset.setBatchMax(asset.getBatchMax());
            uiAsset.setHideFileView(asset.isHideFileView());
            uiAsset.setRequiresFile(asset.isRequiresFile());
        }
        return uiAsset;
    }

    public static UIContentClassField.DataType getDataType(Variable var) {
        if (var instanceof StringVariable) {
            return UIContentClassField.DataType.STRING;
        }
        if (var instanceof BooleanVariable) {
            return UIContentClassField.DataType.BOOLEAN;
        }
        if (var instanceof IntegerVariable) {
            return UIContentClassField.DataType.INTEGER;
        }
        if (var instanceof FloatVariable) {
            return UIContentClassField.DataType.FLOAT;
        }
        if (var instanceof DateVariable) {
            return UIContentClassField.DataType.DATE;
        }
        if (var instanceof TimeVariable) {
            return UIContentClassField.DataType.TIME;
        }
        return UIContentClassField.DataType.STRING;
    }

    public static UIContentClassField.DataType getDataType(CustomField cf) {
        switch (cf.dataType) {
            case STRING: {
                return UIContentClassField.DataType.STRING;
            }
            case BOOLEAN: {
                return UIContentClassField.DataType.BOOLEAN;
            }
            case INTEGER: {
                return UIContentClassField.DataType.INTEGER;
            }
            case FLOAT: {
                return UIContentClassField.DataType.FLOAT;
            }
            case DATE: {
                return UIContentClassField.DataType.DATE;
            }
            case TIME: {
                return UIContentClassField.DataType.TIME;
            }
        }
        return UIContentClassField.DataType.STRING;
    }

    public static List<KeyValuePair> createSuggestedValues(SimpleVariable var, ContentClassField ccField) {
        ArrayList<KeyValuePair> list;
        List ccOptions;
        if (var == null) {
            return null;
        }
        List options = null;
        String optionProvider = var.getOptionProvider();
        if (optionProvider != null) {
            options = UIAssetSpecificationBuilder.getProviderOptions((String)optionProvider);
        } else if (ccField != null && (ccOptions = ccField.getOptions()) != null && !ccOptions.isEmpty()) {
            ArrayList<KeyValuePair> list2 = new ArrayList<KeyValuePair>();
            for (ContentClassOption ccOption : ccOptions) {
                KeyValuePair kvp = new KeyValuePair(ccOption.getDisplayName(), ccOption.getValue());
                list2.add(kvp);
            }
            return list2;
        }
        if (options != null) {
            list = new ArrayList<KeyValuePair>();
            for (VariableOption option : options) {
                KeyValuePair kvp = new KeyValuePair(option.getName(), option.getValue());
                list.add(kvp);
            }
            return list;
        }
        if (var instanceof BooleanVariable) {
            list = new ArrayList();
            list.add(new KeyValuePair(DISPLAY_NAME_TRUE, "true"));
            list.add(new KeyValuePair(DISPLAY_NAME_FALSE, "false"));
            return list;
        }
        return null;
    }

    public static List<KeyValuePair> createPartnerSuggestedValues(CustomField cf, ContentClassField ccField) {
        KeyValuePair kvp;
        if (cf == null || ccField == null) {
            return null;
        }
        ArrayList<KeyValuePair> list = new ArrayList<KeyValuePair>();
        List ccOptions = ccField.getOptions();
        if (ccOptions != null && !ccOptions.isEmpty()) {
            for (ContentClassOption ccOption : ccOptions) {
                kvp = new KeyValuePair(ccOption.getDisplayName(), ccOption.getValue());
                list.add(kvp);
            }
        }
        Set disabledKeys = ccField.getDisabledOptionKeys();
        if (list != null && !list.isEmpty() && disabledKeys != null && !disabledKeys.isEmpty()) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                kvp = (KeyValuePair)itr.next();
                if (!disabledKeys.contains(kvp.getValue())) continue;
                itr.remove();
            }
        }
        return list;
    }

    public static List<KeyValuePair> createSuggestedValuesNew(SimpleVariable var) {
        if (var == null) {
            return null;
        }
        List options = null;
        String optionProvider = var.getOptionProvider();
        options = optionProvider != null ? UIAssetSpecificationBuilder.getProviderOptions((String)optionProvider) : var.getOptions();
        if (options != null) {
            ArrayList<KeyValuePair> list = new ArrayList<KeyValuePair>();
            for (VariableOption option : options) {
                KeyValuePair kvp = new KeyValuePair(option.getName(), option.getValue());
                list.add(kvp);
            }
            return list;
        }
        if (var instanceof BooleanVariable) {
            ArrayList<KeyValuePair> list = new ArrayList<KeyValuePair>();
            list.add(new KeyValuePair(DISPLAY_NAME_TRUE, "true"));
            list.add(new KeyValuePair(DISPLAY_NAME_FALSE, "false"));
            return list;
        }
        return null;
    }

    public static List<KeyValuePair> createSuggestedValues(CustomField cf, ContentClassField ccField) {
        List ccOptions;
        if (cf == null) {
            return null;
        }
        ArrayList<KeyValuePair> list = new ArrayList<KeyValuePair>();
        if (ccField != null && (ccOptions = ccField.getOptions()) != null && !ccOptions.isEmpty()) {
            for (ContentClassOption ccOption : ccOptions) {
                KeyValuePair kvp = new KeyValuePair(ccOption.getDisplayName(), ccOption.getValue());
                list.add(kvp);
            }
        }
        if (cf.dataType == CustomField.DataType.BOOLEAN && list.isEmpty()) {
            list.add(new KeyValuePair(DISPLAY_NAME_TRUE, "true"));
            list.add(new KeyValuePair(DISPLAY_NAME_FALSE, "false"));
        }
        return list;
    }

    public static UIContentClass createUIContentClassWithoutMetadata(ContentClass cc) {
        UIContentClass uicc = new UIContentClass();
        uicc.setId(cc.getId());
        uicc.setTypeId(cc.getType().ordinal());
        uicc.setName(cc.getName());
        uicc.setDescription(cc.getDescription());
        uicc.setDefault(cc.isDefault());
        uicc.setSpecialUsageId(cc.getSpecialUsage().ordinal());
        return uicc;
    }

    public static List<KeyValuePair> createAutofillProviders(List<AutofillProvider> providers) {
        if (providers == null) {
            return null;
        }
        ArrayList<KeyValuePair> uiList = new ArrayList<KeyValuePair>();
        for (AutofillProvider p : providers) {
            uiList.add(new KeyValuePair(p.getJavaClass(), p.getDisplayName()));
        }
        return uiList;
    }
}

