/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.contentclass;

import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.content.server.contentclass.UIContentClassFactory;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConfMetadata;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class UIContentClassPartnerBuilder {
    private TitleConf rootDef;
    private ContentClass cc;
    private ContentClassPartner ccp;

    public UIContentClassPartnerBuilder(TitleConf rootDef, ContentClass cc, ContentClassPartner ccp) {
        this.rootDef = rootDef;
        this.cc = cc;
        this.ccp = ccp;
    }

    public UIContentClassPartner build() {
        UIContentClassPartner uiccp = new UIContentClassPartner();
        uiccp.setContentClassId(this.ccp.getContentClassId());
        uiccp.setPartnerId(this.ccp.getPartnerId());
        uiccp.setContentClassName(this.ccp.getContentClassName());
        uiccp.setPartnerName(this.ccp.getPartnerName());
        uiccp.setProviderId(this.ccp.getProviderId());
        uiccp.setRootAsset(this.createRootAsset(this.rootDef, this.cc, this.ccp));
        return uiccp;
    }

    private UIContentClassAsset createRootAsset(TitleConf conf, ContentClass cc, ContentClassPartner ccPartner) {
        String assetPath = conf.getPath();
        ContentClassMetadata ccMeta = null;
        ContentClassAsset ccAsset = null;
        if (cc != null && cc.getMetadata() != null) {
            ccMeta = cc.getMetadata();
            ccAsset = ccMeta.getAsset(assetPath);
        }
        ContentClassMetadata partnerMeta = null;
        ContentClassAsset partnerAsset = null;
        if (ccPartner != null && ccPartner.getMetadata() != null) {
            partnerMeta = ccPartner.getMetadata();
            partnerAsset = partnerMeta.getAsset(assetPath);
        }
        UIContentClassAsset uiAsset = UIContentClassFactory.createUIAsset(assetPath, ccAsset);
        uiAsset.setDisplayName(conf.getAlias());
        uiAsset.setFields(this.createFields(conf, ccAsset, partnerAsset));
        if (conf.hasChildren()) {
            this.addChildAssets(conf.getChildren(), uiAsset, ccMeta, partnerMeta);
        }
        return uiAsset;
    }

    private void addChildAssets(List<TitleConf> list, UIContentClassAsset uiAsset, ContentClassMetadata ccMeta, ContentClassMetadata partnerMeta) {
        if (list != null) {
            for (TitleConf childDef : list) {
                ContentClassAsset ccAsset;
                String displayName = childDef.getAlias();
                String childPath = childDef.getPath();
                if (ccMeta == null || (ccAsset = ccMeta.getAsset(childPath)) == null || ccAsset.isDisabled()) continue;
                ContentClassAsset partnerAsset = null;
                if (partnerMeta != null) {
                    partnerAsset = partnerMeta.getAsset(childPath);
                }
                UIContentClassAsset childAsset = UIContentClassFactory.createUIAsset(childPath, ccAsset);
                childAsset.setDisplayName(displayName);
                childAsset.setFields(this.createFields(childDef, ccAsset, partnerAsset));
                uiAsset.addAsset(childAsset);
                if (!childDef.hasChildren()) continue;
                this.addChildAssets(childDef.getChildren(), childAsset, ccMeta, partnerMeta);
            }
        }
    }

    private List<UIContentClassField> createFields(TitleConf tc, ContentClassAsset ccAsset, ContentClassAsset partnerAsset) {
        TitleConfMetadata md = tc.getTitleConfMetadata();
        if (md.coreFields == null || md.coreFields.isEmpty()) {
            return null;
        }
        UIContentClassFieldGroup group = new UIContentClassFieldGroup();
        group.setDisabled(false);
        this.processChildFields(group, md.coreFields, ccAsset, partnerAsset);
        this.addCustomFields(group, md.customFields.getGroups(), ccAsset, partnerAsset);
        return group.getFields();
    }

    private void addCustomFields(UIContentClassFieldGroup group, List<CustomFieldGroup> cfGroups, ContentClassAsset ccAsset, ContentClassAsset partnerAsset) {
        if (cfGroups == null || cfGroups.isEmpty()) {
            return;
        }
        for (CustomFieldGroup cfGroup : cfGroups) {
            UIContentClassFieldGroup uiGroup = this.createCustomFieldGroup(cfGroup, ccAsset, partnerAsset);
            if (uiGroup == null) continue;
            for (CustomField cf : cfGroup.fields) {
                UIContentClassField uiField = this.createCustomField(cf, ccAsset, partnerAsset);
                if (uiField == null) continue;
                uiGroup.getFields().add(uiField);
            }
            if (uiGroup.isEmpty()) continue;
            group.getFields().add(uiGroup);
        }
    }

    private UIContentClassFieldGroup createCustomFieldGroup(CustomFieldGroup cfGroup, ContentClassAsset ccAsset, ContentClassAsset partnerAsset) {
        if (ccAsset == null) {
            return null;
        }
        String xpath = "/Fields/CustomFields;" + cfGroup.groupId;
        ContentClassField ccField = ccAsset.getField(xpath);
        if (ccField != null && ccField.isDisabled()) {
            return null;
        }
        UIContentClassFieldGroup uiGroup = new UIContentClassFieldGroup(xpath);
        uiGroup.setDisabled(false);
        uiGroup.setDisplayName(cfGroup.displayName);
        return uiGroup;
    }

    private UIContentClassField createCustomField(CustomField cf, ContentClassAsset ccAsset, ContentClassAsset partnerAsset) {
        ContentClassField partnerField;
        String xpath = "/Fields/CustomFields/CustomField[@name=" + cf.name + "]/@value";
        ContentClassField ccField = null;
        if (ccAsset == null) {
            return null;
        }
        ccField = ccAsset.getField(xpath);
        if (ccField == null || ccField.isDisabled()) {
            return null;
        }
        UIContentClassField uiField = new UIContentClassField(xpath);
        uiField.setDisabled(false);
        uiField.setDataType(UIContentClassFactory.getDataType(cf));
        uiField.setDisplayName(cf.displayName);
        uiField.setAttribute(true);
        uiField.setMultiValue(cf.multiValue);
        if (cf.dropDown) {
            if (cf.anyValueAllowed) {
                uiField.setFieldType(UIContentClassField.FieldType.COMBO_BOX);
            } else {
                uiField.setFieldType(UIContentClassField.FieldType.DROP_DOWN);
            }
        }
        if (cf.multiLine) {
            uiField.setFieldType(UIContentClassField.FieldType.TEXT_AREA);
        }
        if (ccField.getFieldType() != null) {
            uiField.setFieldType(ccField.getFieldType().toString());
        }
        List<KeyValuePair> suggestedValues = UIContentClassFactory.createPartnerSuggestedValues(cf, ccField);
        uiField.setOptions(suggestedValues);
        if (partnerAsset != null && (partnerField = partnerAsset.getField(xpath)) != null) {
            uiField.setValue(partnerField.getDefaultValue());
            uiField.setLocked(partnerField.isLocked());
            uiField.setFilteredOptionKeys(partnerField.getDisabledOptionKeys());
        }
        if (ccField != null) {
            uiField.setRequired(ccField.isRequired());
            uiField.setParentValue(ccField.getDefaultValue());
            uiField.setParentLocked(ccField.isLocked());
        }
        return uiField;
    }

    private void processChildFields(UIContentClassFieldGroup group, List<Variable> children, ContentClassAsset ccAsset, ContentClassAsset partnerAsset) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (Variable childVar : children) {
            if ("CustomFields".equalsIgnoreCase(childVar.getName())) continue;
            if (childVar instanceof ComplexVariable) {
                ComplexVariable complexVar = (ComplexVariable)childVar;
                if (complexVar.isShowCollapsed() && !complexVar.isMultiValue()) {
                    this.processChildFields(group, complexVar.getChildren(), ccAsset, partnerAsset);
                    continue;
                }
                UIContentClassFieldGroup uiGroup = this.createFieldGroup((ComplexVariable)childVar, ccAsset, partnerAsset, group.isReadOnly());
                if (uiGroup == null) continue;
                group.getFields().add(uiGroup);
                continue;
            }
            UIContentClassField uiField = this.createSimpleField((SimpleVariable)childVar, ccAsset, partnerAsset, group.isReadOnly());
            if (uiField == null) continue;
            group.getFields().add(uiField);
        }
    }

    private UIContentClassField createSimpleField(SimpleVariable var, ContentClassAsset ccAsset, ContentClassAsset partnerAsset, boolean readOnly) {
        ContentClassField partnerField;
        boolean multiline;
        String path = var.getXPath();
        ContentClassField ccField = null;
        if (ccAsset == null) {
            return null;
        }
        ccField = ccAsset.getField(path);
        if (ccField == null || ccField.isDisabled()) {
            return null;
        }
        UIContentClassField uiField = new UIContentClassField(path);
        uiField.setDisabled(false);
        uiField.setDisplayName(var.getDisplayName());
        uiField.setDataType(UIContentClassFactory.getDataType((Variable)var));
        uiField.setMultiValue(var.isMultiValue());
        uiField.setAttribute(var.isAttribute());
        if (var.hasOptions()) {
            if (var.isAnyValueAllowed()) {
                uiField.setFieldType(UIContentClassField.FieldType.COMBO_BOX);
            } else {
                uiField.setFieldType(UIContentClassField.FieldType.DROP_DOWN);
            }
        }
        if (var instanceof StringVariable && (multiline = ((StringVariable)var).isLongFormat())) {
            uiField.setFieldType(UIContentClassField.FieldType.TEXT_AREA);
        }
        if (ccField.getFieldType() != null) {
            uiField.setFieldType(ccField.getFieldType().toString());
        }
        List<KeyValuePair> suggestedValues = UIContentClassFactory.createSuggestedValues(var, ccField);
        Set disabledKeys = ccField.getDisabledOptionKeys();
        if (suggestedValues != null && !suggestedValues.isEmpty() && disabledKeys != null && !disabledKeys.isEmpty()) {
            Iterator<KeyValuePair> itr = suggestedValues.iterator();
            while (itr.hasNext()) {
                KeyValuePair kvp = itr.next();
                if (!disabledKeys.contains(kvp.getValue())) continue;
                itr.remove();
            }
        }
        uiField.setOptions(suggestedValues);
        if (partnerAsset != null && (partnerField = partnerAsset.getField(path)) != null) {
            uiField.setValue(partnerField.getDefaultValue());
            uiField.setLocked(partnerField.isLocked());
            uiField.setFilteredOptionKeys(partnerField.getDisabledOptionKeys());
        }
        if (ccAsset != null && ccField != null) {
            uiField.setRequired(ccField.isRequired());
            uiField.setParentValue(ccField.getDefaultValue());
            uiField.setParentLocked(ccField.isLocked());
        }
        uiField.setReadOnly(readOnly);
        return uiField;
    }

    private UIContentClassFieldGroup createFieldGroup(ComplexVariable var, ContentClassAsset ccAsset, ContentClassAsset partnerAsset, boolean readOnly) {
        String path = var.getXPath();
        if (ccAsset == null) {
            return null;
        }
        ContentClassField ccField = ccAsset.getField(path);
        if (ccField != null && ccField.isDisabled()) {
            return null;
        }
        UIContentClassFieldGroup group = new UIContentClassFieldGroup(var.getXPath());
        group.setDisabled(false);
        group.setDisplayName(var.getDisplayName());
        group.setMultiValue(var.isMultiValue());
        group.setReadOnly(readOnly);
        this.processChildFields(group, var.getChildren(), ccAsset, partnerAsset);
        if (group.isEmpty()) {
            return null;
        }
        return group;
    }
}

