/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.customfield;

import com.tandbergtv.cms.portal.content.client.customfield.enums.FieldTypeOptionsEnum;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomField;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldAsset;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldAssetTree;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldGroup;
import com.tandbergtv.cms.portal.content.client.customfield.rpc.ICustomFieldViewService;
import com.tandbergtv.cms.portal.content.client.exception.CustomFieldDeleteValidationException;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.service.ICustomFieldManager;
import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class CustomFieldViewService
implements ICustomFieldViewService,
NeptuneRemoteService {
    private final ISpecificationManager specificationManager = this.getSpecificationManager();
    private final ICustomFieldManager customFieldManager = this.getCustomFieldManager();
    private static Logger logger = Logger.getLogger(CustomFieldViewService.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    public String getRelativePath() {
        return "service/content/customField/ICustomFieldViewService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    @Transactional
    public UICustomFieldAsset getPkgRootUIAsset() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = CustomFieldViewService.class.getDeclaredMethod("getPkgRootUIAsset", new Class[0]).getAnnotation(Transactional.class);
        }
        return (UICustomFieldAsset)CustomFieldViewService.getPkgRootUIAsset_aroundBody1$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public UICustomFieldAsset getSeriesRootUIAsset() throws NeptuneException {
        UISpecification uiSpecSeries = this.specificationManager.getUISpecification(UISpecification.Type.SERIES);
        TitleConf titleConf = uiSpecSeries.getRootTitleConf();
        UICustomFieldAsset uiAsset = this.getUIRootAsset(titleConf);
        return uiAsset;
    }

    private UICustomFieldAsset getUIRootAsset(TitleConf titleConf) {
        UICustomFieldAsset uiAsset = new UICustomFieldAsset();
        String assetPath = titleConf.getName();
        uiAsset.setAssetPath(assetPath);
        uiAsset.setDisplayName(titleConf.getAlias());
        List<UICustomFieldGroup> groupList = this.getAssetGroupList();
        uiAsset.setGroupList(this.getAssetGroupListForAsset(groupList, uiAsset));
        if (titleConf.hasChildren()) {
            this.addChildrenAssets(titleConf.getChildren(), uiAsset, groupList);
        }
        return uiAsset;
    }

    private List<UICustomFieldGroup> getAssetGroupListForAsset(List<UICustomFieldGroup> groupList, UICustomFieldAsset uiAsset) {
        ArrayList<UICustomFieldGroup> assetGroupList = new ArrayList<UICustomFieldGroup>();
        if (groupList != null && !groupList.isEmpty()) {
            for (UICustomFieldGroup group : groupList) {
                if (!group.getAssetPath().equalsIgnoreCase(uiAsset.getAssetPath())) continue;
                assetGroupList.add(group);
            }
        }
        return assetGroupList;
    }

    private List<UICustomFieldGroup> getAssetGroupList() {
        List groupList = this.customFieldManager.getAllGroups();
        List<UICustomFieldGroup> uiGroupList = this.getUIGroupList(groupList);
        return uiGroupList;
    }

    private List<UICustomFieldGroup> getUIGroupList(List<CustomFieldGroup> groupList) {
        ArrayList<UICustomFieldGroup> uiGroupList = new ArrayList<UICustomFieldGroup>();
        for (CustomFieldGroup group : groupList) {
            UICustomFieldGroup uiGroup = this.getUICustomFieldGroup(group);
            List fieldList = group.getCustomFieldList();
            ArrayList<UICustomField> uiFieldList = new ArrayList<UICustomField>();
            if (fieldList != null) {
                for (CustomField customField : fieldList) {
                    UICustomField uiField = this.getUICustomField(customField);
                    uiField.setGroup(uiGroup);
                    uiFieldList.add(uiField);
                    uiGroup.setFieldList(uiFieldList);
                }
            }
            uiGroupList.add(uiGroup);
        }
        return uiGroupList;
    }

    private UICustomFieldGroup getUICustomFieldGroup(CustomFieldGroup group) {
        UICustomFieldGroup uiGroup = new UICustomFieldGroup();
        uiGroup.setId(group.getId());
        uiGroup.setName(group.getName());
        uiGroup.setDisplayName(group.getDisplayName());
        uiGroup.setAssetPath(group.getAssetPath());
        uiGroup.setUuid(group.getUuid());
        return uiGroup;
    }

    private UICustomField getUICustomField(CustomField customField) {
        UICustomField uiField = new UICustomField();
        uiField.setId(customField.getId());
        uiField.setName(customField.getName());
        uiField.setDisplayName(customField.getDisplayName());
        uiField.setDataType(customField.getDataType());
        uiField.setFieldType(customField.getFieldType());
        uiField.setMultiValue(this.convertToBoolean(customField.getMultiValue()));
        uiField.setJobParameter(this.convertToBoolean(customField.getJobParameter()));
        uiField.setJobScheduleParameter(this.convertToBoolean(customField.getJobScheduleParameter()));
        return uiField;
    }

    private boolean convertToBoolean(String field) {
        return field != null && field.equalsIgnoreCase("Y");
    }

    private void addChildrenAssets(List<TitleConf> childrenList, UICustomFieldAsset uiAsset, List<UICustomFieldGroup> groupList) {
        if (childrenList != null) {
            for (TitleConf child : childrenList) {
                String displayName = child.getAlias();
                String assetPath = child.getPath();
                UICustomFieldAsset childAsset = new UICustomFieldAsset();
                childAsset.setAssetPath(assetPath);
                childAsset.setDisplayName(displayName);
                childAsset.setGroupList(this.getAssetGroupListForAsset(groupList, childAsset));
                uiAsset.addAsset(childAsset);
                if (!child.hasChildren()) continue;
                this.addChildrenAssets(child.getChildren(), childAsset, groupList);
            }
        }
    }

    private ISpecificationManager getSpecificationManager() {
        ISpecificationManager specificationManager = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        return specificationManager;
    }

    private ICustomFieldManager getCustomFieldManager() {
        ICustomFieldManager customFieldManager = (ICustomFieldManager)ServiceRegistry.getDefault().lookup(ICustomFieldManager.class);
        return customFieldManager;
    }

    @Override
    public void saveGroups(List<UICustomFieldGroup> uiGroupList) throws NeptuneException {
        List<CustomFieldGroup> groupList = this.getCustomFieldGroups(uiGroupList);
        try {
            this.customFieldManager.saveGroups(groupList);
        }
        catch (Exception e) {
            if (e.getCause() instanceof CustomFieldDeleteCallbackException) {
                logger.error((Object)("delete custom field error: " + e));
                throw new CustomFieldDeleteValidationException(e.getMessage());
            }
            throw new NeptuneException(e.getMessage());
        }
    }

    private Map<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> createCustomFieldMapForUISpec(List<UICustomFieldGroup> groups) {
        HashMap<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> map = new HashMap<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>>();
        if (groups != null) {
            for (UICustomFieldGroup group : groups) {
                String path = group.getAssetPath();
                ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup> newList = (ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>)map.get(path);
                if (newList == null) {
                    newList = new ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>();
                    map.put(path, newList);
                }
                com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup newGroup = new com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup(group.getUuid(), group.getDisplayName());
                List<UICustomField> list = group.getFieldList();
                if (list != null) {
                    for (UICustomField cf : list) {
                        if (cf.getName() == null || cf.getDisplayName() == null || cf.getName().trim().isEmpty() || cf.getDisplayName().trim().isEmpty()) continue;
                        com.tandbergtv.watchpoint.pmm.title.conf.CustomField newCf = this.createCf(cf);
                        newGroup.fields.add(newCf);
                    }
                }
                newList.add(newGroup);
            }
        }
        return map;
    }

    private com.tandbergtv.watchpoint.pmm.title.conf.CustomField createCf(UICustomField cf) {
        com.tandbergtv.watchpoint.pmm.title.conf.CustomField newCf = new com.tandbergtv.watchpoint.pmm.title.conf.CustomField();
        String type = cf.getDataType();
        if ("Boolean".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.BOOLEAN;
        } else if ("Date".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.DATE;
        } else if ("Float".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.FLOAT;
        } else if ("Integer".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.INTEGER;
        } else if ("String".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.STRING;
        } else if ("Time".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.TIME;
        } else {
            throw new RuntimeException("Invalid data type " + type);
        }
        newCf.displayName = cf.getDisplayName();
        newCf.name = cf.getName();
        newCf.groupId = cf.getGroup().getUuid();
        if (FieldTypeOptionsEnum.fromId(cf.getFieldType()) == FieldTypeOptionsEnum.TEXT_BOX) {
            newCf.dropDown = false;
            newCf.anyValueAllowed = false;
        } else if (FieldTypeOptionsEnum.fromId(cf.getFieldType()) == FieldTypeOptionsEnum.DROP_DOWN) {
            newCf.anyValueAllowed = false;
            newCf.dropDown = true;
        } else if (FieldTypeOptionsEnum.fromId(cf.getFieldType()) == FieldTypeOptionsEnum.COMBO_BOX) {
            newCf.dropDown = true;
            newCf.anyValueAllowed = true;
        } else if (FieldTypeOptionsEnum.fromId(cf.getFieldType()) == FieldTypeOptionsEnum.TEXT_AREA) {
            newCf.dropDown = false;
            newCf.anyValueAllowed = false;
            newCf.multiLine = true;
        }
        newCf.multiValue = cf.isMultiValue();
        newCf.jobParameter = cf.isJobParameter();
        newCf.jobScheduleParameter = cf.isJobScheduleParameter();
        return newCf;
    }

    private List<CustomFieldGroup> getCustomFieldGroups(List<UICustomFieldGroup> uiGroupList) {
        ArrayList<CustomFieldGroup> groupList = new ArrayList<CustomFieldGroup>();
        for (UICustomFieldGroup uiGroup : uiGroupList) {
            CustomFieldGroup group = new CustomFieldGroup();
            if (uiGroup.getId() == 0L) {
                group.setId(null);
            } else {
                group.setId(Long.valueOf(uiGroup.getId()));
            }
            group.setDisplayName(uiGroup.getDisplayName());
            group.setName(uiGroup.getName());
            group.setAssetPath(uiGroup.getAssetPath());
            if (uiGroup.getUuid() == null && uiGroup.getId() == 0L) {
                uiGroup.setUuid(UUID.randomUUID().toString());
            }
            group.setUuid(uiGroup.getUuid());
            List<UICustomField> fieldList = uiGroup.getFieldList();
            if (fieldList != null) {
                for (UICustomField uiField : fieldList) {
                    if (uiField.getName() == null || uiField.getDisplayName() == null || uiField.getName().trim().isEmpty() || uiField.getDisplayName().trim().isEmpty()) continue;
                    CustomField field = new CustomField();
                    if (uiField.getId() == 0L) {
                        field.setId(null);
                    } else {
                        field.setId(Long.valueOf(uiField.getId()));
                    }
                    field.setName(uiField.getName());
                    field.setDisplayName(uiField.getDisplayName());
                    field.setDataType(uiField.getDataType());
                    field.setFieldType(uiField.getFieldType());
                    field.setMultiValue(this.convert(uiField.isMultiValue()));
                    field.setJobParameter(this.convert(uiField.isJobParameter()));
                    field.setJobScheduleParameter(this.convert(uiField.isJobScheduleParameter()));
                    field.setGroup(group);
                    group.addCustomField(field);
                }
            }
            groupList.add(group);
        }
        return groupList;
    }

    private String convert(boolean value) {
        String token = value ? "Y" : "N";
        return token;
    }

    @Override
    @Transactional
    public UICustomFieldAssetTree getUIAssetTree() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = CustomFieldViewService.class.getDeclaredMethod("getUIAssetTree", new Class[0]).getAnnotation(Transactional.class);
        }
        return (UICustomFieldAssetTree)CustomFieldViewService.getUIAssetTree_aroundBody3$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public boolean isValidField(String name, String displayName, String path, String groupDisplayName) throws NeptuneException {
        return this.customFieldManager.isValidField(name, displayName, path, groupDisplayName);
    }

    @Override
    public void deleteCustomField(UICustomField uiField) {
        CustomField field = this.getCustomField(uiField);
        this.customFieldManager.deleteCustomField(field);
    }

    private CustomField getCustomField(UICustomField uiField) {
        CustomField field = new CustomField();
        field.setId(Long.valueOf(uiField.getId()));
        field.setName(uiField.getName());
        field.setDisplayName(uiField.getDisplayName());
        field.setDataType(uiField.getDataType());
        field.setJobParameter(this.convert(uiField.isJobParameter()));
        field.setJobScheduleParameter(this.convert(uiField.isJobScheduleParameter()));
        return field;
    }

    @Override
    public void deleteCustomFieldGroup(UICustomFieldGroup uiGroup) {
        CustomFieldGroup group = this.getCustomFieldGroup(uiGroup);
        this.customFieldManager.deleteCustomFieldGroup(group);
    }

    private CustomFieldGroup getCustomFieldGroup(UICustomFieldGroup uiGroup) {
        CustomFieldGroup group = new CustomFieldGroup();
        group.setUuid(uiGroup.getUuid());
        group.setId(Long.valueOf(uiGroup.getId()));
        group.setDisplayName(uiGroup.getDisplayName());
        group.setAssetPath(uiGroup.getAssetPath());
        if (uiGroup.getFieldList() != null) {
            for (UICustomField uiField : uiGroup.getFieldList()) {
                CustomField field = this.getCustomField(uiField);
                group.addCustomField(field);
                field.setGroup(group);
            }
        }
        return group;
    }

    private static final /* synthetic */ UICustomFieldAsset getPkgRootUIAsset_aroundBody0(CustomFieldViewService ajc$this) {
        UISpecification uiSpecPkg = ajc$this.specificationManager.getUISpecification(UISpecification.Type.PACKAGE);
        TitleConf titleConf = uiSpecPkg.getRootTitleConf();
        UICustomFieldAsset uiAsset = ajc$this.getUIRootAsset(titleConf);
        return uiAsset;
    }

    private static final /* synthetic */ Object getPkgRootUIAsset_aroundBody1$advice(CustomFieldViewService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return CustomFieldViewService.getPkgRootUIAsset_aroundBody0(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UICustomFieldAsset object = CustomFieldViewService.getPkgRootUIAsset_aroundBody0(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UICustomFieldAssetTree getUIAssetTree_aroundBody2(CustomFieldViewService ajc$this) {
        UICustomFieldAssetTree tree = new UICustomFieldAssetTree();
        UICustomFieldAsset pkgAsset = ajc$this.getPkgRootUIAsset();
        UICustomFieldAsset seriesAsset = ajc$this.getSeriesRootUIAsset();
        tree.setPkgAsset(pkgAsset);
        tree.setSeriesAsset(seriesAsset);
        return tree;
    }

    private static final /* synthetic */ Object getUIAssetTree_aroundBody3$advice(CustomFieldViewService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return CustomFieldViewService.getUIAssetTree_aroundBody2(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UICustomFieldAssetTree object = CustomFieldViewService.getUIAssetTree_aroundBody2(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

