/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.infoprovider;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.server.util.HostnameResolver;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.infoprovider.IServerInfoProvider;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.IAssetTypesConfigurationService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class PreferenceProvider
implements IServerInfoProvider {
    private static String UI_PREFERENCE_PATH = "com.ericsson.cms.contentmgmt.ui";
    private static String FILEUPLOAD_SETTINGS_PATH = "com.ericsson.cms.contentmgmt.fileupload";
    private static String VIDEOPLAYER_SETTINGS_PATH = "com.ericsson.cms.contentmgmt.videoplayer";
    private static String SERIES_SETTINGS_PATH = "com.ericsson.cms.contentmgmt.seriesidentifiers";
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String VIDEO_PREVIEW_LIC_KEY = "VideoPreviewLicense";
    private static final String CATEGORY_MANAGER_LIC_KEY = "CategoryManagerLicense";
    private static final String METADATA_ENHANCEMENT_LIC_KEY = "MetadataEnhancementLicense";
    private static final String FTP_URL_KEY = "reg_url";
    private static final String STREAMING_SERVER_KEY = "streamer";
    private static final String PROGRESSIVE_DWNLD_SERVER_KEY = "progressiveDwnldServer";
    IConfigurationService configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
    IAssetSpecificationManager specificationManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    ILicenseManager licenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
    private Logger logger = Logger.getLogger(PreferenceProvider.class);
    IAssetTypesConfigurationService assetTypesConfigurationService = (IAssetTypesConfigurationService)ServiceRegistry.getDefault().lookup(IAssetTypesConfigurationService.class);

    public Map<String, String> getInfo() {
        Map preferences = this.configurationService.getProperties(UI_PREFERENCE_PATH);
        String strImageAssetTypes = this.assetTypesConfigurationService.getImageAssetTypesValue();
        preferences.put("ContentComponent.imageAssetTypes", strImageAssetTypes);
        String strVideoAssetTypes = this.assetTypesConfigurationService.getVideoAssetTypesValue();
        preferences.put("ContentComponent.videoAssetTypes", strVideoAssetTypes);
        preferences.put(VIDEO_PREVIEW_LIC_KEY, this.getLincenseInfo(VIDEO_PREVIEW_LIC_KEY));
        preferences.put(CATEGORY_MANAGER_LIC_KEY, this.getCategoryManagerLincenseInfo());
        preferences.put(METADATA_ENHANCEMENT_LIC_KEY, this.getMetadataEnhancementLincenseInfo());
        return preferences;
    }

    private String getCategoryManagerLincenseInfo() {
        String isLicensed;
        block3: {
            try {
                isLicensed = this.licenseManager.getProperty(CATEGORY_MANAGER_LIC_KEY);
                if (isLicensed != null && !isLicensed.isEmpty()) break block3;
                return "false";
            }
            catch (InvalidLicenseException e) {
                this.logger.error((Object)"Error reading license file for CategoryManagerLicense:", (Throwable)e);
                return "false";
            }
        }
        return isLicensed;
    }

    private String getMetadataEnhancementLincenseInfo() {
        String isLicensed;
        block3: {
            try {
                isLicensed = this.licenseManager.getProperty(METADATA_ENHANCEMENT_LIC_KEY);
                if (isLicensed != null && !isLicensed.isEmpty()) break block3;
                return "false";
            }
            catch (InvalidLicenseException e) {
                this.logger.error((Object)"Error reading license file for MetadataEnhancementLicense:", (Throwable)e);
                return "false";
            }
        }
        return isLicensed;
    }

    private String getLincenseInfo(String licKey) {
        String isLicensed;
        try {
            isLicensed = this.licenseManager.getProperty(licKey);
            if (isLicensed == null || isLicensed.isEmpty()) {
                isLicensed = "true";
            }
        }
        catch (InvalidLicenseException e) {
            isLicensed = "false";
            this.logger.error((Object)("Error reading license file for " + licKey + ":"), (Throwable)e);
        }
        return isLicensed;
    }

    public Map<String, String> getFileUploadParams() {
        Map fileUploadParams = this.configurationService.getProperties(FILEUPLOAD_SETTINGS_PATH);
        this.replaceURLWithIP(fileUploadParams, FTP_URL_KEY);
        return fileUploadParams;
    }

    public Map<String, String> getVideoPlayerParams() {
        try {
            Map videoPlayerParams = this.configurationService.getProperties(VIDEOPLAYER_SETTINGS_PATH);
            this.replaceURLWithIP(videoPlayerParams, STREAMING_SERVER_KEY);
            this.replaceURLWithIP(videoPlayerParams, PROGRESSIVE_DWNLD_SERVER_KEY);
            return videoPlayerParams;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            return null;
        }
    }

    public Map<String, String> getSeriesIdentifiers() {
        Map seriesIdentifierParams = this.configurationService.getProperties(SERIES_SETTINGS_PATH);
        return seriesIdentifierParams;
    }

    public DateFormat getDateFormat(String formatKey, DateFormat defaultFormat) {
        try {
            String format = this.getInfo().get(formatKey);
            if (format != null && format.trim().length() > 0) {
                return new SimpleDateFormat(format);
            }
            return defaultFormat;
        }
        catch (Exception exception) {
            return defaultFormat;
        }
    }

    public DateFormat getDateFormat(String formatKey) {
        return this.getDateFormat(formatKey, DEFAULT_DATE_FORMAT);
    }

    private void replaceURLWithIP(Map<String, String> props, String key) {
        String url = props.get(key);
        if (url == null || url.trim().isEmpty()) {
            return;
        }
        try {
            url = HostnameResolver.replaceURIWithIP(url);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to resolve IP  for : " + url), (Throwable)ex);
        }
        props.put(key, url);
    }

    public int getMaxWorkOrderCount(String setting) {
        String settingValue = (String)this.configurationService.getProperties(UI_PREFERENCE_PATH).get(setting);
        return settingValue == null ? 100 : Integer.parseInt(settingValue);
    }
}

