/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.lookupkey;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiAssetType;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiLookupKey;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyService;
import com.tandbergtv.content.lookupkey.entities.LookupKey;
import com.tandbergtv.content.lookupkey.service.ILookupKeyManager;
import com.tandbergtv.content.lookupkey.service.LookupKeyValidationException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LookupKeyServiceImpl
implements ILookupKeyService,
NeptuneRemoteService {
    private ILookupKeyManager lookupKeyManager = (ILookupKeyManager)InjectionUtil.injectInstance((String)"cms/LookupKeyManagerServiceProxy/local", ILookupKeyManager.class);
    private IAssetSpecificationManager specManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    private ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
    private List<UiAssetType> assetTypesList = this.getAllAssetTypes();

    public String getRelativePath() {
        return "service/content/lookupKeyService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public UiLookupKey get(long id) throws NeptuneException {
        LookupKey lookupKey;
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"LookupKeyManagement_View"});
        try {
            lookupKey = this.lookupKeyManager.get(id);
        }
        catch (Exception e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
        return this.createUIObject(lookupKey);
    }

    @Override
    public UiLookupKey save(UiLookupKey lookupKey) throws NeptuneException {
        if (lookupKey.getKey() == null) {
            NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"LookupKeyManagement_Create"});
        } else {
            NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"LookupKeyManagement_Modify"});
        }
        LookupKey savedLookupKey = null;
        try {
            savedLookupKey = this.lookupKeyManager.save(this.createServerObject(lookupKey));
        }
        catch (Exception e) {
            if (e.getCause() instanceof LookupKeyValidationException) {
                throw new ValidationException(((LookupKeyValidationException)e.getCause()).getValidationMessages());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
        return this.createUIObject(savedLookupKey);
    }

    @Override
    public List<UiLookupKey> getLookupKeys(String sortByProperty, boolean isAscending) throws NeptuneException {
        List serverLookupKeysList = new ArrayList();
        try {
            serverLookupKeysList = this.lookupKeyManager.getLookupKeys(sortByProperty, isAscending);
        }
        catch (Exception e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
        ArrayList<UiLookupKey> uiLookupKeysList = new ArrayList<UiLookupKey>();
        for (LookupKey lookupKey : serverLookupKeysList) {
            uiLookupKeysList.add(this.createUIObject(lookupKey));
        }
        return uiLookupKeysList;
    }

    @Override
    public List<UiLookupKey> getLookupKeysByAssetType(String assetType) throws NeptuneException {
        List serverLookupKeysList = new ArrayList();
        try {
            serverLookupKeysList = this.lookupKeyManager.getLookupKeysByAssetType(assetType);
        }
        catch (Exception e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
        ArrayList<UiLookupKey> uiLookupKeysList = new ArrayList<UiLookupKey>();
        for (LookupKey lookupKey : serverLookupKeysList) {
            uiLookupKeysList.add(this.createUIObject(lookupKey));
        }
        return uiLookupKeysList;
    }

    @Override
    public List<UiAssetType> getAllAssetTypes() {
        ArrayList<UiAssetType> assetTypesList = new ArrayList<UiAssetType>();
        List titleConfList = this.specManager.getUISpecification(UISpecification.Type.PACKAGE).getAllTitleConf();
        List titleConfListSeries = this.specManager.getUISpecification(UISpecification.Type.SERIES).getAllTitleConf();
        for (TitleConf titleConf : titleConfList) {
            if (this.assetTypeAlreadyAdded(assetTypesList, titleConf.getName())) continue;
            assetTypesList.add(new UiAssetType(titleConf.getName(), titleConf.getAlias()));
        }
        for (TitleConf titleConf : titleConfListSeries) {
            if (this.assetTypeAlreadyAdded(assetTypesList, titleConf.getName())) continue;
            assetTypesList.add(new UiAssetType(titleConf.getName(), titleConf.getAlias()));
        }
        return assetTypesList;
    }

    private boolean assetTypeAlreadyAdded(List<UiAssetType> assetTypesList, String name) {
        boolean alreadyAdded = false;
        for (UiAssetType uiAssetType : assetTypesList) {
            if (!uiAssetType.getName().equalsIgnoreCase(name)) continue;
            alreadyAdded = true;
            break;
        }
        return alreadyAdded;
    }

    private UiLookupKey createUIObject(LookupKey lookupKey) {
        UiLookupKey uiLookupKey = new UiLookupKey();
        if (lookupKey != null) {
            uiLookupKey.setKey(lookupKey.getId());
            uiLookupKey.setName(lookupKey.getName());
            uiLookupKey.setDescription(lookupKey.getDescription());
            uiLookupKey.setReadOnly(lookupKey.getName().equalsIgnoreCase("ORIGINAL"));
            for (String assetType : lookupKey.getAssetTypes()) {
                uiLookupKey.getAssetTypes().add(new UiAssetType(assetType, this.getAssetTypeDisplayName(assetType)));
            }
        }
        return uiLookupKey;
    }

    private String getAssetTypeDisplayName(String assetName) {
        String assetDisplayName = assetName;
        for (UiAssetType uiAssetType : this.assetTypesList) {
            if (!uiAssetType.getName().equalsIgnoreCase(assetName)) continue;
            assetDisplayName = uiAssetType.getDisplayName();
            break;
        }
        return assetDisplayName;
    }

    private LookupKey createServerObject(UiLookupKey uiLookupKey) {
        LookupKey lookupKey = new LookupKey();
        if (uiLookupKey.getKey() != null) {
            lookupKey.setId(uiLookupKey.getKey());
        }
        lookupKey.setName(uiLookupKey.getName());
        lookupKey.setDescription(uiLookupKey.getDescription());
        for (UiAssetType uiAssetType : uiLookupKey.getAssetTypes()) {
            lookupKey.getAssetTypes().add(uiAssetType.getName());
        }
        return lookupKey;
    }

    private int delete(long lookupKeyId) throws NeptuneException {
        return this.lookupKeyManager.delete(lookupKeyId);
    }

    private boolean isLookupKeyAssociatedWithAsset(long lookupKeyId) throws TitleValidationException {
        long hits = 0L;
        HashSet<String> fields = new HashSet<String>();
        String xpath = "*/FILE/CustomFields/LookupKey";
        fields.add(xpath);
        String lookupKeyName = this.lookupKeyManager.get(lookupKeyId).getName();
        hits = this.titleManager.getClusterWideSearchCount(fields, lookupKeyName);
        return hits > 0L;
    }

    @Override
    public Map<Long, Boolean> delete(List<Long> lookupKeyIds) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"LookupKeyManagement_Delete"});
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>();
        try {
            for (Long lookupKeyId : lookupKeyIds) {
                if (this.isLookupKeyAssociatedWithAsset(lookupKeyId)) {
                    result.put(lookupKeyId, false);
                    continue;
                }
                this.delete(lookupKeyId);
                result.put(lookupKeyId, true);
            }
        }
        catch (Exception e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
        return result;
    }
}

