/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.portlet;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ActivityPortletData;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ActivityPortletRecord;
import com.tandbergtv.cms.portal.content.client.portlet.activity.IActivityPortletService;
import com.tandbergtv.cms.portal.content.server.infoprovider.PreferenceProvider;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.activity.ITitleActivity;
import com.tandbergtv.watchpoint.pmm.entities.activity.ITitleActivitySearchCriteria;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivitySearchCriteria;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivityType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleActivityService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.ProcessStatus;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ActivityPortletService
implements IActivityPortletService,
NeptuneRemoteService {
    private ITitleActivityService titleActivityService = (ITitleActivityService)InjectionUtil.injectInstance((String)"cms/TitleActivityServiceProxy/local", ITitleActivityService.class);
    private ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private static final IPartnerUserManager parnterService = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
    private static final String DATE_FORMAT_KEY = "ContentComponent.portlets.dateFormat";
    private static final int MAX_PAGE_COUNT = 100;
    PreferenceProvider preferenceProvider = new PreferenceProvider();

    @Override
    public ActivityPortletData getData(int recordCount) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        List partners = parnterService.getPartnersByUserName(userName);
        if (partners.size() == 0 || recordCount <= 0) {
            return new ActivityPortletData();
        }
        ArrayList<String> providerIds = new ArrayList<String>();
        for (Partner p : partners) {
            if (p.getType().equals((Object)PartnerType.SELF)) {
                providerIds = new ArrayList();
                break;
            }
            providerIds.add(p.getProviderId());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        ArrayList<ActivityPortletRecord> records = new ArrayList<ActivityPortletRecord>();
        int startRecord = 0;
        TitleActivitySearchCriteria criteria = new TitleActivitySearchCriteria(this.getActivityTypes(), Integer.valueOf(0), Integer.valueOf(100), providerIds);
        Long count = this.titleActivityService.countActivity((ITitleActivitySearchCriteria)criteria);
        while ((long)startRecord < count && records.size() < recordCount) {
            List activityList = this.titleActivityService.getActivity((ITitleActivitySearchCriteria)criteria);
            for (ITitleActivity activity : activityList) {
                if (!this.titleManager.isActive(activity.getTitleId())) continue;
                records.add(this.createRecord(activity, dateFormat));
                if (records.size() == recordCount) break;
            }
            criteria.setStartRecord(Integer.valueOf(startRecord += 100));
        }
        return new ActivityPortletData(records);
    }

    private ActivityPortletRecord createRecord(ITitleActivity activity, DateFormat dateFormat) {
        String title = String.valueOf(activity.getTitleId());
        Long processId = activity.getShallowWorkFlowProcess().getProcessId();
        String processName = activity.getShallowWorkFlowProcess().getProcessDefinitionName();
        Date startTime = activity.getShallowWorkFlowProcess().getToken().getStartTime();
        int statusCode = activity.getShallowWorkFlowProcess().getToken().getOperationalStatus();
        String statusName = ProcessStatus.values()[statusCode].toString();
        String toolTip = null;
        if (ProcessStatus.ERROR.ordinal() == statusCode) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            toolTip = String.valueOf(sdf.format(activity.getShallowWorkFlowProcess().getToken().getErrorTime())) + " " + activity.getShallowWorkFlowProcess().getToken().getErrorComment();
        }
        DistributionSite site = this.siteManager.getAssociatedDistributionSite(activity.getTitleId().longValue());
        String siteName = "";
        Integer siteId = null;
        if (site != null) {
            siteId = site.getId();
            siteName = site.getName();
        }
        ActivityPortletRecord rec = new ActivityPortletRecord();
        rec.setTitleId(activity.getTitleId());
        rec.setTitle(title);
        rec.setSiteId(siteId);
        rec.setSiteName(siteName);
        rec.setProcessId(processId);
        rec.setProcessName(processName);
        rec.setStartTime(this.safeFormat(startTime, dateFormat));
        rec.setStatusName(statusName);
        rec.setStatusToolTip(toolTip);
        return rec;
    }

    private String safeFormat(Date date, DateFormat dateFormat) {
        if (date == null || dateFormat == null) {
            return null;
        }
        try {
            return dateFormat.format(date);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getRelativePath() {
        return "service/portlet/ActivityPortletService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private Set<TitleActivityType> getActivityTypes() {
        HashSet<TitleActivityType> activityTypes = new HashSet<TitleActivityType>();
        activityTypes.add(TitleActivityType.CURRENT);
        return activityTypes;
    }
}

