/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.portlet;

import com.tandbergtv.cms.portal.content.client.portlet.cmsusage.CMSUsagePortletData;
import com.tandbergtv.cms.portal.content.client.portlet.cmsusage.CMSUsagePortletRecord;
import com.tandbergtv.cms.portal.content.client.portlet.cmsusage.ICMSUsagePortletService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.LicenseMonitor;
import java.util.ArrayList;

public class CMSUsagePortletService
implements ICMSUsagePortletService,
NeptuneRemoteService {
    private LicenseMonitor licenseMonitor = LicenseMonitor.getInstance();
    private long masterTitleCount;
    private long siteTitleCount;
    private long distributedTitleCount;
    private long ingestTitleCount;

    @Override
    public CMSUsagePortletData getData() throws NeptuneException {
        ArrayList<CMSUsagePortletRecord> records = new ArrayList<CMSUsagePortletRecord>();
        int startRecord = 1;
        while (startRecord < 5) {
            records.add(this.createRecord(startRecord));
            ++startRecord;
        }
        return new CMSUsagePortletData(records);
    }

    private CMSUsagePortletRecord createRecord(int rownum) {
        CMSUsagePortletRecord rec = new CMSUsagePortletRecord();
        rec.setCurrentCount(this.getCurrentCount(rownum));
        rec.setLabel(this.getTitle(rownum));
        rec.setMaxValue(this.getMaxCount(rownum));
        rec.setPercentage(this.getPercentageUsed(rownum));
        rec.setThreshold(this.getThreshold(rownum));
        return rec;
    }

    public String getRelativePath() {
        return "service/portlet/CMSUsagePortletService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private String getTitle(int row) {
        switch (row) {
            case 1: {
                return "Master Titles in Library";
            }
            case 2: {
                return "Site Titles in Library";
            }
            case 3: {
                return "Titles Distributed Calendar Month";
            }
            case 4: {
                return "Titles Ingested Calendar Month";
            }
        }
        return null;
    }

    private Long getCurrentCount(int row) {
        switch (row) {
            case 1: {
                this.masterTitleCount = this.getMasterTitleCount();
                return this.masterTitleCount;
            }
            case 2: {
                this.siteTitleCount = this.getSiteTitleCount();
                return this.siteTitleCount;
            }
            case 3: {
                this.distributedTitleCount = this.getDistributedTitleCount();
                return this.distributedTitleCount;
            }
            case 4: {
                this.ingestTitleCount = this.getIngestTitleCount();
                return this.ingestTitleCount;
            }
        }
        return 0L;
    }

    private long getIngestTitleCount() {
        return this.licenseMonitor.getIngestTitleCount();
    }

    private long getDistributedTitleCount() {
        return this.licenseMonitor.getDistributionTitleCount();
    }

    private long getSiteTitleCount() {
        return this.licenseMonitor.getSiteTitleCount();
    }

    private long getMasterTitleCount() {
        return this.licenseMonitor.getMasterTitleCount();
    }

    private long getMaxCount(int row) {
        switch (row) {
            case 1: {
                return this.getMasterTitleLicenseLimit();
            }
            case 2: {
                return this.getSiteTitleLicenseLimit();
            }
            case 3: {
                return this.getDistributedTitleLicenseLimit();
            }
            case 4: {
                return this.getIngestTitleLicenseLimit();
            }
        }
        return 0L;
    }

    private long getIngestTitleLicenseLimit() {
        try {
            Long maxLicense = this.licenseMonitor.getMaxIngestTitleCount();
            return maxLicense != null ? maxLicense : 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private long getDistributedTitleLicenseLimit() {
        try {
            Long maxLicense = this.licenseMonitor.getMaxDistributionTitleCount();
            return maxLicense != null ? maxLicense : 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Long getMasterTitleLicenseLimit() {
        try {
            Long maxLicense = this.licenseMonitor.getMaxMasterTitleCount();
            return maxLicense != null ? maxLicense : 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Long getSiteTitleLicenseLimit() {
        try {
            Long maxLicense = this.licenseMonitor.getMaxSiteTitleCount();
            return maxLicense != null ? maxLicense : 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private long getThreshold(int row) {
        switch (row) {
            case 1: {
                return this.licenseMonitor.getThresholdMasterTitleCount();
            }
            case 2: {
                return this.licenseMonitor.getThresholdSiteTitleCount();
            }
            case 3: {
                return this.licenseMonitor.getThresholdDistributionTitleCount();
            }
            case 4: {
                return this.licenseMonitor.getThresholdIngestTitleCount();
            }
        }
        return 0L;
    }

    private Double getPercentageUsed(int row) {
        switch (row) {
            case 1: {
                long maxMaster = this.getMasterTitleLicenseLimit();
                if (maxMaster == 0L) break;
                return this.masterTitleCount * 100L / maxMaster;
            }
            case 2: {
                long maxSite = this.getSiteTitleLicenseLimit();
                if (maxSite == 0L) break;
                return this.siteTitleCount * 100L / maxSite;
            }
            case 3: {
                long maxDist = this.getDistributedTitleLicenseLimit();
                if (maxDist == 0L) break;
                return this.distributedTitleCount * 100L / maxDist;
            }
            case 4: {
                long maxIngest = this.getIngestTitleLicenseLimit();
                if (maxIngest == 0L) break;
                return this.ingestTitleCount * 100L / maxIngest;
            }
            default: {
                return 0.0;
            }
        }
        return 0.0;
    }
}

