/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.portlet.modified;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.model.portlet.modified.ModifiedTitleRecord;
import com.tandbergtv.cms.portal.content.client.model.portlet.modified.ModifiedTitlesData;
import com.tandbergtv.cms.portal.content.client.model.portlet.modified.TitleMetadata;
import com.tandbergtv.cms.portal.content.client.portlet.modified.IModifiedTitlesListPortletService;
import com.tandbergtv.cms.portal.content.server.infoprovider.PreferenceProvider;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.UnauthorizedUserException;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.search.SearchPartnerProvider;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class ModifiedTitlesListPortletServiceImpl
implements NeptuneRemoteService,
IModifiedTitlesListPortletService {
    private static final Logger logger = Logger.getLogger(ModifiedTitlesListPortletServiceImpl.class);
    private ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
    private IAssetSpecificationManager specManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    private ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
    private int startIndex = 0;
    private static final String DATE_FORMAT_KEY = "ContentComponent.portlets.dateFormat";
    private PreferenceProvider preferenceProvider = new PreferenceProvider();
    private static final int DEFAULT_MAX_COUNT = 10;
    private static final String MAX_TITLE_COUNT = "ContentComponent.portlets.titlesModified.total";
    private static final String TABLE_NAME = "title.portlet.Metadata";
    private static final String TITLE_LAST_MODIFIED_PROPERTY = "lastModifiedTime";
    private static final String TITLE_STATUS_PROPERTY = "status";

    public String getRelativePath() {
        return "service/content/portlet/IModifiedTitlesListPortletService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public ModifiedTitlesData getData() throws NeptuneException {
        List partnerIds;
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        try {
            partnerIds = SearchPartnerProvider.getParnterIds((String)userName);
        }
        catch (UnauthorizedUserException unauthorizedUserException) {
            return new ModifiedTitlesData();
        }
        return this.buildPortletData(partnerIds);
    }

    private int getMaxTitleCount() {
        int count;
        block3: {
            PreferenceProvider reader = new PreferenceProvider();
            String countStr = reader.getInfo().get(MAX_TITLE_COUNT);
            try {
                count = Integer.parseInt(countStr.trim());
                if (count > 0 && count <= 10) break block3;
                return 10;
            }
            catch (Exception exception) {
                return 10;
            }
        }
        return count;
    }

    private List<SearchColumn> getTableColumns() {
        ArrayList<SearchColumn> result = new ArrayList<SearchColumn>();
        Table table = this.specManager.getTableConfiguration(TABLE_NAME);
        List cols = table.getColumns();
        for (Column c : cols) {
            String xpath = c.getParameter();
            String assetType = c.getTitleSection();
            String dataType = "string";
            boolean isMetaData = c.getSortingProperty().equals("metadata");
            FieldType fieldType = FieldType.PMM_TITLE;
            if (isMetaData) {
                fieldType = FieldType.ASSET;
            }
            if (isMetaData) {
                dataType = DataTypeMappingReader.getInstance().determineDataType(xpath);
            }
            result.add(new SearchColumn(assetType, xpath, fieldType, dataType, false));
        }
        return result;
    }

    private ModifiedTitlesData buildPortletData(List<Long> partnerIds) {
        ModifiedTitlesData data = new ModifiedTitlesData();
        List<SearchColumn> searchColumns = this.getColumns();
        TitleFilter tFilter = new TitleFilter(null, this.getSortInfo(), this.getPageInfo());
        tFilter.setCriteriaMode(CriteriaMode.MASTER);
        TitleSearchResult result = this.searchService.getSearchResults(tFilter, partnerIds, searchColumns);
        List searchRows = result.getRows();
        DateFormat uiDateFormat = this.preferenceProvider.getDateFormat(DATE_FORMAT_KEY);
        for (TitleSearchResult.SearchRow sr : searchRows) {
            long titleId = sr.getId();
            String status = sr.getFirstValueAsString(0);
            String lastModifedDateServer = sr.getFirstValueAsString(1);
            String lastModifedDateUI = "N/A";
            SimpleDateFormat serverDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = serverDateFormat.parse(lastModifedDateServer);
                lastModifedDateUI = uiDateFormat.format(date);
            }
            catch (Exception ex) {
                logger.warn((Object)ex);
            }
            ArrayList<TitleMetadata> titleMetaData = new ArrayList<TitleMetadata>();
            int i = 2;
            while (i < sr.getFields().size()) {
                String value = sr.getFirstValueAsString(i);
                String assetType = searchColumns.get(i).getSectionType();
                String xpath = searchColumns.get(i).getFieldName();
                titleMetaData.add(new TitleMetadata(xpath, value, assetType));
                ++i;
            }
            Boolean isOffer = this.isOffer(titleId);
            ModifiedTitleRecord record = new ModifiedTitleRecord(titleId, titleMetaData, status, lastModifedDateUI, isOffer);
            data.addRecord(record);
        }
        return data;
    }

    private List<SearchColumn> getColumns() {
        ArrayList<SearchColumn> results = new ArrayList<SearchColumn>();
        results.add(new SearchColumn("", TITLE_STATUS_PROPERTY, FieldType.PMM_TITLE, "string", false));
        results.add(new SearchColumn("", TITLE_LAST_MODIFIED_PROPERTY, FieldType.PMM_TITLE, "date", false));
        results.addAll(this.getTableColumns());
        return results;
    }

    private PagingInfo getPageInfo() {
        return new PagingInfo(this.getStartIndex(), this.getMaxTitleCount());
    }

    private SortingInfo getSortInfo() {
        return new SortingInfo(TITLE_LAST_MODIFIED_PROPERTY, SortOrder.DESCENDING, null, FieldType.PMM_TITLE);
    }

    private Boolean isOffer(Long titleId) {
        Boolean isOfferTitle = false;
        try {
            isOfferTitle = this.titleManager.isOffer(titleId);
        }
        catch (TitleValidationException e) {
            e.printStackTrace();
        }
        return isOfferTitle;
    }
}

