/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.search.export;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.cms.portal.content.server.search.export.TitleSearchExportService;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterQuickSearch;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.server.search.UiTitleFilterService;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.TitleSearchPropertiesProvider;
import com.tandbergtv.cms.title.search.entities.UnauthorizedUserException;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.watchpoint.pmm.title.search.ExportHelper;
import com.tandbergtv.watchpoint.pmm.title.search.SearchPartnerProvider;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ExportSearchToExcelServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(ExportSearchToExcelServlet.class);
    private ITitleSearchService searchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
    private static TitleSearchExportService tses = TitleSearchExportService.getInstance();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        ServletOutputStream out;
        resp.setContentType("application/vnd.ms-excel");
        String guid = req.getParameter("GUID");
        TitleSearchExportService.SearchCriteria sc = tses.getEntry(guid);
        if (sc == null) {
            try {
                resp.sendError(500, "Uknown GUID: " + guid);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            return;
        }
        resp.addHeader("Content-Disposition", "attachment; filename=searchResults.csv");
        UITitleFilter titleFilter = sc.getFilter();
        try {
            out = resp.getOutputStream();
        }
        catch (IOException e) {
            logger.error((Object)e);
            return;
        }
        List<ExportHelper.ColumnInfo> columnInfos = ExportSearchToExcelServlet.getDisplayColumns(sc.getUiColumns());
        ArrayList<SearchColumn> searchColumns = new ArrayList<SearchColumn>(columnInfos.size());
        for (ExportHelper.ColumnInfo columnInfo : columnInfos) {
            searchColumns.add((SearchColumn)columnInfo);
        }
        ExportHelper exportHelper = new ExportHelper((OutputStream)out, Charset.forName("UTF-8"), columnInfos);
        try {
            exportHelper.addHeader();
            String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
            List partnerIds = SearchPartnerProvider.getParnterIds((String)userName);
            this.streamSearchResults(out, titleFilter, partnerIds, exportHelper, searchColumns);
            out.close();
        }
        catch (UnauthorizedUserException unauthorizedUserException) {
            logger.warn((Object)"A user tried to export a search when they aren't associated with any partners.");
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            try {
                resp.sendError(500, ex.toString());
            }
            catch (IOException e1) {
                logger.error((Object)e1);
            }
            return;
        }
    }

    public static List<ExportHelper.ColumnInfo> getDisplayColumns(List<UiColumn> uiColumns) {
        ArrayList<ExportHelper.ColumnInfo> result = new ArrayList<ExportHelper.ColumnInfo>();
        for (UiColumn uiCol : uiColumns) {
            ExportHelper.ColumnInfo sc = new ExportHelper.ColumnInfo(uiCol.getDisplayName(), uiCol.isQuickInfoField(), uiCol.getName(), uiCol.getSectionName(), FieldType.valueOf((String)uiCol.getFieldType().name()), uiCol.getDataType().name(), uiCol.isMultiValued());
            if (uiCol.isQuickInfoField()) {
                sc.setQuickInfoField(true);
            }
            result.add(sc);
        }
        return result;
    }

    private void streamSearchResults(ServletOutputStream out, UITitleFilter titleFilter, List<Long> partnerIds, ExportHelper exportHelper, List<SearchColumn> searchColumns) throws Exception {
        int maxRecord = TitleSearchPropertiesProvider.getMaxTitlesFetchSize();
        CriteriaMode criteriaMode = UiCriteriaMode.SERIES == titleFilter.getCriteriaMode() ? CriteriaMode.SERIES : CriteriaMode.MASTER;
        TitleSearchResult searchResults = null;
        if (titleFilter.getRootNode() instanceof UITitleFilterQuickSearch) {
            String searchText = ((UITitleFilterQuickSearch)titleFilter.getRootNode()).getSearchText();
            SortingInfo sortInfo = new SortingInfo(titleFilter.getSortInfo().getSortColumnName(), SortOrder.valueOf((String)titleFilter.getSortInfo().getSortOrder().name()), titleFilter.getSortInfo().getSortColumnSection(), FieldType.valueOf((String)titleFilter.getSortInfo().getSortFieldType().name()));
            PagingInfo pagingInfo = new PagingInfo(0, maxRecord);
            searchResults = this.searchService.getTitlesQuickSearch(searchText, partnerIds, pagingInfo, sortInfo, searchColumns, criteriaMode);
        } else {
            UiTitleFilterService utfs = new UiTitleFilterService();
            TitleFilter filter = new TitleFilter();
            utfs.convertTitleFilter(filter, titleFilter);
            filter.setPageInfo(new PagingInfo(0, maxRecord));
            searchResults = this.searchService.getSearchResults(filter, partnerIds, searchColumns);
        }
        if (searchResults != null) {
            for (TitleSearchResult.SearchRow row : searchResults.getRows()) {
                exportHelper.handleRecord(row);
            }
        }
    }
}

