/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.search.export;

import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.title.search.TitleSearchPropertiesProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.apache.log4j.Logger;

public class TitleSearchExportService {
    private static final Logger logger = Logger.getLogger(TitleSearchExportService.class);
    private static final TitleSearchExportService instance = new TitleSearchExportService();
    private Map<String, SearchCriteria> criterion = Collections.synchronizedMap(new HashMap());
    private Timer timer = new Timer(true);

    private TitleSearchExportService() {
    }

    public static TitleSearchExportService getInstance() {
        return instance;
    }

    public SearchCriteria getEntry(String key) {
        SearchCriteria result = this.criterion.remove(key);
        return result;
    }

    public String addEntry(UITitleFilter filter, List<UiColumn> uiColumns) {
        final String key = UUID.randomUUID().toString();
        long exportServiceTimeout = TitleSearchPropertiesProvider.getExportSearchServiceTimeout();
        SearchCriteria sc = new SearchCriteria(filter, uiColumns);
        this.criterion.put(key, sc);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                logger.debug((Object)("ExportSearchService removed:" + key));
                TitleSearchExportService.this.criterion.remove(key);
            }
        }, exportServiceTimeout);
        return key;
    }

    public static class SearchCriteria {
        private UITitleFilter filter;
        private List<UiColumn> uiColumns;

        public SearchCriteria(UITitleFilter filter, List<UiColumn> uiColumns) {
            this.setFilter(filter);
            this.setUiColumns(uiColumns);
        }

        public void setFilter(UITitleFilter filter) {
            this.filter = filter;
        }

        public UITitleFilter getFilter() {
            return this.filter;
        }

        public void setUiColumns(List<UiColumn> uiColumns) {
            this.uiColumns = uiColumns;
        }

        public List<UiColumn> getUiColumns() {
            return this.uiColumns;
        }
    }
}

