/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.ericsson.cms.categorymgmt.service.ICategoryManager;
import com.tandbergtv.cms.portal.content.client.title.service.ICategoryTitleService;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import org.apache.log4j.Logger;

public class CategoryTitleService
implements ICategoryTitleService,
NeptuneRemoteService {
    private static Logger logger = Logger.getLogger(CategoryTitleService.class);
    private final ICategoryManager categoryManager = ServiceLocator.getService("CategoryManager", ICategoryManager.class);

    public String getRelativePath() {
        return "service/content/title/ICategoryTitleService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public void associateTitleAndCategory(long titleId, String categoryPath) throws NeptuneException {
        try {
            this.categoryManager.disassociateCategoryPackage(titleId);
        }
        catch (Exception exception) {}
        try {
            this.categoryManager.associateCategoryPackage(titleId, categoryPath, true, true);
        }
        catch (Exception ex) {
            logger.error((Object)("Could not associate title " + titleId + " and category " + categoryPath), (Throwable)ex);
            throw new NeptuneException("Could not associate title " + titleId + " and category " + categoryPath + ": " + ex.getMessage());
        }
    }

    @Override
    public void disassociateTitle(long titleId) throws NeptuneException {
        try {
            this.categoryManager.disassociateCategoryPackage(titleId);
        }
        catch (Exception ex) {
            logger.error((Object)("Could not disassociate title " + titleId));
            throw new NeptuneException("Could not disassociate title " + titleId + ": " + ex.getMessage());
        }
    }

    @Override
    public boolean isTitleAssociated(long titleId) throws NeptuneException {
        try {
            return this.categoryManager.isCategoryAssociated(titleId);
        }
        catch (Exception exception) {
            logger.error((Object)("Could not determine if title " + titleId + " is associated with a category"));
            return false;
        }
    }
}

