/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.cms.portal.content.client.title.service.ImageEditorService;
import com.tandbergtv.cms.portal.content.client.title.service.SaveImageRequest;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.ITitleFileManager;
import com.tandbergtv.watchpoint.pmm.title.TitleFileRequest;
import com.tandbergtv.watchpoint.pmm.title.TitleServiceException;
import com.tandbergtv.watchpoint.pmm.util.PMMProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class ImageEditorServiceImpl
implements ImageEditorService,
NeptuneRemoteService {
    private Logger logger = Logger.getLogger(ImageEditorServiceImpl.class);
    private static final String MAPPED_FILES_DIR = "mappedAssets";
    private static final String DERIVED_FILES_DIR = "derivedAssets";
    private ITitleFileManager titleFileManager = (ITitleFileManager)InjectionUtil.injectInstance((String)"cms/TitleFileManagerProxy/local", ITitleFileManager.class);

    @Override
    public void saveImage(SaveImageRequest saveImageRequest) throws NeptuneException {
        this.logger.trace((Object)("In saveImage() : saveImageRequest : " + saveImageRequest));
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"});
        String imageFolderPath = saveImageRequest.getImageFolderPath();
        String imageFileName = saveImageRequest.getImageFileName();
        String imageDataBase64 = saveImageRequest.getImageDataBase64();
        try {
            PMMProperties properties = PMMProperties.getInstance();
            String mappedFilesDirPath = properties.getProperty(MAPPED_FILES_DIR);
            String derivedFilesDirPath = properties.getProperty(DERIVED_FILES_DIR);
            if (imageFolderPath != null && mappedFilesDirPath != null && derivedFilesDirPath != null && imageFolderPath.toLowerCase().contains(mappedFilesDirPath.toLowerCase())) {
                this.logger.debug((Object)("imageFolderPath : " + imageFolderPath + " contains mappedFilesDirPath : " + mappedFilesDirPath + ". Replacing with derivedFilesDirPath : " + derivedFilesDirPath));
                imageFolderPath = imageFolderPath.toLowerCase().replace(mappedFilesDirPath.toLowerCase(), derivedFilesDirPath);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception occurred : " + e));
        }
        File imagesRootFolder = new File(imageFolderPath);
        this.logger.debug((Object)("imagesRootFolder = " + imagesRootFolder));
        if (imagesRootFolder.exists() && imagesRootFolder.isDirectory()) {
            this.logger.debug((Object)("imagesRootFolder : " + imagesRootFolder + " exists and is a directory."));
            this.logger.debug((Object)("imageFileName = " + imageFileName));
            if (imageFileName != null) {
                try {
                    File file = new File(imagesRootFolder, imageFileName);
                    if (file.exists()) {
                        String msg = "File " + file.getPath() + " already exists. Cannot Save.";
                        throw new NeptuneException(msg);
                    }
                    file.setWritable(true);
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                    imageDataBase64 = imageDataBase64.split(",")[1];
                    bos.write(new Base64().decode(imageDataBase64.getBytes()));
                    bos.flush();
                    bos.close();
                    this.logger.info((Object)("Output File written : " + file));
                    this.registerFile(saveImageRequest);
                }
                catch (NeptuneException ne) {
                    this.logger.error((Object)("Exception occurred : " + (Object)((Object)ne)), (Throwable)ne);
                    throw ne;
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception occurred : " + e), (Throwable)e);
                    throw new NeptuneException("Failure saving file : " + imageFileName);
                }
            } else {
                this.logger.warn((Object)"fileName is null...");
            }
        } else {
            this.logger.warn((Object)("imagesRootFolder : " + imagesRootFolder + " either does not exist or is not a directory."));
        }
    }

    private void registerFile(SaveImageRequest imageRequest) throws NeptuneException {
        TitleFileRequest request = new TitleFileRequest().setAssetId(imageRequest.getAssetId().longValue()).setTitleId(imageRequest.getTitleId().longValue()).setFilePath(String.valueOf(imageRequest.getImageFolderPath()) + File.separator + imageRequest.getImageFileName()).setUsername(NeptuneAuthorizationManager.getAuthorizationService().getUserName()).setOriginalFilePath(imageRequest.getOriginalFilePath()).setLookupKey(imageRequest.getLookupKey());
        try {
            this.titleFileManager.registerFile(request);
        }
        catch (TitleServiceException e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    public String getRelativePath() {
        return "service/content/title/ImageEditorService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }
}

