/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.cms.portal.content.client.title.model.UIKeyFrames;
import com.tandbergtv.cms.portal.content.client.title.service.KeyframesService;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class KeyframesServiceImpl
implements KeyframesService,
NeptuneRemoteService {
    private Logger logger = Logger.getLogger(KeyframesServiceImpl.class);
    private static final String KEYFRAMES_PROPERTY_FILE = "keyframes.properties";
    private static final String KEYFRAMES_RATE_PROPERTY = "FRAMES_PER_SECONDS";
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    @Override
    @Transactional
    public Boolean hasKeyframesImageURIs(Long assetId, Long titleId) throws NeptuneException {
        Long l = assetId;
        Long l2 = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = KeyframesServiceImpl.class.getDeclaredMethod("hasKeyframesImageURIs", Long.class, Long.class).getAnnotation(Transactional.class);
        }
        return (Boolean)KeyframesServiceImpl.hasKeyframesImageURIs_aroundBody1$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UIKeyFrames getPagedKeyframesImageURIs(Long assetId, Long titleId, int numCols, int pageNum, int pageSize) throws NeptuneException {
        Long l = assetId;
        Long l2 = titleId;
        int n = numCols;
        int n2 = pageNum;
        int n3 = pageSize;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = KeyframesServiceImpl.class.getDeclaredMethod("getPagedKeyframesImageURIs", Long.class, Long.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).getAnnotation(Transactional.class);
        }
        return (UIKeyFrames)KeyframesServiceImpl.getPagedKeyframesImageURIs_aroundBody3$advice(this, l, l2, n, n2, n3, transactionEnforcer, (Transactional)annotation, null);
    }

    private int getFrameNumber(String s) {
        String strFrameNumber = s.substring(s.lastIndexOf("-") + 1, s.lastIndexOf("."));
        int frameNumber = -1;
        try {
            frameNumber = Integer.parseInt(strFrameNumber);
        }
        catch (NumberFormatException numberFormatException) {}
        return frameNumber;
    }

    private void sort(List<String> imageURIs) {
        Collections.sort(imageURIs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int compareResult = 0;
                int frameNumber1 = KeyframesServiceImpl.this.getFrameNumber(o1);
                int frameNumber2 = KeyframesServiceImpl.this.getFrameNumber(o2);
                compareResult = frameNumber1 - frameNumber2;
                return compareResult;
            }
        });
    }

    private ITitleAssetResourceManager getService() {
        return (ITitleAssetResourceManager)ServiceRegistry.getDefault().lookup(ITitleAssetResourceManager.class);
    }

    public String getRelativePath() {
        return "service/content/title/KeyframesService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private static final /* synthetic */ Boolean hasKeyframesImageURIs_aroundBody0(KeyframesServiceImpl ajc$this, Long assetId, Long titleId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        ITitleAssetResourceManager titleAssetResManager = ajc$this.getService();
        TitleAssetResource res = titleAssetResManager.getKeyFrames(titleId.longValue(), assetId.longValue());
        if (res == null) {
            return false;
        }
        return true;
    }

    private static final /* synthetic */ Object hasKeyframesImageURIs_aroundBody1$advice(KeyframesServiceImpl ajc$this, Long assetId, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return KeyframesServiceImpl.hasKeyframesImageURIs_aroundBody0(ajc$this, assetId, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Boolean object = KeyframesServiceImpl.hasKeyframesImageURIs_aroundBody0(ajc$this, assetId, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UIKeyFrames getPagedKeyframesImageURIs_aroundBody2(KeyframesServiceImpl ajc$this, Long assetId, Long titleId, int numCols, int pageNum, int pageSize) {
        UIKeyFrames keyFrames = new UIKeyFrames();
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        ITitleAssetResourceManager titleAssetResManager = ajc$this.getService();
        TitleAssetResource res = titleAssetResManager.getKeyFrames(titleId.longValue(), assetId.longValue());
        if (res == null) {
            ajc$this.logger.warn((Object)("No keyframe image URIs(TitleAssetResource) for titleId = " + titleId + " and assetId =" + assetId));
            return keyFrames;
        }
        ArrayList<String> allKeyframesImageURIs = new ArrayList<String>();
        ArrayList<String> keyframesImageURIs = new ArrayList<String>();
        String keyFramesFolder = res.getResourcePath();
        ajc$this.logger.debug((Object)("keyFramesFolder = " + keyFramesFolder + " for titleId = " + titleId + " and assetId = " + assetId));
        try {
            File imagesRootFolder = new File(keyFramesFolder);
            ajc$this.logger.debug((Object)("imagesRootFolder = " + imagesRootFolder));
            if (imagesRootFolder.exists() && imagesRootFolder.isDirectory()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(String.valueOf(keyFramesFolder) + KEYFRAMES_PROPERTY_FILE));
                String framesPerSecond = properties.getProperty(KEYFRAMES_RATE_PROPERTY);
                if (framesPerSecond == null) {
                    ajc$this.logger.warn((Object)"FRAMES_PER_SECONDS is null in property file");
                } else {
                    keyFrames.setFramesPerSecond(framesPerSecond);
                }
                File[] imageFilesArray = imagesRootFolder.listFiles();
                ajc$this.logger.debug((Object)("imageFiles = " + imageFilesArray));
                File[] fileArray = imageFilesArray;
                int n = imageFilesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File imageFile = fileArray[n2];
                    String imageFileURI = imageFile.getPath();
                    if (!imageFileURI.endsWith(KEYFRAMES_PROPERTY_FILE)) {
                        allKeyframesImageURIs.add(imageFileURI);
                        ajc$this.logger.debug((Object)("Adding imageFileURI = " + imageFileURI));
                    }
                    ++n2;
                }
                ajc$this.sort(allKeyframesImageURIs);
                int maxNumImagesPerPage = pageSize * numCols;
                int start = (pageNum - 1) * maxNumImagesPerPage;
                int max = allKeyframesImageURIs.size();
                if (start + maxNumImagesPerPage < max) {
                    max = start + maxNumImagesPerPage;
                }
                int i = start;
                while (i < max) {
                    keyframesImageURIs.add((String)allKeyframesImageURIs.get(i));
                    ++i;
                }
                keyFrames.setKeyframesImageURIs(keyframesImageURIs);
                keyFrames.setTotalNumberKeyFrames(allKeyframesImageURIs.size());
                if (keyframesImageURIs.size() < 1) {
                    ajc$this.logger.warn((Object)("No keyframes found in " + keyFramesFolder + " for page # " + pageNum));
                }
            } else {
                ajc$this.logger.warn((Object)("imagesRootFolder = " + imagesRootFolder + " does not exist or is not a directory."));
            }
        }
        catch (Exception e) {
            ajc$this.logger.error((Object)e);
            throw new NeptuneException("Exception getting keyframes image URIs : " + e);
        }
        return keyFrames;
    }

    private static final /* synthetic */ Object getPagedKeyframesImageURIs_aroundBody3$advice(KeyframesServiceImpl ajc$this, Long assetId, Long titleId, int numCols, int pageNum, int pageSize, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return KeyframesServiceImpl.getPagedKeyframesImageURIs_aroundBody2(ajc$this, assetId, titleId, numCols, pageNum, pageSize);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UIKeyFrames object = KeyframesServiceImpl.getPagedKeyframesImageURIs_aroundBody2(ajc$this, assetId, titleId, numCols, pageNum, pageSize);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

