/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetadataFieldsMapBuilder {
    public Map<String, String> buildMetadataFieldsMap(UISpecification uiSpecification) {
        HashMap<String, String> metadataFieldsMap = null;
        if (uiSpecification != null) {
            metadataFieldsMap = new HashMap<String, String>();
            this.processTitleConf(null, uiSpecification.getRootTitleConf(), metadataFieldsMap);
        }
        return metadataFieldsMap;
    }

    private MetadataFieldNode processTitleConf(MetadataFieldNode parentMetadataFieldNode, TitleConf titleConf, Map<String, String> metadataFieldsMap) {
        MetadataFieldNode metadataFieldNode = null;
        if (titleConf != null) {
            metadataFieldNode = new MetadataFieldNode();
            metadataFieldNode.setName(titleConf.getName());
            metadataFieldNode.setDisplayName(titleConf.getAlias());
            metadataFieldNode.setxPath(titleConf.getAlias());
            if (parentMetadataFieldNode != null) {
                metadataFieldNode.setFullName(String.valueOf(parentMetadataFieldNode.getFullName()) + "." + titleConf.getName());
                metadataFieldNode.setFullDisplayName(String.valueOf(parentMetadataFieldNode.getFullDisplayName()) + "." + titleConf.getAlias());
                metadataFieldNode.setFullXPath(String.valueOf(parentMetadataFieldNode.getFullXPath()) + "/" + titleConf.getAlias());
            } else {
                metadataFieldNode.setFullName(titleConf.getName());
                metadataFieldNode.setFullDisplayName(titleConf.getAlias());
                metadataFieldNode.setFullXPath("/ECMFSpec/" + titleConf.getAlias());
            }
            for (TitleConf childTitleConf : titleConf.getChildren()) {
                MetadataFieldNode childTitleConfMetadataFieldNode = this.processTitleConf(metadataFieldNode, childTitleConf, metadataFieldsMap);
                if (childTitleConfMetadataFieldNode == null) continue;
                metadataFieldNode.getChildren().add(childTitleConfMetadataFieldNode);
            }
            for (Variable variable : titleConf.getMetadata()) {
                MetadataFieldNode variableMetadataFieldNode = this.processVariable(metadataFieldNode, variable, metadataFieldsMap);
                if (variableMetadataFieldNode == null) continue;
                metadataFieldNode.getChildren().add(variableMetadataFieldNode);
            }
            if (parentMetadataFieldNode != null && metadataFieldNode.getChildren().size() < 1) {
                metadataFieldNode = null;
            }
        }
        return metadataFieldNode;
    }

    private MetadataFieldNode processVariable(MetadataFieldNode parentMetadataFieldNode, Variable variable, Map<String, String> metadataFieldsMap) {
        MetadataFieldNode metadataFieldNode = null;
        if (variable != null) {
            if (variable instanceof SimpleVariable) {
                metadataFieldNode = new MetadataFieldNode();
                metadataFieldNode.setName(variable.getName());
                metadataFieldNode.setDisplayName(variable.getDisplayName());
                metadataFieldNode.setxPath(variable.getXPath());
                if (parentMetadataFieldNode != null) {
                    metadataFieldNode.setFullName(String.valueOf(parentMetadataFieldNode.getFullName()) + "." + variable.getName());
                    metadataFieldNode.setFullDisplayName(String.valueOf(parentMetadataFieldNode.getFullDisplayName()) + "." + variable.getDisplayName());
                    metadataFieldNode.setFullXPath(String.valueOf(parentMetadataFieldNode.getFullXPath()) + variable.getXPath());
                    metadataFieldsMap.put(String.valueOf(parentMetadataFieldNode.getFullXPath()) + variable.getXPath(), String.valueOf(parentMetadataFieldNode.getFullDisplayName()) + "." + variable.getDisplayName());
                } else {
                    metadataFieldNode.setFullName(variable.getName());
                    metadataFieldNode.setFullDisplayName(variable.getDisplayName());
                    metadataFieldNode.setFullXPath(variable.getXPath());
                    metadataFieldsMap.put(variable.getXPath(), variable.getDisplayName());
                }
            } else if (variable instanceof ComplexVariable) {
                ComplexVariable complexVariable = (ComplexVariable)variable;
                metadataFieldNode = new MetadataFieldNode();
                metadataFieldNode.setName(variable.getName());
                metadataFieldNode.setDisplayName(variable.getDisplayName());
                metadataFieldNode.setxPath(variable.getXPath());
                if (parentMetadataFieldNode != null) {
                    metadataFieldNode.setFullName(String.valueOf(parentMetadataFieldNode.getFullName()) + "." + variable.getName());
                    metadataFieldNode.setFullDisplayName(String.valueOf(parentMetadataFieldNode.getFullDisplayName()) + "." + variable.getDisplayName());
                    metadataFieldNode.setFullXPath(parentMetadataFieldNode.getFullXPath());
                } else {
                    metadataFieldNode.setFullName(variable.getName());
                    metadataFieldNode.setFullDisplayName(variable.getDisplayName());
                    metadataFieldNode.setFullXPath(variable.getXPath());
                }
                for (Variable childVariable : complexVariable.getChildren()) {
                    MetadataFieldNode childVariableMetadataFieldNode = this.processVariable(metadataFieldNode, childVariable, metadataFieldsMap);
                    if (childVariableMetadataFieldNode == null) continue;
                    metadataFieldNode.getChildren().add(childVariableMetadataFieldNode);
                }
                if (metadataFieldNode.getChildren().size() < 1) {
                    metadataFieldNode = null;
                }
            }
        }
        return metadataFieldNode;
    }

    private static class MetadataFieldNode {
        private String name;
        private String displayName;
        private String xPath;
        private String fullName;
        private String fullDisplayName;
        private String fullXPath;
        private List<MetadataFieldNode> children = new ArrayList<MetadataFieldNode>();

        public MetadataFieldNode() {
            this("");
        }

        public MetadataFieldNode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public String getFullDisplayName() {
            return this.fullDisplayName;
        }

        public void setFullDisplayName(String fullDisplayName) {
            this.fullDisplayName = fullDisplayName;
        }

        public List<MetadataFieldNode> getChildren() {
            return this.children;
        }

        public String getxPath() {
            return this.xPath;
        }

        public void setxPath(String xPath) {
            this.xPath = xPath;
        }

        public String getFullXPath() {
            return this.fullXPath;
        }

        public void setFullXPath(String fullXPath) {
            this.fullXPath = fullXPath;
        }
    }
}

