/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.cms.portal.content.client.model.NoPartnersException;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleService;
import com.tandbergtv.cms.portal.content.server.title.offer.RefTitleSearchFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.title.basicsearch.BasicSearchFieldProvider;
import com.tandbergtv.cms.title.basicsearch.InvalidBasicSearchPathException;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.UnauthorizedUserException;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.search.SearchPartnerProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ejb.EJBException;

public class OffersTitleService
implements IOffersTitleService,
NeptuneRemoteService {
    private final ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
    private ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
    public static List<Long> titleIdList = new ArrayList<Long>();
    private final int MAX_PAGE_SIZE = 10000;

    public String getRelativePath() {
        return "service/content/title/IOffersTitleService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<UiColumn> getInPlaceSearchColumns() throws NeptuneException {
        List bsf;
        Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
        try {
            bsf = BasicSearchFieldProvider.getSearchFieldBase((Locale)locale, (CriteriaMode)CriteriaMode.MASTER, (Boolean)true);
        }
        catch (InvalidBasicSearchPathException e) {
            throw new NeptuneException(e.getMessage());
        }
        List<UiColumn> assetColumns = RefTitleSearchFieldProvider.getInstance().getColumnInfos(bsf);
        ArrayList<UiColumn> columns = new ArrayList<UiColumn>();
        columns.add(RefTitleSearchFieldProvider.getInstance().getTitleStatusColumn());
        columns.addAll(assetColumns);
        return columns;
    }

    @Override
    public List<UiColumn> getRefTitleSearchColumns() {
        List<UiColumn> assetColumns = RefTitleSearchFieldProvider.getInstance().getColumnInfos();
        ArrayList<UiColumn> columns = new ArrayList<UiColumn>();
        columns.add(RefTitleSearchFieldProvider.getInstance().getTitleStatusColumn());
        columns.addAll(assetColumns);
        columns.add(2, RefTitleSearchFieldProvider.getInstance().getDistributionStatusColumn());
        return columns;
    }

    @Override
    public UISearchResult getReferenceTitles(boolean isSiteTitle, List<Long> refTitleIds) throws NeptuneException {
        List partnerIds;
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        ArrayList<UISearchResultRec> uiTitles = new ArrayList<UISearchResultRec>();
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        try {
            partnerIds = SearchPartnerProvider.getParnterIds((String)userName);
        }
        catch (UnauthorizedUserException unauthorizedUserException) {
            throw new NoPartnersException();
        }
        if (refTitleIds == null || refTitleIds.isEmpty()) {
            return new UISearchResult(uiTitles.size(), uiTitles, false);
        }
        List<UiColumn> assetColumns = RefTitleSearchFieldProvider.getInstance().getColumnInfos();
        ArrayList<UiColumn> columns = new ArrayList<UiColumn>();
        columns.add(RefTitleSearchFieldProvider.getInstance().getTitleStatusColumn());
        columns.add(RefTitleSearchFieldProvider.getInstance().getDistributionStatusColumn());
        columns.addAll(assetColumns);
        List<SearchColumn> searchColumns = OffersTitleService.convertSeachColumns(columns);
        TitleSearchResult results = this.getTitleInfos(isSiteTitle, refTitleIds, partnerIds, searchColumns);
        List searchResults = results.getRows();
        HashMap<Long, UISearchResultRec> lu = new HashMap<Long, UISearchResultRec>();
        for (TitleSearchResult.SearchRow row : searchResults) {
            ArrayList<UiField> fields = new ArrayList<UiField>();
            int i = 0;
            while (i < columns.size()) {
                UiColumn uiCol = (UiColumn)columns.get(i);
                String value = row.getFirstValueAsString(i);
                if (uiCol.getFieldType().equals((Object)UIFieldType.ASSET)) {
                    fields.add(new UiField(uiCol.getName(), uiCol.getSectionName(), uiCol.getDisplayName(), value));
                } else {
                    fields.add(new UiField(uiCol.getName(), uiCol.getDisplayName(), value));
                }
                ++i;
            }
            UISearchResultRec uiObj = new UISearchResultRec(row.getId(), fields);
            lu.put(row.getId(), uiObj);
        }
        for (Long id : refTitleIds) {
            uiTitles.add((UISearchResultRec)lu.get((long)id));
        }
        UISearchResult srchRes = new UISearchResult(uiTitles.size(), uiTitles, false);
        return srchRes;
    }

    @Override
    public UISearchResult getOfferTitles(boolean isSiteTitle, Long referenceTitleId) throws NeptuneException {
        List partnerIds;
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        List<Long> offerTitleIds = new ArrayList();
        try {
            offerTitleIds = this.titleManager.getOfferIds(referenceTitleId);
        }
        catch (TitleValidationException e1) {
            e1.printStackTrace();
            throw new NeptuneException(e1.getCause().getMessage());
        }
        ArrayList<UISearchResultRec> uiTitles = new ArrayList<UISearchResultRec>();
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        try {
            partnerIds = SearchPartnerProvider.getParnterIds((String)userName);
        }
        catch (UnauthorizedUserException unauthorizedUserException) {
            throw new NoPartnersException();
        }
        if (offerTitleIds == null || offerTitleIds.isEmpty()) {
            return new UISearchResult(uiTitles.size(), uiTitles, false);
        }
        List<UiColumn> assetColumns = RefTitleSearchFieldProvider.getInstance().getColumnInfos();
        ArrayList<UiColumn> columns = new ArrayList<UiColumn>();
        columns.add(RefTitleSearchFieldProvider.getInstance().getTitleStatusColumn());
        columns.add(RefTitleSearchFieldProvider.getInstance().getDistributionStatusColumn());
        columns.addAll(assetColumns);
        List<SearchColumn> searchColumns = OffersTitleService.convertSeachColumns(columns);
        TitleSearchResult results = this.getTitleInfos(isSiteTitle, offerTitleIds, partnerIds, searchColumns);
        List searchResults = results.getRows();
        HashMap<Long, UISearchResultRec> lu = new HashMap<Long, UISearchResultRec>();
        for (TitleSearchResult.SearchRow row : searchResults) {
            ArrayList<UiField> fields = new ArrayList<UiField>();
            int i = 0;
            while (i < columns.size()) {
                UiColumn uiCol = (UiColumn)columns.get(i);
                String value = row.getFirstValueAsString(i);
                if (uiCol.getFieldType().equals((Object)UIFieldType.ASSET)) {
                    fields.add(new UiField(uiCol.getName(), uiCol.getSectionName(), uiCol.getDisplayName(), value));
                } else {
                    fields.add(new UiField(uiCol.getName(), uiCol.getDisplayName(), value));
                }
                ++i;
            }
            UISearchResultRec uiObj = new UISearchResultRec(row.getId(), fields, true);
            lu.put(row.getId(), uiObj);
        }
        for (Long id : offerTitleIds) {
            uiTitles.add((UISearchResultRec)lu.get((long)id));
        }
        UISearchResult srchRes = new UISearchResult(uiTitles.size(), uiTitles, false);
        return srchRes;
    }

    private TitleSearchResult getTitleInfos(boolean isSiteTitle, List<Long> titleIds, List<Long> partnerIds, List<SearchColumn> searchColumns) {
        TitleFilter filter = new TitleFilter();
        if (isSiteTitle) {
            filter.setCriteriaMode(CriteriaMode.SITE);
        } else {
            filter.setCriteriaMode(CriteriaMode.MASTER);
        }
        filter.setRootNode((ExpNode)this.getTitleIdsCriteria(titleIds));
        filter.setPageInfo(new PagingInfo(0, 10000));
        filter.setSortInfo(new SortingInfo("id", SortOrder.ASCENDING, null, FieldType.PMM_TITLE));
        TitleSearchResult results = this.searchService.getSearchResults(filter, partnerIds, searchColumns);
        return results;
    }

    private ExpValue getTitleIdsCriteria(List<Long> titleIds) {
        ArrayList<String> titleIdsStr = new ArrayList<String>();
        for (Long id : titleIds) {
            titleIdsStr.add(String.valueOf(id));
        }
        PredicateRightValue condition = new PredicateRightValue("id", "", FieldType.PMM_TITLE, titleIdsStr, LogicalOperator.IN, "integer", Boolean.valueOf(false));
        return new ExpValue((Predicate)condition);
    }

    public static List<SearchColumn> convertSeachColumns(List<UiColumn> uiColumns) {
        ArrayList<SearchColumn> result = new ArrayList<SearchColumn>();
        for (UiColumn uiCol : uiColumns) {
            SearchColumn sc = new SearchColumn(uiCol.getSectionName(), uiCol.getName(), FieldType.valueOf((String)uiCol.getFieldType().name()), uiCol.getDataType().name(), uiCol.isMultiValued());
            if (uiCol.isQuickInfoField()) {
                sc.setQuickInfoField(true);
            }
            result.add(sc);
        }
        return result;
    }

    private void addTitleToOffer(Long titleId, Long offerTitleId) throws NeptuneException {
        try {
            this.titleManager.addTitleToOffer(titleId, offerTitleId, (ITitleActionSource)new TitleActionSource("Content Management", "Offer Title Service", this.getCurrentUser()));
        }
        catch (TitlePersistenceException titlePersistenceException) {
            throw new NeptuneException();
        }
        catch (TitleValidationException titleValidationException) {
            throw new NeptuneException();
        }
        catch (EJBException ejbE) {
            throw new NeptuneException(ejbE.getCause().getMessage());
        }
    }

    @Override
    public void removeTitleFromOffer(Long titleId, Long offerTitleId) throws NeptuneException {
        try {
            List refTitlesList = this.titleManager.getReferencedTitleIdsFromOffer(offerTitleId);
            int occurrences = Collections.frequency(refTitlesList, titleId);
            int i = 0;
            while (i < occurrences) {
                this.titleManager.removeTitleFromOffer(titleId, offerTitleId, (ITitleActionSource)new TitleActionSource("Content Management", "Offer Title Service", this.getCurrentUser()));
                ++i;
            }
        }
        catch (TitlePersistenceException titlePersistenceException) {
            throw new NeptuneException();
        }
        catch (TitleValidationException titleValidationException) {
            throw new NeptuneException();
        }
        catch (EJBException ejbE) {
            throw new NeptuneException(ejbE.getCause().getMessage());
        }
    }

    private String getCurrentUser() {
        IAuthorizationService service = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);
        return service.getUserName();
    }

    @Override
    public void addTitlesToOffer(List<Long> titleIds, Long offerTitleId) throws NeptuneException {
        for (Long titleId : titleIds) {
            this.addTitleToOffer(titleId, offerTitleId);
        }
    }

    @Override
    public void parseSelectedTitlesToOfferMetadata(List<Long> titleIds) throws NeptuneException {
        try {
            for (Long titleId : titleIds) {
                this.titleManager.addTitleToOfferValidation(titleId);
            }
        }
        catch (EJBException ejbE) {
            throw new NeptuneException(ejbE.getCause().getMessage());
        }
        titleIdList = titleIds;
    }

    @Override
    public List<Long> getSelectedAddingTitles() {
        return titleIdList;
    }

    @Override
    public void clearSelectedAddingTitles() {
        if (!titleIdList.isEmpty()) {
            titleIdList.clear();
        }
    }
}

