/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.tandbergtv.cms.contentmgmt.service.pitch.IPitchScheduleRequestSender;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.client.rpc.title.IPitchScheduleService;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PitchScheduleServiceImpl
implements IPitchScheduleService,
NeptuneRemoteService {
    private final ISiteManager siteManager;
    private Logger logger = Logger.getLogger(PitchScheduleServiceImpl.class);
    private IPitchScheduleRequestSender requestSender = (IPitchScheduleRequestSender)InjectionUtil.injectInstance((String)"cms/PitchScheduleRequestSender/local", IPitchScheduleRequestSender.class);

    public PitchScheduleServiceImpl() {
        this.siteManager = this.getSiteManager();
    }

    public String getRelativePath() {
        return "service/content/pitchScheduleProvider";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<String> getTrackingSites() throws NeptuneException {
        List trackList = this.siteManager.getAllTrackingSites();
        List<String> sites = this.getSites(trackList);
        return sites;
    }

    private List<String> getSites(List<TrackingSite> trackList) {
        ArrayList<String> sites = new ArrayList<String>();
        if (trackList != null) {
            for (TrackingSite track : trackList) {
                sites.add(new String(track.getName()));
            }
        }
        return sites;
    }

    private ISiteManager getSiteManager() {
        ISiteManager siteManager = ServiceLocator.getService("SiteManager", ISiteManager.class);
        return siteManager;
    }

    @Override
    public WorkOrderCreateResponse sendWorkOrderCreateMessage(List<Long> titleIds, String trackingSiteName, String queueName, String queuePos, String templateName) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"WorkOrderManagement_Create"});
        TrackingSite site = (TrackingSite)this.siteManager.getSiteByName(trackingSiteName);
        String trackingSiteExternalId = site.getExternalId();
        WorkOrderCreateResponse response = new WorkOrderCreateResponse();
        for (long id : titleIds) {
            try {
                this.requestSender.sendPitchWorkOrderCreateMessage(id, trackingSiteExternalId, queueName, queuePos, templateName);
                response.getQueuedWorkOrders().add(id);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to queue work order for title: " + id), (Throwable)e);
                response.getFailedIds().put(id, e.getLocalizedMessage());
            }
        }
        return response;
    }

    @Override
    public Boolean hasMPWithTrackingSites() throws NeptuneException {
        return this.siteManager.hasMPWithTrackingSites();
    }
}

