/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.me.service.IMEManagerLocal;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.rules.fieldprovider.metadataenhancement.ISubscriptionProfileProvider;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.title.model.NameValuePair;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewInitData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewResponse;
import com.tandbergtv.cms.portal.content.client.title.model.rules.TitleSavePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIMsoRuleSet;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIRuleActionChange;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UiMso;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewService;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.cms.portal.content.server.title.metadata.AssetModelConverter;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitleCompareDataBuilder;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitlePreviewBuilder;
import com.tandbergtv.cms.portal.ui.title.server.specification.FieldLookupService;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.msopreview.IMsoOverridePreviewFacade;
import com.tandbergtv.marvin.udt.NormalizationActionChange;
import com.tandbergtv.marvin.udt.ShallowRuleSet;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.compare.ITitleCompareReport;
import com.tandbergtv.watchpoint.pmm.title.ITitleCompareService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class RulesPreviewService
implements IRulesPreviewService,
NeptuneRemoteService {
    private static final Logger logger = Logger.getLogger(RulesPreviewService.class);
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private IRuleManager ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
    private IRuleExecutionHandler ruleRunner = (IRuleExecutionHandler)InjectionUtil.injectInstance((String)"cms/EventHandler/local", IRuleExecutionHandler.class);
    private IMsoOverridePreviewFacade msoRuleManager = (IMsoOverridePreviewFacade)InjectionUtil.injectInstance((String)"cms/MsoOverridePreviewFacade/local", IMsoOverridePreviewFacade.class);
    private ITitleCompareService titleCompareService = ServiceLocator.getService("TitleCompareServiceProxy", ITitleCompareService.class);
    private ITitleManager titleManagerService = ServiceLocator.getService("TitleManagerProxy", ITitleManager.class);
    private IAssetSpecificationManager specificationManager = ServiceLocator.getService("AssetSpecificationManager", IAssetSpecificationManager.class);
    private IMEManagerLocal meManager = (IMEManagerLocal)InjectionUtil.injectInstance((String)"cms/MEManager/local", IMEManagerLocal.class);
    private ISubscriptionProfileProvider subProfileProvider = (ISubscriptionProfileProvider)InjectionUtil.injectInstance((String)"cms/SubscriptionProfileProvider/local", ISubscriptionProfileProvider.class);
    private HttpSession httpSession;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public String getRelativePath() {
        return "service/content/title/IRulesPreviewService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    @Transactional
    public List<NameValuePair> getSites() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = RulesPreviewService.class.getDeclaredMethod("getSites", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)RulesPreviewService.getSites_aroundBody1$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<NameValuePair> getRulesBySiteId(Integer siteId) throws NeptuneException {
        Integer n = siteId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = RulesPreviewService.class.getDeclaredMethod("getRulesBySiteId", Integer.class).getAnnotation(Transactional.class);
        }
        return (List)RulesPreviewService.getRulesBySiteId_aroundBody3$advice(this, n, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<NameValuePair> getGlobalRules() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = RulesPreviewService.class.getDeclaredMethod("getGlobalRules", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)RulesPreviewService.getGlobalRules_aroundBody5$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public RulePreviewInitData getInitData(long titleId) throws NeptuneException {
        long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = RulesPreviewService.class.getDeclaredMethod("getInitData", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (RulePreviewInitData)RulesPreviewService.getInitData_aroundBody7$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public RulePreviewResponse previewRule(RulePreviewRequest request) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        RulePreviewResponse resp = new RulePreviewResponse();
        Title title1 = this.getTitle(request);
        Title title2 = null;
        if (request.enhance) {
            if (request.meRequestKey == null) {
                resp.meRequestKey = UUID.randomUUID().toString();
                if (this.hasMultipleMeMatches(title1, request.ruleSetId, request.siteId, resp.meRequestKey)) {
                    resp.meMultipleMatches = true;
                    return resp;
                }
            } else {
                resp.meRequestKey = request.meRequestKey;
            }
            title2 = this.getTitle(request);
            this.runRuleWithEnhancement(title2, request, resp.meRequestKey);
        } else {
            title2 = this.getTitle(request);
            this.runRule(title2, request);
        }
        ITitleCompareReport report = this.titleCompareService.compareTitles(title1, title2);
        UITitleCompareDataBuilder builder = new UITitleCompareDataBuilder(request.specName);
        resp.diffData = builder.build(report);
        return resp;
    }

    private void runRule(Title title, RulePreviewRequest request) {
        if (request.siteId == null) {
            if (request.ruleSetId == -1) {
                this.ruleRunner.testNormalization(title);
            } else {
                this.ruleRunner.testNormalization(title, request.ruleSetId);
            }
        } else if (request.ruleSetId == null) {
            this.ruleRunner.testNormalizationTargeting(title, request.siteId);
        } else if (request.ruleSetId == -1) {
            this.ruleRunner.testNormalization(title);
        } else {
            this.ruleRunner.testNormalization(title, request.ruleSetId, request.siteId);
        }
    }

    private void runRuleWithEnhancement(Title title, RulePreviewRequest request, String requestKey) {
        if (request.siteId == null) {
            if (request.ruleSetId == -1) {
                this.ruleRunner.testNormalization(title, requestKey);
            } else {
                this.ruleRunner.testNormalization(title, request.ruleSetId, requestKey);
            }
        } else if (request.ruleSetId == null) {
            this.ruleRunner.testNormalizationTargeting(title, request.siteId, requestKey);
        } else if (request.ruleSetId == -1) {
            this.ruleRunner.testNormalization(title, requestKey);
        } else {
            this.ruleRunner.testNormalization(title, request.ruleSetId, request.siteId, requestKey);
        }
    }

    @Override
    public RulePreviewResponse previewRuleSpec(RulePreviewRequest request, boolean useHtml) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        Title title1 = this.getTitle(request);
        Title title2 = this.getTitle(request);
        RulePreviewResponse resp = new RulePreviewResponse();
        if (request.enhance) {
            resp.meRequestKey = request.meRequestKey;
            this.runRuleWithEnhancement(title2, request, resp.meRequestKey);
        } else {
            this.runRule(title2, request);
        }
        UITitleCompareXmlData data = new UITitleCompareXmlData();
        data.preview1URL = this.previewTitle(title1, request.specName, useHtml);
        data.preview2URL = this.previewTitle(title2, request.specName, useHtml);
        resp.xmlData = data;
        return resp;
    }

    private Title getTitle(RulePreviewRequest request) {
        Title title = this.titleManagerService.get(request.titleId);
        return title;
    }

    private String previewTitle(Title title, String specificationName, boolean useHtml) throws NeptuneException {
        UITitlePreviewBuilder generator = new UITitlePreviewBuilder(this.httpSession, this.titleManagerService, useHtml);
        Specification spec = this.specificationManager.getSpecification(specificationName);
        return generator.generatePreview(title, spec);
    }

    private boolean hasMultipleMeMatches(Title title, Integer rulesetId, Integer siteId, String requestKey) throws NeptuneException {
        Collection profiles = null;
        profiles = siteId != null && rulesetId == null ? this.subProfileProvider.getSubscriptionProfilesBySite(title, siteId) : (rulesetId != null && rulesetId > 0 ? this.subProfileProvider.getSubscriptionProfilesByRuleSet(title, rulesetId) : this.subProfileProvider.getSubscriptionProfiles(title));
        if (profiles == null || profiles.isEmpty()) {
            return false;
        }
        try {
            return this.meManager.searchEnhancement(profiles, title, requestKey);
        }
        catch (Exception ex) {
            logger.error((Object)"Metadata enhancement search failed.", (Throwable)ex);
            this.meManager.deleteRequest(requestKey);
            String msg = ex.getLocalizedMessage();
            if (ex.getCause() != null) {
                msg = ex.getCause().getLocalizedMessage();
            }
            throw new NeptuneException(msg == null ? "Metadata enhancement search failed." : msg);
        }
    }

    @Override
    public RulePreviewResponse previewRule(TitleSavePreviewRequest request) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        RulePreviewResponse resp = new RulePreviewResponse();
        resp.meRequestKey = request.meRequestKey;
        Title title1 = this.buildTitle(request.title);
        Title title2 = this.buildTitle(request.title);
        this.ruleRunner.testNormalization(title2, resp.meRequestKey);
        ITitleCompareReport report = this.titleCompareService.compareTitles(title1, title2);
        UITitleCompareDataBuilder builder = new UITitleCompareDataBuilder(request.specName);
        resp.diffData = builder.build(report);
        return resp;
    }

    @Override
    public RulePreviewResponse previewRuleSpec(TitleSavePreviewRequest request, boolean useHtml) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        RulePreviewResponse resp = new RulePreviewResponse();
        resp.meRequestKey = request.meRequestKey;
        Title title1 = this.buildTitle(request.title);
        Title title2 = this.buildTitle(request.title);
        this.ruleRunner.testNormalization(title2, resp.meRequestKey);
        UITitleCompareXmlData data = new UITitleCompareXmlData();
        data.preview1URL = this.previewTitle(title1, request.specName, useHtml);
        data.preview2URL = this.previewTitle(title2, request.specName, useHtml);
        resp.xmlData = data;
        return resp;
    }

    private Title buildTitle(UITitle uiTitle) {
        Title title = new Title();
        title.setId(uiTitle.getId());
        title.setContentClassId(uiTitle.getContentClassId());
        title.setPartnerId(uiTitle.getPartnerId());
        if (uiTitle.getOverview() != null) {
            title.setOriginalId(uiTitle.getOverview().getOriginalId());
        }
        AssetModelConverter converter = new AssetModelConverter();
        title.setAsset(converter.convert(uiTitle.getMetadata().getRootAsset()));
        return title;
    }

    @Override
    public List<UIMsoRuleSet> getAllShallowMsoRuleSets() throws NeptuneException {
        ArrayList<UIMsoRuleSet> uiRuleSetList = new ArrayList();
        List ruleSet = this.msoRuleManager.getMsoOverrideRuleSets();
        uiRuleSetList = this.convertToUIShallowRuleSet(ruleSet);
        return uiRuleSetList;
    }

    private List<UIMsoRuleSet> convertToUIShallowRuleSet(List<ShallowRuleSet> ruleSetList) {
        ArrayList<UIMsoRuleSet> uiList = new ArrayList<UIMsoRuleSet>();
        if (ruleSetList != null) {
            for (ShallowRuleSet ruleSet : ruleSetList) {
                UIMsoRuleSet uiSet = new UIMsoRuleSet();
                uiSet.setRuleSetDisplayName(ruleSet.getRuleName());
                uiSet.setRuleSetId(ruleSet.getRuleSetId());
                uiList.add(uiSet);
            }
        }
        return uiList;
    }

    @Override
    public List<UiMso> getMsos(Long siteTitleId, Integer ruleSetId) throws NeptuneException {
        ArrayList<UiMso> uiList = new ArrayList();
        List msoList = this.msoRuleManager.getMsos(siteTitleId, ruleSetId);
        uiList = this.getUiMsoList(msoList);
        return uiList;
    }

    private List<UiMso> getUiMsoList(List<MSO> msoList) {
        ArrayList<UiMso> uiList = new ArrayList<UiMso>();
        if (msoList != null) {
            for (MSO mso : msoList) {
                UiMso uiMso = new UiMso();
                uiMso.setMsoId(mso.getId());
                uiMso.setMsoName(mso.getMsoName());
                uiList.add(uiMso);
            }
        }
        return uiList;
    }

    @Override
    public List<UIRuleActionChange> getMsoRuleSet(Long siteTitleId, Integer ruleSetId, Integer msoId) throws NeptuneException {
        ArrayList<UIRuleActionChange> uiList = new ArrayList();
        List changeList = this.msoRuleManager.runSingleMsoRuleSet(siteTitleId.longValue(), ruleSetId.intValue(), msoId.intValue());
        uiList = this.getUiRuleChangeList(changeList);
        return uiList;
    }

    private List<UIRuleActionChange> getUiRuleChangeList(List<NormalizationActionChange> changeList) {
        ArrayList<UIRuleActionChange> uiList = new ArrayList<UIRuleActionChange>();
        if (changeList != null) {
            for (NormalizationActionChange change : changeList) {
                UIRuleActionChange uiChange = new UIRuleActionChange();
                uiChange.setRuleSetId(change.getRuleSetId());
                uiChange.setRuleSetName(change.getRuleSetName());
                uiChange.setRuleSetId(change.getRuleSetId());
                uiChange.setAction(change.getAction());
                uiChange.setActionDisplayNameKey(change.getActionDisplayNameKey());
                uiChange.setSectionType(change.getSectionType());
                uiChange.setXpath(change.getXpath());
                uiChange.setFrom(change.getFrom());
                uiChange.setTo(change.getTo());
                uiChange.setFieldName(FieldLookupService.getInstance().getDisplayName(FieldType.ASSET, change.getSectionType(), change.getXpath()).getFullDisplayName());
                uiList.add(uiChange);
            }
        }
        return uiList;
    }

    @Override
    public List<UIRuleActionChange> getAllMSORuleSets(Long siteTitleId, Integer msoId) throws NeptuneException {
        ArrayList<UIRuleActionChange> uiList = new ArrayList();
        List changeList = this.msoRuleManager.runAllMsoRuleSets(siteTitleId.longValue(), msoId.intValue());
        uiList = this.getUiRuleChangeList(changeList);
        return uiList;
    }

    @Override
    public Boolean isMediaPathSiteTitle(Integer siteId) throws NeptuneException {
        return this.siteManager.isMediaPathSiteTitle(siteId);
    }

    private static final /* synthetic */ List getSites_aroundBody0(RulesPreviewService ajc$this) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        ArrayList<NameValuePair> results = new ArrayList<NameValuePair>();
        try {
            List sites = ajc$this.siteManager.getAllDistributionSites();
            for (DistributionSite site : sites) {
                results.add(new NameValuePair(site.getName(), site.getId().toString()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Could not get active distribution sites from the server.", (Throwable)ex);
            throw new NeptuneException("Could not get active distribution sites from the server. " + ex);
        }
        return results;
    }

    private static final /* synthetic */ Object getSites_aroundBody1$advice(RulesPreviewService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RulesPreviewService.getSites_aroundBody0(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = RulesPreviewService.getSites_aroundBody0(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getRulesBySiteId_aroundBody2(RulesPreviewService ajc$this, Integer siteId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        ArrayList<NameValuePair> results = new ArrayList<NameValuePair>();
        try {
            List rules = ajc$this.ruleManager.getRuleSetBySitePackage(siteId, "NORMALIZATION");
            for (TreRuleSet rule : rules) {
                results.add(new NameValuePair(rule.getRuleName(), rule.getRuleSetId().toString()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Could not get global rules from the server.", (Throwable)ex);
            throw new NeptuneException("Could not get global rules from the server. " + ex);
        }
        return results;
    }

    private static final /* synthetic */ Object getRulesBySiteId_aroundBody3$advice(RulesPreviewService ajc$this, Integer siteId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RulesPreviewService.getRulesBySiteId_aroundBody2(ajc$this, siteId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = RulesPreviewService.getRulesBySiteId_aroundBody2(ajc$this, siteId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getGlobalRules_aroundBody4(RulesPreviewService ajc$this) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        ArrayList<NameValuePair> results = new ArrayList<NameValuePair>();
        try {
            List rules = ajc$this.ruleManager.getGlobalRuleSetsByPackage("NORMALIZATION");
            for (TreRuleSet rule : rules) {
                results.add(new NameValuePair(rule.getRuleName(), rule.getRuleSetId().toString()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Could not get global rules from the server.", (Throwable)ex);
            throw new NeptuneException("Could not get global rules from the server. " + ex);
        }
        return results;
    }

    private static final /* synthetic */ Object getGlobalRules_aroundBody5$advice(RulesPreviewService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RulesPreviewService.getGlobalRules_aroundBody4(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = RulesPreviewService.getGlobalRules_aroundBody4(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ RulePreviewInitData getInitData_aroundBody6(RulesPreviewService ajc$this, long titleId) {
        Title title = ajc$this.titleManagerService.get(Long.valueOf(titleId));
        RulePreviewInitData data = new RulePreviewInitData();
        if (title.getOriginalId() == null) {
            data.isSiteTitle = false;
            data.sites = ajc$this.getSites();
            data.rules = ajc$this.getGlobalRules();
        } else {
            data.isSiteTitle = true;
            data.siteId = ajc$this.siteManager.getDistributionSiteId(Long.valueOf(titleId));
            data.rules = ajc$this.getRulesBySiteId(data.siteId);
        }
        return data;
    }

    private static final /* synthetic */ Object getInitData_aroundBody7$advice(RulesPreviewService ajc$this, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RulesPreviewService.getInitData_aroundBody6(ajc$this, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            RulePreviewInitData object = RulesPreviewService.getInitData_aroundBody6(ajc$this, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

