/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.sites.core.ISiteManager;
import com.tandbergtv.cms.portal.content.client.model.NoPartnersException;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleOverview;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeasonListItem;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeriesInfo;
import com.tandbergtv.cms.portal.content.client.title.service.ISeriesTitleService;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitleBuilder;
import com.tandbergtv.cms.portal.content.server.title.series.EpisodeSearchFieldProvider;
import com.tandbergtv.cms.portal.content.server.title.series.SeriesFieldsBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.TitleSearchPropertiesProvider;
import com.tandbergtv.cms.title.search.entities.UnauthorizedUserException;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.search.SearchPartnerProvider;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class SeriesTitleService
implements ISeriesTitleService,
NeptuneRemoteService {
    private final ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
    private final ITitleManager titleManagerService = ServiceLocator.getService("TitleManagerProxy", ITitleManager.class);
    private final ISiteManager siteManager = ServiceLocator.getService("SiteManager", ISiteManager.class);
    private final ITitleCopyService titleCopyService = ServiceLocator.getService("TitleCopyServiceProxy", ITitleCopyService.class);
    private final IContentClassService ccService = ServiceLocator.getService("ContentClassService", IContentClassService.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;

    public String getRelativePath() {
        return "service/content/title/ISeriesTitleService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<UiColumn> getEpisodeSearchColumns() throws NeptuneException {
        List<UiColumn> assetColumns = EpisodeSearchFieldProvider.getInstance().getColumnInfos();
        ArrayList<UiColumn> columns = new ArrayList<UiColumn>();
        columns.add(EpisodeSearchFieldProvider.getInstance().getTitleStatusColumn());
        columns.addAll(assetColumns);
        return columns;
    }

    @Override
    @Transactional
    public UISearchResult getEpisodeTitles(Long seriesDocumentId, Long seasonAssetId) throws NeptuneException {
        Long l = seriesDocumentId;
        Long l2 = seasonAssetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = SeriesTitleService.class.getDeclaredMethod("getEpisodeTitles", Long.class, Long.class).getAnnotation(Transactional.class);
        }
        return (UISearchResult)SeriesTitleService.getEpisodeTitles_aroundBody1$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UISeriesInfo getSeriesTitleInfos(Long episodeTitleId) throws NeptuneException {
        Long l = episodeTitleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = SeriesTitleService.class.getDeclaredMethod("getSeriesTitleInfos", Long.class).getAnnotation(Transactional.class);
        }
        return (UISeriesInfo)SeriesTitleService.getSeriesTitleInfos_aroundBody3$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public void associateTitleToSeries(Long episodeTitleID, Long seriesDocumentId, Long seasonAssetId) throws NeptuneException {
        Long l = episodeTitleID;
        Long l2 = seriesDocumentId;
        Long l3 = seasonAssetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = SeriesTitleService.class.getDeclaredMethod("associateTitleToSeries", Long.class, Long.class, Long.class).getAnnotation(Transactional.class);
        }
        SeriesTitleService.associateTitleToSeries_aroundBody5$advice(this, l, l2, l3, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public void disassociateTitleFromSeries(Long episodeTitleID) throws NeptuneException {
        Long l = episodeTitleID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = SeriesTitleService.class.getDeclaredMethod("disassociateTitleFromSeries", Long.class).getAnnotation(Transactional.class);
        }
        SeriesTitleService.disassociateTitleFromSeries_aroundBody7$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    private ExpNode buildConditions(Long seriesDocumentId, Long seasonAssetId) {
        ExpList root = new ExpList();
        PredicateRightValue pred = new PredicateRightValue();
        pred.setFieldLeft("seriesDocumentId");
        pred.setFieldTypeLhs(FieldType.PMM_TITLE);
        pred.setOperator(LogicalOperator.EQUAL);
        pred.setDataType("integer");
        pred.setValue(seriesDocumentId.toString());
        root.addItem((ExpNode)new ExpValue((Predicate)pred));
        if (seasonAssetId != null) {
            pred = new PredicateRightValue();
            pred.setFieldLeft("seasonAssetId");
            pred.setFieldTypeLhs(FieldType.PMM_TITLE);
            pred.setOperator(LogicalOperator.EQUAL);
            pred.setDataType("integer");
            pred.setValue(seasonAssetId.toString());
            root.addItem((ExpNode)new ExpValue((Predicate)pred));
        } else {
            pred = new PredicateRightValue();
            pred.setFieldLeft("seasonAssetId");
            pred.setFieldTypeLhs(FieldType.PMM_TITLE);
            pred.setOperator(LogicalOperator.ISEMPTY);
            pred.setDataType("integer");
            root.addItem((ExpNode)new ExpValue((Predicate)pred));
        }
        return root;
    }

    public static List<SearchColumn> convertSeachColumns(List<UiColumn> uiColumns) {
        ArrayList<SearchColumn> result = new ArrayList<SearchColumn>();
        for (UiColumn uiCol : uiColumns) {
            SearchColumn sc = new SearchColumn(uiCol.getSectionName(), uiCol.getName(), FieldType.valueOf((String)uiCol.getFieldType().name()), uiCol.getDataType().name(), uiCol.isMultiValued());
            if (uiCol.isQuickInfoField()) {
                sc.setQuickInfoField(true);
            }
            result.add(sc);
        }
        return result;
    }

    @Override
    public List<UISeasonListItem> getSeasonList(String seriesDocId) throws NeptuneException {
        try {
            SeriesFieldsBuilder builder = SeriesFieldsBuilder.getInstance();
            List<UISeasonListItem> list = builder.getSeasonList(seriesDocId);
            return list;
        }
        catch (Exception ex) {
            throw new NeptuneException(ex.getMessage());
        }
    }

    private static final /* synthetic */ UISearchResult getEpisodeTitles_aroundBody0(SeriesTitleService ajc$this, Long seriesDocumentId, Long seasonAssetId) {
        List partnerIds;
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        ArrayList<UISearchResultRec> uiTitles = new ArrayList<UISearchResultRec>();
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        try {
            partnerIds = SearchPartnerProvider.getParnterIds((String)userName);
        }
        catch (UnauthorizedUserException unauthorizedUserException) {
            throw new NoPartnersException();
        }
        if (seriesDocumentId == null) {
            return new UISearchResult(uiTitles.size(), uiTitles, false);
        }
        List<UiColumn> assetColumns = EpisodeSearchFieldProvider.getInstance().getColumnInfos();
        ArrayList<UiColumn> columns = new ArrayList<UiColumn>();
        columns.add(EpisodeSearchFieldProvider.getInstance().getTitleStatusColumn());
        columns.addAll(assetColumns);
        List<SearchColumn> searchColumns = SeriesTitleService.convertSeachColumns(columns);
        TitleFilter filter = new TitleFilter();
        int maxRecord = TitleSearchPropertiesProvider.getMaxTitlesFetchSize();
        PagingInfo pagingInfo = new PagingInfo(0, maxRecord);
        filter.setPageInfo(pagingInfo);
        filter.setRootNode(ajc$this.buildConditions(seriesDocumentId, seasonAssetId));
        TitleSearchResult results = ajc$this.searchService.getSearchResults(filter, partnerIds, searchColumns);
        List searchResults = results.getRows();
        for (TitleSearchResult.SearchRow row : searchResults) {
            ArrayList<UiField> fields = new ArrayList<UiField>();
            int i = 0;
            while (i < columns.size()) {
                UiColumn uiCol = (UiColumn)columns.get(i);
                String value = row.getFirstValueAsString(i);
                if (uiCol.getFieldType().equals((Object)UIFieldType.ASSET)) {
                    fields.add(new UiField(uiCol.getName(), uiCol.getSectionName(), uiCol.getDisplayName(), value));
                } else {
                    fields.add(new UiField(uiCol.getName(), uiCol.getDisplayName(), value));
                }
                ++i;
            }
            UISearchResultRec uiObj = new UISearchResultRec(row.getId(), fields);
            uiTitles.add(uiObj);
        }
        UISearchResult srchRes = new UISearchResult(uiTitles.size(), uiTitles, false);
        return srchRes;
    }

    private static final /* synthetic */ Object getEpisodeTitles_aroundBody1$advice(SeriesTitleService ajc$this, Long seriesDocumentId, Long seasonAssetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SeriesTitleService.getEpisodeTitles_aroundBody0(ajc$this, seriesDocumentId, seasonAssetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UISearchResult object = SeriesTitleService.getEpisodeTitles_aroundBody0(ajc$this, seriesDocumentId, seasonAssetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UISeriesInfo getSeriesTitleInfos_aroundBody2(SeriesTitleService ajc$this, Long episodeTitleId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        try {
            Title episodeTitle = ajc$this.titleManagerService.get(episodeTitleId);
            UISeriesInfo seriesInfo = new UISeriesInfo();
            Group rootAsset = (Group)episodeTitle.getAsset();
            seriesInfo.associatedSeriesDocId = rootAsset.getSeriesDocumentId() == null ? null : "" + rootAsset.getSeriesDocumentId();
            seriesInfo.associatedSeasonAssetId = rootAsset.getSeasonAssetId() == null ? null : "" + rootAsset.getSeasonAssetId();
            SeriesFieldsBuilder builder = SeriesFieldsBuilder.getInstance();
            seriesInfo.seriesList = builder.getSeriesList(episodeTitle.getPartnerId());
            if (seriesInfo.associatedSeriesDocId != null) {
                seriesInfo.seasonList = builder.getSeasonList(seriesInfo.associatedSeriesDocId);
            }
            UITitleBuilder titleBuilder = new UITitleBuilder(ajc$this.siteManager, ajc$this.titleCopyService);
            UITitleOverview titleOverView = titleBuilder.buildUITitleOverview(episodeTitle);
            ContentClass contentClass = ajc$this.ccService.getContentClassById(episodeTitle.getContentClassId().longValue());
            titleOverView.setContentClassName(contentClass.getName());
            seriesInfo.titleOverView = titleOverView;
            return seriesInfo;
        }
        catch (Exception ex) {
            throw new NeptuneException(ex.getMessage());
        }
    }

    private static final /* synthetic */ Object getSeriesTitleInfos_aroundBody3$advice(SeriesTitleService ajc$this, Long episodeTitleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SeriesTitleService.getSeriesTitleInfos_aroundBody2(ajc$this, episodeTitleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UISeriesInfo object = SeriesTitleService.getSeriesTitleInfos_aroundBody2(ajc$this, episodeTitleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void associateTitleToSeries_aroundBody4(SeriesTitleService ajc$this, Long episodeTitleID, Long seriesDocumentId, Long seasonAssetId) {
        try {
            ajc$this.titleManagerService.associateTitleToSeries(episodeTitleID, seriesDocumentId, seasonAssetId, null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static final /* synthetic */ Object associateTitleToSeries_aroundBody5$advice(SeriesTitleService ajc$this, Long episodeTitleID, Long seriesDocumentId, Long seasonAssetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            SeriesTitleService.associateTitleToSeries_aroundBody4(ajc$this, episodeTitleID, seriesDocumentId, seasonAssetId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SeriesTitleService.associateTitleToSeries_aroundBody4(ajc$this, episodeTitleID, seriesDocumentId, seasonAssetId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void disassociateTitleFromSeries_aroundBody6(SeriesTitleService ajc$this, Long episodeTitleID) {
        try {
            ajc$this.titleManagerService.dissociateTitleFromSeries(episodeTitleID);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static final /* synthetic */ Object disassociateTitleFromSeries_aroundBody7$advice(SeriesTitleService ajc$this, Long episodeTitleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            SeriesTitleService.disassociateTitleFromSeries_aroundBody6(ajc$this, episodeTitleID);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SeriesTitleService.disassociateTitleFromSeries_aroundBody6(ajc$this, episodeTitleID);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

