/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.service.TitleServiceException;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.watchpoint.pmm.title.TitleActionException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.ejb.EJBException;

public class TitleActionExceptionHandler {
    private static final String ERROR_MESSAGE_BUNDLE = "com.tandbergtv.cms.portal.content.server.title.TitleViewServiceErrorMessages";

    public TitleServiceException handleException(Throwable error) {
        if (error instanceof TitleServiceException) {
            return (TitleServiceException)((Object)error);
        }
        Throwable trueCause = null;
        trueCause = error instanceof EJBException ? ((EJBException)error).getCausedByException() : error;
        if (trueCause instanceof TitleActionException) {
            return this.handleTitleActionException((TitleActionException)trueCause);
        }
        return new TitleServiceException(trueCause.getLocalizedMessage(), false);
    }

    private TitleServiceException handleTitleActionException(TitleActionException e) {
        String errorCode = e.getErrorCode();
        String localizedMessage = this.buildLocalizedMessage(e);
        if ("TPS-003".equals(errorCode)) {
            return new ReadDeletedTitleException(localizedMessage);
        }
        return new TitleServiceException(localizedMessage, true);
    }

    private String buildLocalizedMessage(TitleActionException e) {
        Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(ERROR_MESSAGE_BUNDLE, locale);
        String message = bundle.getString(e.getErrorCode());
        MessageFormat format = new MessageFormat(message, locale);
        return format.format(e.getParameters().toArray());
    }
}

