/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.exception.BasicSearchFieldValidationException;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleBasicSearchFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiBasicSearchField;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.title.basicsearch.BasicSearchFieldProvider;
import com.tandbergtv.cms.title.basicsearch.InvalidBasicSearchPathException;
import com.tandbergtv.cms.title.search.entities.BasicSearchField;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TitleBasicSearchFieldProvider
implements ITitleBasicSearchFieldProvider,
NeptuneRemoteService {
    private IAssetSpecificationManager specificationManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    private DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();

    @Override
    public List<UiBasicSearchField> getBasicSearcFields(UiCriteriaMode uiCriteraMode) throws NeptuneException {
        return this.getBasicSearcFields(uiCriteraMode, false);
    }

    @Override
    public List<UiBasicSearchField> getInPlaceSearchFields() throws NeptuneException {
        return this.getBasicSearcFields(UiCriteriaMode.EPISODE, true);
    }

    public List<UiBasicSearchField> getBasicSearcFields(UiCriteriaMode uiCriteraMode, Boolean inPlace) throws NeptuneException {
        Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
        ArrayList<UiBasicSearchField> result = new ArrayList();
        CriteriaMode criteraMode = UiCriteriaMode.SERIES == uiCriteraMode ? CriteriaMode.SERIES : CriteriaMode.MASTER;
        List fields = new ArrayList();
        UISpecification spec = null;
        try {
            fields = inPlace.booleanValue() ? BasicSearchFieldProvider.getSearchFieldBase((Locale)locale, (CriteriaMode)criteraMode, (Boolean)inPlace) : BasicSearchFieldProvider.getSearchFieldBase((Locale)locale, (CriteriaMode)criteraMode);
        }
        catch (InvalidBasicSearchPathException e) {
            throw new BasicSearchFieldValidationException(e.getMessage());
        }
        spec = uiCriteraMode == UiCriteriaMode.EPISODE ? this.specificationManager.getUISpecification(UISpecification.Type.PACKAGE) : this.specificationManager.getUISpecification(UISpecification.Type.SERIES);
        result = this.processBasicFields(spec, fields, uiCriteraMode);
        return result;
    }

    private List<UiBasicSearchField> processBasicFields(UISpecification spec, List<BasicSearchField> fields, UiCriteriaMode uiCriteraMode) throws NeptuneException {
        ArrayList<UiBasicSearchField> result = new ArrayList<UiBasicSearchField>();
        for (BasicSearchField f : fields) {
            if (!f.isComplex()) {
                result.add(this.buildField(f));
                continue;
            }
            UiBasicSearchField uiBasicSearchField = new UiBasicSearchField(f.getAssetType(), f.getXpath(), f.getDisplayName(), null, null, UIFieldType.ASSET);
            uiBasicSearchField.setComplex(true);
            result.add(uiBasicSearchField);
        }
        return result;
    }

    private UiBasicSearchField buildField(BasicSearchField f) throws BasicSearchFieldValidationException {
        String dataTypeStr = this.dtr.determineDataType(f.getXpath());
        BaseOperator operator = null;
        UIDataType dataType = UIDataType.fromValue((String)dataTypeStr);
        switch (dataType) {
            case STRING: {
                operator = BaseOperator.CONTAINS;
                break;
            }
            case DATE: {
                operator = BaseOperator.BETWEEN;
                break;
            }
            case COMPLEX: {
                throw new RuntimeException("Unexpected variable type " + f.getXpath());
            }
            default: {
                operator = BaseOperator.EQUAL;
            }
        }
        UiBasicSearchField uiBasicSearchField = new UiBasicSearchField(f.getAssetType(), f.getXpath(), f.getDisplayName(), dataType, operator, UIFieldType.ASSET);
        uiBasicSearchField.setComplex(f.isComplex());
        return uiBasicSearchField;
    }

    public String getRelativePath() {
        return "service/content/titleService/ITitleBasicSearchFieldProvider";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }
}

