/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverrideHistory;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverridesHistoryRequest;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverridesHistoryResponse;
import com.ericsson.cms.sites.core.mediapath.IMSOOverridesManager;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleMSOOverridesHistoryService;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.UIMSOOverrideHistory;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.UIMSOOverridesHistoryRequest;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.UIMSOOverridesHistoryResponse;
import com.tandbergtv.cms.portal.content.server.infoprovider.PreferenceProvider;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.server.msooverrides.DisplayNameLookup;
import com.tandbergtv.cms.portal.ui.title.server.specification.FieldLookupService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class TitleMSOOverridesHistoryService
implements ITitleMSOOverridesHistoryService,
NeptuneRemoteService {
    private static final DateFormat DEFAULT_DATE_FORMAT_TIME_APPLIED = new SimpleDateFormat("yyyy-MM-dd h:mm:ss a");
    private static final String DATE_FORMAT_KEY_TIME_APPLIED = "ContentComponent.TitleView.MSOOverridesHistory.dateFormat";
    private IMSOOverridesManager msoOverridesManager = (IMSOOverridesManager)InjectionUtil.injectInstance((String)"cms/MSOOverridesManager/local", IMSOOverridesManager.class);
    PreferenceProvider preferenceProvider = new PreferenceProvider();
    private DateFormat dateFormatTimeApplied = DEFAULT_DATE_FORMAT_TIME_APPLIED;

    @Override
    public List<UIMSO> getMSOs(long siteTitleId) throws NeptuneException {
        ArrayList<UIMSO> uiMSOs = new ArrayList();
        List msosFromHistory = this.msoOverridesManager.getMSOsFromOverridesHistory(siteTitleId);
        uiMSOs = this.convertMSOs(msosFromHistory);
        return uiMSOs;
    }

    @Override
    public UIMSOOverridesHistoryResponse getMSOOverridesHistory(UIMSOOverridesHistoryRequest uiMSOOverridesHistoryRequest) throws NeptuneException {
        UIMSOOverridesHistoryResponse uiMSOOverridesHistoryResponse = null;
        if (uiMSOOverridesHistoryRequest != null) {
            MSOOverridesHistoryRequest msoOverridesHistoryRequest = this.convert(uiMSOOverridesHistoryRequest);
            MSOOverridesHistoryResponse msoOverridesHistoryResponse = this.msoOverridesManager.getMSOOverridesHistory(msoOverridesHistoryRequest);
            uiMSOOverridesHistoryResponse = this.convert(msoOverridesHistoryResponse);
        }
        return uiMSOOverridesHistoryResponse;
    }

    public String getRelativePath() {
        return "service/content/title/ITitleMSOOverridesHistoryService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private List<UIMSO> convertMSOs(List<MSO> msos) {
        ArrayList<UIMSO> uiMsos = new ArrayList<UIMSO>();
        for (MSO mso : msos) {
            UIMSO uiMSO = this.convertMSO(mso);
            uiMsos.add(uiMSO);
        }
        return uiMsos;
    }

    private UIMSO convertMSO(MSO mso) {
        UIMSO uiMSO = null;
        if (mso != null) {
            uiMSO = new UIMSO();
            uiMSO.setMsoId(mso.getId());
            uiMSO.setMsoName(mso.getMsoName());
        }
        return uiMSO;
    }

    private MSOOverridesHistoryRequest convert(UIMSOOverridesHistoryRequest uiMSOOverridesHistoryRequest) {
        MSOOverridesHistoryRequest msoOverridesHistoryRequest = null;
        if (uiMSOOverridesHistoryRequest != null) {
            msoOverridesHistoryRequest = new MSOOverridesHistoryRequest();
            msoOverridesHistoryRequest.setSiteTitleId(uiMSOOverridesHistoryRequest.getSiteTitleId());
            msoOverridesHistoryRequest.setMsoId(uiMSOOverridesHistoryRequest.getMsoId());
            msoOverridesHistoryRequest.setStartIndex(uiMSOOverridesHistoryRequest.getStartIndex());
            msoOverridesHistoryRequest.setNumRecords(uiMSOOverridesHistoryRequest.getNumRecords());
            msoOverridesHistoryRequest.setSortColumnName(uiMSOOverridesHistoryRequest.getSortColumnName());
            msoOverridesHistoryRequest.setAscending(uiMSOOverridesHistoryRequest.isAscending());
        }
        return msoOverridesHistoryRequest;
    }

    private UIMSOOverridesHistoryResponse convert(MSOOverridesHistoryResponse msoOverridesHistoryResponse) {
        UIMSOOverridesHistoryResponse uiMSOOverridesHistoryResponse = null;
        if (msoOverridesHistoryResponse != null) {
            this.dateFormatTimeApplied = this.preferenceProvider.getDateFormat(DATE_FORMAT_KEY_TIME_APPLIED, DEFAULT_DATE_FORMAT_TIME_APPLIED);
            uiMSOOverridesHistoryResponse = new UIMSOOverridesHistoryResponse();
            uiMSOOverridesHistoryResponse.setCount(msoOverridesHistoryResponse.getCount());
            List msoOverridesHistories = msoOverridesHistoryResponse.getMsoOverridesHistories();
            if (msoOverridesHistories != null) {
                ArrayList<UIMSOOverrideHistory> uiMSOOverridesHistories = new ArrayList<UIMSOOverrideHistory>();
                for (MSOOverrideHistory msoOverrideHistory : msoOverridesHistories) {
                    UIMSOOverrideHistory uiMSOOverrideHistory = this.convertMSOOverrideHistory(msoOverrideHistory);
                    uiMSOOverridesHistories.add(uiMSOOverrideHistory);
                }
                uiMSOOverridesHistoryResponse.setUiMSOOverrideHistories(uiMSOOverridesHistories);
            }
        }
        return uiMSOOverridesHistoryResponse;
    }

    private UIMSOOverrideHistory convertMSOOverrideHistory(MSOOverrideHistory msoOverrideHistory) {
        UIMSOOverrideHistory uiMSOOverrideHistory = null;
        if (msoOverrideHistory != null) {
            uiMSOOverrideHistory = new UIMSOOverrideHistory();
            uiMSOOverrideHistory.setOverrideHistoryId(msoOverrideHistory.getId());
            uiMSOOverrideHistory.setTimeApplied(this.dateFormatTimeApplied.format(msoOverrideHistory.getTimeApplied()));
            uiMSOOverrideHistory.setDistributedVersion(msoOverrideHistory.getDistributedVersion());
            uiMSOOverrideHistory.setFieldXPath(msoOverrideHistory.getFieldXPath());
            uiMSOOverrideHistory.setSearchValue(msoOverrideHistory.getSearchValue());
            uiMSOOverrideHistory.setReplacementValue(msoOverrideHistory.getReplacementValue());
            if (msoOverrideHistory.getFieldXPath().contains("Fields/CustomFields/CustomField")) {
                Integer split = msoOverrideHistory.getFieldXPath().indexOf("/Fields");
                String assetType = msoOverrideHistory.getFieldXPath().substring(9, split).toUpperCase();
                String field = msoOverrideHistory.getFieldXPath().substring(split);
                FieldLookupService.FieldInfo fieldInfo = FieldLookupService.getInstance().getDisplayName(FieldType.ASSET, assetType, field);
                if (fieldInfo != null) {
                    uiMSOOverrideHistory.setFieldDisplayName(fieldInfo.getFullDisplayName());
                } else {
                    uiMSOOverrideHistory.setFieldDisplayName("");
                }
            } else {
                uiMSOOverrideHistory.setFieldDisplayName(DisplayNameLookup.getFieldDisplayName((String)msoOverrideHistory.getFieldXPath()));
            }
            uiMSOOverrideHistory.setActionName(msoOverrideHistory.getActionName());
        }
        return uiMSOOverrideHistory;
    }
}

