/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.cms.portal.content.client.model.UiRuleSet;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleNormalizationRuleService;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class TitleNormalizationRuleService
implements NeptuneRemoteService,
ITitleNormalizationRuleService {
    private Logger logger = Logger.getLogger(TitleNormalizationRuleService.class);
    private static final String COMMAND_NAME = "create";
    private static final String UID = "re0101";
    private IAuthorizationService authorizationService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);
    private IRuleManager ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);

    @Override
    public List<UiRuleSet> getNormalizationRules() throws NeptuneException {
        ArrayList<UiRuleSet> normalizationRuleSets = new ArrayList<UiRuleSet>();
        if (this.authorizationService.isAuthorized("RulesManagement_View")) {
            List rulesets = this.ruleManager.getRuleSetsByPackage("NORMALIZATION");
            for (TreRuleSet r : rulesets) {
                if (!r.getEnabled().booleanValue()) continue;
                UiRuleSet uiRuleSet = new UiRuleSet(r.getRuleSetId(), r.getRuleName());
                normalizationRuleSets.add(uiRuleSet);
            }
        }
        return normalizationRuleSets;
    }

    @Override
    public void sendRuleExecutionMessage(List<Long> titleIds, Integer ruleSetId) throws NeptuneException {
        if (titleIds == null || titleIds.isEmpty() || ruleSetId == null) {
            throw new RuntimeException("Must provide a ruleSetId and at least one titleId");
        }
        StringBuffer sb = new StringBuffer();
        for (Long titleId : titleIds) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(titleId);
        }
        this.sendMessage(ruleSetId.toString(), sb.toString());
    }

    public String getRelativePath() {
        return "service/content/TitleNormalizationRuleService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private void sendMessage(String ruleSetId, String titleIds) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)UID);
        WPCLCommand command = new WPCLCommand(COMMAND_NAME);
        message.setCommand(command);
        message.getPayload().putValue("ruleSetId", ruleSetId);
        message.getPayload().putValue("titleIds", titleIds);
        SoapRouter router = new SoapRouter();
        try {
            router.send(this.getMessage(message));
            this.logger.info((Object)"Kicked off batch normalization template.");
        }
        catch (Exception e) {
            this.logger.error((Object)"DUDE, there was an error when kicking off batch normalization template.", (Throwable)e);
        }
    }

    private IMessage getMessage(WorkflowMessage wpcl) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(wpcl);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(writer));
        return new MessageImpl((IPayload)new StringPayload(writer.getBuffer().toString()));
    }
}

