/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.title.service.ITitlePropertyViewService;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.cms.portal.content.server.title.TitleActionExceptionHandler;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TitlePropertyViewService
implements ITitlePropertyViewService,
NeptuneRemoteService {
    private ITitleManager service;
    private TitleActionExceptionHandler errorHandler = new TitleActionExceptionHandler();
    private static final Logger logger = Logger.getLogger(TitlePropertyViewService.class);

    public TitlePropertyViewService() {
        this.service = ServiceLocator.getService("TitleManagerProxy", ITitleManager.class);
    }

    @Override
    public List<KeyValuePair> getTitlePropertiesByTitleId(long titleId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        ArrayList<KeyValuePair> uiList = new ArrayList<KeyValuePair>();
        Map properties = null;
        try {
            Title title = this.service.get(Long.valueOf(titleId));
            if (!title.getIsActive().booleanValue()) {
                throw new TitlePersistenceException("TPS-003");
            }
            properties = this.service.getProperties(Long.valueOf(titleId));
            for (String key : properties.keySet()) {
                uiList.add(new KeyValuePair(key, (String)properties.get(key)));
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error getting the title properties for title[" + titleId + "]: " + e.getLocalizedMessage()), (Throwable)e);
            throw this.errorHandler.handleException(e);
        }
        Collections.sort(uiList, new KeyValuePairComparator());
        return uiList;
    }

    public String getRelativePath() {
        return "service/content/title/ITitlePropertyViewService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private static final class KeyValuePairComparator
    implements Comparator<KeyValuePair> {
        private KeyValuePairComparator() {
        }

        @Override
        public int compare(KeyValuePair o1, KeyValuePair o2) {
            String key1 = o1.getKey();
            String key2 = o2.getKey();
            if (key1 != null && key2 != null) {
                return key1.compareTo(key2);
            }
            if (key1 == null && key2 == null) {
                return 0;
            }
            return key1 == null ? -1 : 1;
        }
    }
}

