/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.ericsson.cms.sites.core.ISiteManager;
import com.tandbergtv.cms.portal.content.client.model.NoPartnersException;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.model.UiInvalidQwikSrchException;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.content.server.search.export.TitleSearchExportService;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterQuickSearch;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterQuickSearchListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.server.search.UiTitleFilterService;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.AssetSearchInfo;
import com.tandbergtv.cms.title.search.entities.UnauthorizedUserException;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.search.AssetInfoProvider;
import com.tandbergtv.watchpoint.pmm.title.search.SearchPartnerProvider;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchWorkFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleSearchServiceImpl
implements TitleSearchService,
NeptuneRemoteService {
    private ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private AssetInfoProvider assetInfoProvider = TitleSearchWorkFactory.createAssetInfoProvider();
    private static TitleSearchExportService tses = TitleSearchExportService.getInstance();
    private static /* synthetic */ Annotation ajc$anno$0;

    public String getRelativePath() {
        return "service/content/titleSearchService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public UISearchResult getTitles(UITitleFilter titleFilter, List<UiColumn> columns) throws NeptuneException {
        TitleFilter filter;
        TitleSearchResult searchResults;
        String searchText;
        List partnerIds;
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        try {
            partnerIds = SearchPartnerProvider.getParnterIds((String)userName);
        }
        catch (UnauthorizedUserException unauthorizedUserException) {
            throw new NoPartnersException();
        }
        List<SearchColumn> searchColumns = TitleSearchServiceImpl.convertSeachColumns(columns);
        ArrayList<UISearchResultRec> uiTitles = new ArrayList<UISearchResultRec>();
        UiTitleFilterService utfs = new UiTitleFilterService();
        if (titleFilter.getRootNode() instanceof UITitleFilterQuickSearch) {
            CriteriaMode criteriaMode = UiCriteriaMode.SERIES == titleFilter.getCriteriaMode() ? CriteriaMode.SERIES : CriteriaMode.MASTER;
            searchText = ((UITitleFilterQuickSearch)titleFilter.getRootNode()).getSearchText();
            PagingInfo pagingInfo = new PagingInfo(titleFilter.getPageInfo().getStartIndex(), titleFilter.getPageInfo().getMaxCount());
            SortingInfo sInfo = utfs.convertSortInfo(titleFilter.getSortInfo());
            try {
                searchResults = this.searchService.getTitlesQuickSearch(searchText, partnerIds, pagingInfo, sInfo, searchColumns, criteriaMode);
            }
            catch (Exception ex) {
                throw new UiInvalidQwikSrchException(ex.getMessage());
            }
        }
        if (titleFilter.getRootNode() instanceof UITitleFilterQuickSearchListNode) {
            filter = new TitleFilter();
            utfs.convertTitleFilter(filter, titleFilter);
            searchText = ((UITitleFilterQuickSearchListNode)titleFilter.getRootNode()).getSearchText();
            try {
                searchResults = this.searchService.getTitlesQuickSearchWithAdditionalFilters(searchText, filter, partnerIds, searchColumns);
            }
            catch (Exception ex) {
                throw new UiInvalidQwikSrchException(ex.getMessage());
            }
        }
        filter = new TitleFilter();
        utfs.convertTitleFilter(filter, titleFilter);
        try {
            searchResults = this.searchService.getSearchResults(filter, partnerIds, searchColumns);
        }
        catch (Exception ex) {
            throw new UiInvalidQwikSrchException(ex.getMessage());
        }
        long count = searchResults.getCount();
        IContentClassService contentClassService = (IContentClassService)InjectionUtil.injectInstance((String)"cms/ContentClassService/local", IContentClassService.class);
        Long offerContentClassId = 0L;
        try {
            offerContentClassId = contentClassService.getOfferContentClassId();
        }
        catch (ContentClassPersistenceException e) {
            e.printStackTrace();
        }
        for (TitleSearchResult.SearchRow row : searchResults.getRows()) {
            ArrayList<UiField> fields = new ArrayList<UiField>();
            Long contentClassId = 0L;
            int i = 0;
            while (i < columns.size()) {
                UiColumn uiCol = columns.get(i);
                String value = row.getCSVs(i);
                if (value == null) {
                    value = "";
                }
                if (uiCol.getFieldType().equals((Object)UIFieldType.ASSET)) {
                    fields.add(new UiField(uiCol.getName(), uiCol.getSectionName(), uiCol.getDisplayName(), value));
                } else if (uiCol.getFieldType().equals((Object)UIFieldType.SITE) && uiCol.getName().equals("distributionSiteId")) {
                    String siteName = this.siteManager.getSite(Integer.parseInt(value)).getName();
                    fields.add(new UiField(uiCol.getName(), uiCol.getDisplayName(), siteName));
                    fields.add(new UiField(uiCol.getName(), "SiteID", value));
                } else {
                    fields.add(new UiField(uiCol.getName(), uiCol.getDisplayName(), value));
                }
                if (uiCol.getName().equals("contentClassId")) {
                    contentClassId = Long.parseLong(value);
                }
                ++i;
            }
            boolean isOffer = contentClassId.equals(offerContentClassId);
            UISearchResultRec uiObj = new UISearchResultRec(row.getId(), fields, isOffer);
            uiTitles.add(uiObj);
        }
        return new UISearchResult((int)count, uiTitles, searchResults.hasMoreResults());
    }

    public static List<SearchColumn> convertSeachColumns(List<UiColumn> uiColumns, int siteId) {
        ArrayList<SearchColumn> result = new ArrayList<SearchColumn>();
        for (UiColumn uiCol : uiColumns) {
            String colName = uiCol.getName();
            if (colName.equals("statusUpdateTime")) {
                colName = ElasticSearchUtil.createSiteStatusUpdatedTimeKey((int)siteId);
            }
            SearchColumn sc = new SearchColumn(uiCol.getSectionName(), colName, FieldType.valueOf((String)uiCol.getFieldType().name()), uiCol.getDataType().name(), uiCol.isMultiValued());
            if (uiCol.isQuickInfoField()) {
                sc.setQuickInfoField(true);
            }
            result.add(sc);
        }
        return result;
    }

    public static List<SearchColumn> convertSeachColumns(List<UiColumn> uiColumns) {
        ArrayList<SearchColumn> result = new ArrayList<SearchColumn>();
        for (UiColumn uiCol : uiColumns) {
            SearchColumn sc = new SearchColumn(uiCol.getSectionName(), uiCol.getName(), FieldType.valueOf((String)uiCol.getFieldType().name()), uiCol.getDataType().name(), uiCol.isMultiValued());
            if (uiCol.isQuickInfoField()) {
                sc.setQuickInfoField(true);
            }
            result.add(sc);
        }
        return result;
    }

    @Override
    public String performExportToExcel(UITitleFilter titleFilter, List<UiColumn> columns) throws NeptuneException {
        return tses.addEntry(titleFilter, columns);
    }

    @Override
    @Transactional
    public List<UiAsset> getAssetInfo(Long titleId, List<UiColumn> columns) throws NeptuneException {
        Long l = titleId;
        List<UiColumn> list = columns;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleSearchServiceImpl.class.getDeclaredMethod("getAssetInfo", Long.class, List.class).getAnnotation(Transactional.class);
        }
        return (List)TitleSearchServiceImpl.getAssetInfo_aroundBody1$advice(this, l, list, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<AssetSearchInfo> filterDeletedAssets(List<AssetSearchInfo> asiList) {
        ArrayList<AssetSearchInfo> filteredAssets = new ArrayList<AssetSearchInfo>();
        ArrayList<AssetSearchInfo> asiTempList = new ArrayList<AssetSearchInfo>();
        asiTempList.addAll(asiList);
        boolean added = true;
        while (added) {
            added = false;
            for (AssetSearchInfo asi : filteredAssets) {
                asiTempList.remove(asi);
            }
            for (AssetSearchInfo asi : asiTempList) {
                if (filteredAssets.contains(asi) || !this.hasParent(asi, filteredAssets)) continue;
                filteredAssets.add(asi);
                added = true;
            }
        }
        return filteredAssets;
    }

    private boolean hasParent(AssetSearchInfo asi, List<AssetSearchInfo> filteredAssets) {
        boolean hasParent = false;
        if (asi.getOwningAssetId() == 0L) {
            hasParent = true;
        } else {
            for (AssetSearchInfo filteredAsi : filteredAssets) {
                if (asi.getOwningAssetId() != filteredAsi.getAssetId()) continue;
                hasParent = true;
                break;
            }
        }
        return hasParent;
    }

    private static final /* synthetic */ List getAssetInfo_aroundBody0(TitleSearchServiceImpl ajc$this, Long titleId, List columns) {
        ArrayList<UiAsset> results = new ArrayList<UiAsset>();
        List<SearchColumn> searchColumns = TitleSearchServiceImpl.convertSeachColumns(columns);
        List<AssetSearchInfo> searchResults = ajc$this.assetInfoProvider.getAssetInfo(titleId.longValue(), searchColumns);
        searchResults = ajc$this.filterDeletedAssets(searchResults);
        for (AssetSearchInfo asi : searchResults) {
            ArrayList<UiField> fields = new ArrayList<UiField>();
            for (UiColumn col : columns) {
                if (!col.getFieldType().equals((Object)UIFieldType.ASSET)) continue;
                String xpath = col.getName();
                String displayName = col.getDisplayName();
                String value = (String)asi.getMetaDataFields().get(col.getName());
                fields.add(new UiField(xpath, displayName, value));
            }
            results.add(new UiAsset(asi.getAssetId(), asi.getAssetType(), fields));
        }
        return results;
    }

    private static final /* synthetic */ Object getAssetInfo_aroundBody1$advice(TitleSearchServiceImpl ajc$this, Long titleId, List columns, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchServiceImpl.getAssetInfo_aroundBody0(ajc$this, titleId, columns);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSearchServiceImpl.getAssetInfo_aroundBody0(ajc$this, titleId, columns);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

