/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.TargetResult;
import com.ericsson.cms.sites.dependency.ISitesDepCacheService;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UILocalTitleSites;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITitleSites;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesService;
import com.tandbergtv.cms.portal.content.client.title.service.TargetSitesResponse;
import com.tandbergtv.cms.portal.content.server.title.TitleActionExceptionHandler;
import com.tandbergtv.cms.portal.content.server.title.TitleViewService;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitleBuilder;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitleSitesBuilder;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleSitesService
implements ITitleSitesService,
NeptuneRemoteService {
    private ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private ITitleCopyService copyService = (ITitleCopyService)InjectionUtil.injectInstance((String)"cms/TitleCopyServiceProxy/local", ITitleCopyService.class);
    private TitleActionExceptionHandler errorHandler = new TitleActionExceptionHandler();
    private ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
    private static final Logger logger = Logger.getLogger(TitleViewService.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;

    public String getRelativePath() {
        return "service/content/title/ITitleSitesService";
    }

    public Class<? extends TitleSitesService> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    @Transactional
    public UITitle getTitleSites(Long titleId) throws NeptuneException {
        Long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleSitesService.class.getDeclaredMethod("getTitleSites", Long.class).getAnnotation(Transactional.class);
        }
        return (UITitle)TitleSitesService.getTitleSites_aroundBody1$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitle targetWithRules(Long masterTitleId) throws NeptuneException {
        Long l = masterTitleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleSitesService.class.getDeclaredMethod("targetWithRules", Long.class).getAnnotation(Transactional.class);
        }
        return (UITitle)TitleSitesService.targetWithRules_aroundBody3$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitle target(Long masterTitleId, List<Integer> siteIds) throws NeptuneException {
        Long l = masterTitleId;
        List<Integer> list = siteIds;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TitleSitesService.class.getDeclaredMethod("target", Long.class, List.class).getAnnotation(Transactional.class);
        }
        return (UITitle)TitleSitesService.target_aroundBody5$advice(this, l, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<String> getActiveDistributionSiteNames() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TitleSitesService.class.getDeclaredMethod("getActiveDistributionSiteNames", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)TitleSitesService.getActiveDistributionSiteNames_aroundBody7$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public TargetSitesResponse target(List<Long> titleIds, List<String> activeSiteNames) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Target"});
        Map<String, Integer> idLookUp = this.getActiveDistribitionSiteIdLookup();
        ArrayList<Integer> siteIds = new ArrayList<Integer>();
        TargetSitesResponse response = new TargetSitesResponse();
        for (String activeSiteName : activeSiteNames) {
            siteIds.add(idLookUp.get(activeSiteName));
        }
        for (Long titleId : titleIds) {
            try {
                this.siteManager.target(titleId.longValue(), siteIds);
                response.getTargetTitleIds().add(titleId);
            }
            catch (RuntimeException e) {
                logger.error((Object)("Failed in target to selected sites [" + titleId + "] from the server."), (Throwable)e);
                response.getFailedIds().put(titleId, e.getLocalizedMessage());
            }
        }
        return response;
    }

    @Override
    @Transactional
    public TargetSitesResponse distributeImmediately(long localTitleId) throws NeptuneException {
        long l = localTitleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TitleSitesService.class.getDeclaredMethod("distributeImmediately", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (TargetSitesResponse)TitleSitesService.distributeImmediately_aroundBody9$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    private UITitle buildSites(Title title) {
        UITitleSites uiSites = new UITitleSites();
        UITitleSitesBuilder sitesBuilder = new UITitleSitesBuilder(this.siteManager);
        if (!title.isCopy()) {
            sitesBuilder.buildSiteItemsForMasterTitle(title, uiSites);
        } else {
            UILocalTitleSites uiLocal = new UILocalTitleSites();
            Title originalTitle = this.titleManager.get(title.getOriginalId());
            sitesBuilder.buildSiteItemsForLocalTitle(title, originalTitle, uiLocal);
            uiSites.setLocal(uiLocal);
        }
        UITitleBuilder titleBuilder = new UITitleBuilder(this.siteManager, this.copyService);
        UITitle uiTitle = titleBuilder.buildUITitle(title);
        uiTitle.setSites(uiSites);
        return uiTitle;
    }

    private Map<String, Integer> getActiveDistribitionSiteIdLookup() {
        List activeDistSites = this.siteManager.getActiveDistributionSites();
        HashMap<String, Integer> lookUp = new HashMap<String, Integer>();
        for (DistributionSite activeDistSite : activeDistSites) {
            lookUp.put(activeDistSite.getName(), activeDistSite.getId());
        }
        return lookUp;
    }

    @Override
    @Transactional
    public Boolean getAreAllDependencySitesSelected(List<Integer> selectedSitesList) throws NeptuneException {
        List<Integer> list = selectedSitesList;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TitleSitesService.class.getDeclaredMethod("getAreAllDependencySitesSelected", List.class).getAnnotation(Transactional.class);
        }
        return (Boolean)TitleSitesService.getAreAllDependencySitesSelected_aroundBody11$advice(this, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Boolean getAreAllDependencySitesSelectedWithSiteNames(List<String> selectedSitesNames) throws NeptuneException {
        List<String> list = selectedSitesNames;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = TitleSitesService.class.getDeclaredMethod("getAreAllDependencySitesSelectedWithSiteNames", List.class).getAnnotation(Transactional.class);
        }
        return (Boolean)TitleSitesService.getAreAllDependencySitesSelectedWithSiteNames_aroundBody13$advice(this, list, transactionEnforcer, (Transactional)annotation, null);
    }

    private static final /* synthetic */ UITitle getTitleSites_aroundBody0(TitleSitesService ajc$this, Long titleId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        UITitle uiTitle = null;
        try {
            Title title = ajc$this.titleManager.get(titleId);
            if (!title.getIsActive().booleanValue()) {
                throw new TitlePersistenceException("TPS-003");
            }
            uiTitle = ajc$this.buildSites(title);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error getting the title sites for title[" + titleId + "]: " + e.getLocalizedMessage()), (Throwable)e);
            throw ajc$this.errorHandler.handleException(e);
        }
        return uiTitle;
    }

    private static final /* synthetic */ Object getTitleSites_aroundBody1$advice(TitleSitesService ajc$this, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSitesService.getTitleSites_aroundBody0(ajc$this, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitle object = TitleSitesService.getTitleSites_aroundBody0(ajc$this, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitle targetWithRules_aroundBody2(TitleSitesService ajc$this, Long masterTitleId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Target"});
        TreeSet<String> activeSiteNames = new TreeSet<String>();
        TreeSet<String> inactiveSiteNames = new TreeSet<String>();
        try {
            TargetResult res = ajc$this.siteManager.targetWithRules(masterTitleId.longValue());
            Set activeSites = res.getActiveSites();
            Set inactiveSites = res.getInactiveSites();
            if (activeSites != null) {
                for (Site activeSite : activeSites) {
                    activeSiteNames.add(activeSite.getName());
                }
            }
            if (inactiveSites != null) {
                for (Site inactiveSite : inactiveSites) {
                    inactiveSiteNames.add(inactiveSite.getName());
                }
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed in target to sites with rules [" + masterTitleId + "] from the server."), (Throwable)e);
            throw ajc$this.errorHandler.handleException(e);
        }
        UITitle uiTitle = ajc$this.getTitleSites(masterTitleId);
        uiTitle.getSites().setActiveSiteNames(activeSiteNames);
        uiTitle.getSites().setInactiveSiteNames(inactiveSiteNames);
        return uiTitle;
    }

    private static final /* synthetic */ Object targetWithRules_aroundBody3$advice(TitleSitesService ajc$this, Long masterTitleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSitesService.targetWithRules_aroundBody2(ajc$this, masterTitleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitle object = TitleSitesService.targetWithRules_aroundBody2(ajc$this, masterTitleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitle target_aroundBody4(TitleSitesService ajc$this, Long masterTitleId, List siteIds) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Target"});
        try {
            ajc$this.siteManager.target(masterTitleId.longValue(), siteIds);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed in target to selected sites [" + masterTitleId + "] from the server."), (Throwable)e);
            throw ajc$this.errorHandler.handleException(e);
        }
        return ajc$this.getTitleSites(masterTitleId);
    }

    private static final /* synthetic */ Object target_aroundBody5$advice(TitleSitesService ajc$this, Long masterTitleId, List siteIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSitesService.target_aroundBody4(ajc$this, masterTitleId, siteIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitle object = TitleSitesService.target_aroundBody4(ajc$this, masterTitleId, siteIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getActiveDistributionSiteNames_aroundBody6(TitleSitesService ajc$this) {
        List activeDistSites;
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        ArrayList<String> activeSiteNames = new ArrayList<String>();
        try {
            activeDistSites = ajc$this.siteManager.getActiveDistributionSites();
            Collections.sort(activeDistSites);
        }
        catch (RuntimeException e) {
            logger.error((Object)"Failed to retrive active distribution sites from the server.", (Throwable)e);
            throw ajc$this.errorHandler.handleException(e);
        }
        for (DistributionSite activeDistSite : activeDistSites) {
            activeSiteNames.add(activeDistSite.getName());
        }
        return activeSiteNames;
    }

    private static final /* synthetic */ Object getActiveDistributionSiteNames_aroundBody7$advice(TitleSitesService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSitesService.getActiveDistributionSiteNames_aroundBody6(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSitesService.getActiveDistributionSiteNames_aroundBody6(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TargetSitesResponse distributeImmediately_aroundBody8(TitleSitesService ajc$this, long localTitleId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Distribute"});
        TargetSitesResponse response = new TargetSitesResponse();
        try {
            DistributionSiteTitle dst = ajc$this.siteManager.getDistributionSiteTitle(localTitleId);
            if (dst.getStatus() == DistributionStatus.TARGETED || dst.getStatus() == DistributionStatus.IN_PROGRESS) {
                throw new NeptuneException("Cannot distribute title: " + localTitleId + ", status is: " + dst.getStatus());
            }
            ajc$this.siteManager.distributeImmediately(dst.getDistributionSite().getId().intValue(), Arrays.asList(localTitleId));
            response.getTargetTitleIds().add(localTitleId);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to distribute to site [" + localTitleId + "] from the server."), (Throwable)e);
            response.getFailedIds().put(localTitleId, e.getLocalizedMessage());
        }
        return response;
    }

    private static final /* synthetic */ Object distributeImmediately_aroundBody9$advice(TitleSitesService ajc$this, long localTitleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSitesService.distributeImmediately_aroundBody8(ajc$this, localTitleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TargetSitesResponse object = TitleSitesService.distributeImmediately_aroundBody8(ajc$this, localTitleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Boolean getAreAllDependencySitesSelected_aroundBody10(TitleSitesService ajc$this, List selectedSitesList) {
        Boolean areAllDependencySitesSelected = false;
        try {
            areAllDependencySitesSelected = ajc$this.sitesDepSvc.areAllDependencySitesSelected(selectedSitesList);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to check if all selected sites have dependencies.", (Throwable)e);
            throw ajc$this.errorHandler.handleException(e);
        }
        return areAllDependencySitesSelected;
    }

    private static final /* synthetic */ Object getAreAllDependencySitesSelected_aroundBody11$advice(TitleSitesService ajc$this, List selectedSitesList, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSitesService.getAreAllDependencySitesSelected_aroundBody10(ajc$this, selectedSitesList);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Boolean object = TitleSitesService.getAreAllDependencySitesSelected_aroundBody10(ajc$this, selectedSitesList);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Boolean getAreAllDependencySitesSelectedWithSiteNames_aroundBody12(TitleSitesService ajc$this, List selectedSitesNames) {
        ArrayList<Integer> selectedSiteIds = new ArrayList<Integer>();
        try {
            for (String siteName : selectedSitesNames) {
                Site site = ajc$this.siteManager.getSiteByName(siteName);
                if (site == null) continue;
                selectedSiteIds.add(site.getId());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get siteIds from siteNames.", (Throwable)e);
            throw ajc$this.errorHandler.handleException(e);
        }
        Boolean areAllDependencySitesSelected = ajc$this.getAreAllDependencySitesSelected(selectedSiteIds);
        return areAllDependencySitesSelected;
    }

    private static final /* synthetic */ Object getAreAllDependencySitesSelectedWithSiteNames_aroundBody13$advice(TitleSitesService ajc$this, List selectedSitesNames, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSitesService.getAreAllDependencySitesSelectedWithSiteNames_aroundBody12(ajc$this, selectedSitesNames);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Boolean object = TitleSitesService.getAreAllDependencySitesSelectedWithSiteNames_aroundBody12(ajc$this, selectedSitesNames);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

