/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.ericsson.cms.me.service.IMEManagerLocal;
import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.mediapath.IMSOOverridesManager;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.ericsson.rules.fieldprovider.metadataenhancement.ISubscriptionProfileProvider;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.title.model.UIActionTitle;
import com.tandbergtv.cms.portal.content.client.title.model.UIMetadataEnhInfo;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleMetadataPluginsSyncedResult;
import com.tandbergtv.cms.portal.content.client.title.model.UIViewInfo;
import com.tandbergtv.cms.portal.content.client.title.model.compare.TitleCompareRequest;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.TitleFileIOException;
import com.tandbergtv.cms.portal.content.client.title.service.TitlePreviewException;
import com.tandbergtv.cms.portal.content.client.title.service.TitleServiceException;
import com.tandbergtv.cms.portal.content.client.title.service.TitleValidationUIException;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.UIRevisionInfo;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.UITitleInfo;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.cms.portal.content.server.contentclass.ContentClassViewService;
import com.tandbergtv.cms.portal.content.server.title.CategoryTitleService;
import com.tandbergtv.cms.portal.content.server.title.TitleActionExceptionHandler;
import com.tandbergtv.cms.portal.content.server.title.metadata.AssetModelConverter;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UIEnumerationBuilder;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitleBuilder;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitleCompareDataBuilder;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitleHistoryBuilder;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitlePreviewBuilder;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitleValidationMessageBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITitleStatus;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.FatalTitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.IPMMUIService;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.entities.compare.ITitleCompareReport;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleCompareService;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleViewService
implements ITitleViewService,
NeptuneRemoteService {
    private final IAssetSpecificationManager specificationManager;
    private final ITitleManager titleManagerService;
    private final IContentClassService contentClassService;
    private final ITitleCopyService titleCopyService;
    private final ITitleCompareService titleCompareService;
    private final ISiteManager siteManager;
    private final IMSOOverridesManager msoOverridesManager;
    private IPartnerUserManager partnerUserManager = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
    private IMEManagerLocal meManager = (IMEManagerLocal)InjectionUtil.injectInstance((String)"cms/MEManager/local", IMEManagerLocal.class);
    private ISubscriptionProfileProvider subProfileProvider = (ISubscriptionProfileProvider)InjectionUtil.injectInstance((String)"cms/SubscriptionProfileProvider/local", ISubscriptionProfileProvider.class);
    private final ITitleAssetResourceManager resourceManager;
    private final TitleActionExceptionHandler exceptionHandler;
    private HttpSession httpSession;
    private static final Logger logger = Logger.getLogger(TitleViewService.class);
    private static final String ERROR_MESSAGE_BUNDLE = "com.tandbergtv.cms.portal.content.server.title.TitleViewServiceErrorMessages";
    private static final String COMPONENT_NAME = "Content Management";
    private static final String ENTITY_NAME = null;
    private static final String UNIQUE_INDEX = "unique";
    private static final String NON_UNIQUE_INDEX = "non_unique";
    private static final String IS_SYNCING_METADATA_PLUGINS = "isSyncingMetadataPlugins";
    private static final String IS_SYNCING_METADATA_PLUGINS_MAP = "isSyncingMetadataPluginsMap";
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ Annotation ajc$anno$13;

    public TitleViewService() {
        this.specificationManager = ServiceLocator.getService("AssetSpecificationManager", IAssetSpecificationManager.class);
        this.titleManagerService = ServiceLocator.getService("TitleManagerProxy", ITitleManager.class);
        this.titleCopyService = ServiceLocator.getService("TitleCopyServiceProxy", ITitleCopyService.class);
        this.titleCompareService = ServiceLocator.getService("TitleCompareServiceProxy", ITitleCompareService.class);
        this.siteManager = ServiceLocator.getService("SiteManager", ISiteManager.class);
        this.msoOverridesManager = ServiceLocator.getService("MSOOverridesManager", IMSOOverridesManager.class);
        this.resourceManager = (ITitleAssetResourceManager)ServiceRegistry.getDefault().lookup(ITitleAssetResourceManager.class);
        this.contentClassService = ServiceLocator.getService("ContentClassService", IContentClassService.class);
        this.exceptionHandler = new TitleActionExceptionHandler();
    }

    @Override
    @Transactional
    public UITitle createTitle(UITitle title, String meRequestKey) throws NeptuneException, TitleValidationUIException {
        UITitle uITitle = title;
        String string = meRequestKey;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleViewService.class.getDeclaredMethod("createTitle", UITitle.class, String.class).getAnnotation(Transactional.class);
        }
        return (UITitle)TitleViewService.createTitle_aroundBody1$advice(this, uITitle, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitle createTitleAsDraft(UITitle title) throws NeptuneException {
        UITitle uITitle = title;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleViewService.class.getDeclaredMethod("createTitleAsDraft", UITitle.class).getAnnotation(Transactional.class);
        }
        return (UITitle)TitleViewService.createTitleAsDraft_aroundBody3$advice(this, uITitle, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitle updateTitleMetadata(UITitle title, Long requestKey, String action, String listOfAssetIds, String meRequestKey) throws NeptuneException {
        UITitle uITitle = title;
        Long l = requestKey;
        String string = action;
        String string2 = listOfAssetIds;
        String string3 = meRequestKey;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TitleViewService.class.getDeclaredMethod("updateTitleMetadata", UITitle.class, Long.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (UITitle)TitleViewService.updateTitleMetadata_aroundBody5$advice(this, uITitle, l, string, string2, string3, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitle updateTitleMetadataAsDraft(UITitle title) throws NeptuneException, TitleServiceException {
        UITitle uITitle = title;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TitleViewService.class.getDeclaredMethod("updateTitleMetadataAsDraft", UITitle.class).getAnnotation(Transactional.class);
        }
        return (UITitle)TitleViewService.updateTitleMetadataAsDraft_aroundBody7$advice(this, uITitle, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public void batchUpdateTitleMetadata(UITitle updates, List<Long> titleIds, boolean draft, boolean currentState) throws NeptuneException, TitleServiceException {
        UITitle uITitle = updates;
        List<Long> list = titleIds;
        boolean bl = draft;
        boolean bl2 = currentState;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TitleViewService.class.getDeclaredMethod("batchUpdateTitleMetadata", UITitle.class, List.class, Boolean.TYPE, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        TitleViewService.batchUpdateTitleMetadata_aroundBody9$advice(this, uITitle, list, bl, bl2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitle getTitle(Long titleId) throws NeptuneException {
        Long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TitleViewService.class.getDeclaredMethod("getTitle", Long.class).getAnnotation(Transactional.class);
        }
        return (UITitle)TitleViewService.getTitle_aroundBody11$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitle getTitleHistory(Long titleId) throws NeptuneException {
        Long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = TitleViewService.class.getDeclaredMethod("getTitleHistory", Long.class).getAnnotation(Transactional.class);
        }
        return (UITitle)TitleViewService.getTitleHistory_aroundBody13$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitleInfo getTitleRevisionInfo(Long titleId, String titleRevision) throws NeptuneException, TitleServiceException {
        Long l = titleId;
        String string = titleRevision;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = TitleViewService.class.getDeclaredMethod("getTitleRevisionInfo", Long.class, String.class).getAnnotation(Transactional.class);
        }
        return (UITitleInfo)TitleViewService.getTitleRevisionInfo_aroundBody15$advice(this, l, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public void rollbackTitle(Long titleId, String titleRevision) throws NeptuneException {
        Long l = titleId;
        String string = titleRevision;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = TitleViewService.class.getDeclaredMethod("rollbackTitle", Long.class, String.class).getAnnotation(Transactional.class);
        }
        TitleViewService.rollbackTitle_aroundBody17$advice(this, l, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public void rollbackTitleAsDraft(Long titleId, String titleRevision) throws NeptuneException {
        Long l = titleId;
        String string = titleRevision;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = TitleViewService.class.getDeclaredMethod("rollbackTitleAsDraft", Long.class, String.class).getAnnotation(Transactional.class);
        }
        TitleViewService.rollbackTitleAsDraft_aroundBody19$advice(this, l, string, transactionEnforcer, (Transactional)annotation, null);
    }

    private void logRollbackFailure(Long titleId, String revision, Exception e) {
        String msg = "Failed to roll back to title[Id=" + titleId + ", revision=" + revision + "], error: " + e.getMessage();
        logger.error((Object)msg, (Throwable)e);
    }

    @Override
    public String previewTitle(UIActionTitle uiTitle, String specificationName, boolean useHtml) throws NeptuneException, TitlePreviewException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        Title titleToPreview = this.getTitle(uiTitle);
        return this.previewTitle(titleToPreview, specificationName, useHtml);
    }

    @Override
    public List<UIAssetFilePath> getAvailableFilePaths() throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        ArrayList<UIAssetFilePath> filePaths = new ArrayList<UIAssetFilePath>();
        File unmappedFolder = this.getAssetsManager().getUnmappedFilesDirectory();
        String unmappedFolderPath = unmappedFolder.getAbsolutePath();
        long t0 = System.currentTimeMillis();
        List unmappedFiles = null;
        try {
            unmappedFiles = this.getAssetsManager().getUnmappedFiles();
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to get the unmapped files from the server.", (Throwable)ex);
            throw new TitleFileIOException("Failed to get the unmapped files, error: " + ex.getMessage());
        }
        long t1 = System.currentTimeMillis();
        logger.info((Object)("Time to getUnmappedFiles - time:" + (t1 - t0)));
        String repositoryPath = null;
        String relativePath = null;
        int index = unmappedFolderPath.length() + 1;
        for (File file : unmappedFiles) {
            String filePath = file.getAbsolutePath();
            if (filePath.startsWith(unmappedFolderPath)) {
                repositoryPath = filePath.substring(0, index);
                relativePath = filePath.substring(index);
            } else {
                repositoryPath = "";
                relativePath = filePath;
            }
            UIAssetFilePath assetFilePath = new UIAssetFilePath();
            assetFilePath.setRepositoryPath(repositoryPath);
            assetFilePath.setRelativePath(relativePath);
            filePaths.add(assetFilePath);
        }
        Collections.sort(filePaths, new Comparator<UIAssetFilePath>(){

            @Override
            public int compare(UIAssetFilePath o1, UIAssetFilePath o2) {
                return o1.getFilePath().compareTo(o2.getFilePath());
            }
        });
        long t2 = System.currentTimeMillis();
        logger.info((Object)("Time to sort UnmappedFiles - time:" + (t2 - t1)));
        UIAssetFilePath assetFilePath = new UIAssetFilePath();
        assetFilePath.setRepositoryPath(unmappedFolderPath);
        assetFilePath.setRelativePath(relativePath);
        filePaths.add(assetFilePath);
        return filePaths;
    }

    @Override
    @Transactional
    public UITitleCompareData compareTitles(TitleCompareRequest request) throws NeptuneException {
        TitleCompareRequest titleCompareRequest = request;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = TitleViewService.class.getDeclaredMethod("compareTitles", TitleCompareRequest.class).getAnnotation(Transactional.class);
        }
        return (UITitleCompareData)TitleViewService.compareTitles_aroundBody21$advice(this, titleCompareRequest, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitleCompareXmlData compareTitlePreviews(UIActionTitle uiTitle1, UIActionTitle uiTitle2, String specificationName, boolean useHtml) throws NeptuneException {
        UIActionTitle uIActionTitle = uiTitle1;
        UIActionTitle uIActionTitle2 = uiTitle2;
        String string = specificationName;
        boolean bl = useHtml;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = TitleViewService.class.getDeclaredMethod("compareTitlePreviews", UIActionTitle.class, UIActionTitle.class, String.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (UITitleCompareXmlData)TitleViewService.compareTitlePreviews_aroundBody23$advice(this, uIActionTitle, uIActionTitle2, string, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    private Title getTitle(UIActionTitle uiTitle) {
        Title title = null;
        if (uiTitle.useMetadataModel()) {
            title = new Title();
            title.setId(uiTitle.getTitleId());
            AssetModelConverter converter = new AssetModelConverter();
            title.setAsset(converter.convert(uiTitle.getMetadata().getRootAsset()));
        } else if (uiTitle.getVersion() != null) {
            title = this.titleManagerService.get(uiTitle.getTitleId(), uiTitle.getVersion());
            this.validateActiveTitle(title);
        } else {
            title = this.titleManagerService.get(uiTitle.getTitleId());
            this.validateActiveTitle(title);
        }
        return title;
    }

    private String previewTitle(Title title, String specificationName, boolean useHtml) throws NeptuneException {
        UITitlePreviewBuilder generator = new UITitlePreviewBuilder(this.httpSession, this.titleManagerService, useHtml);
        return generator.generatePreview(title, this.getSpecification(specificationName));
    }

    private Specification getSpecification(String specificationName) {
        return this.specificationManager.getSpecification(specificationName);
    }

    public String getRelativePath() {
        return "service/content/title/ITitleViewService";
    }

    public Class<? extends TitleViewService> getServiceImplementation() {
        return this.getClass();
    }

    private Title buildTitle(UITitle uiTitle) {
        Title title = new Title();
        title.setId(uiTitle.getId());
        if (uiTitle.getOverview() != null) {
            title.setOriginalId(uiTitle.getOverview().getOriginalId());
        }
        title.setContentClassId(uiTitle.getContentClassId());
        title.setPartnerId(uiTitle.getPartnerId());
        AssetModelConverter converter = new AssetModelConverter();
        title.setAsset(converter.convert(uiTitle.getMetadata().getRootAsset()));
        return title;
    }

    private UITitle buildUITitleWithMetadata(Title title, List<TitleValidationMessage> messages) {
        UITitleBuilder titleBuilder = new UITitleBuilder(this.siteManager, this.titleCopyService);
        UITitleValidationMessageBuilder messageBuilder = new UITitleValidationMessageBuilder();
        UITitle uiTitle = titleBuilder.buildUITitle(title);
        uiTitle.setMetadata(this.buildMetadata(title));
        List<UITitleValidationMessage> uiMessages = uiTitle.getMetadata().getValidationMessages();
        messageBuilder.buildValidationMessages(messages, uiMessages);
        return uiTitle;
    }

    private UITitle buildUITitleWithHistory(Title title, boolean isSeriesTitle) {
        UITitleBuilder titleBuilder = new UITitleBuilder(this.siteManager, this.titleCopyService);
        UITitleHistoryBuilder historyBuilder = new UITitleHistoryBuilder();
        UITitle uiTitle = titleBuilder.buildUITitle(title);
        uiTitle.setHistory(historyBuilder.build(title, isSeriesTitle));
        return uiTitle;
    }

    private UITitleMetadata buildMetadata(Title title) {
        Map<Long, TitleAssetResource> thumbnailMap = this.getThumbnailMap(title);
        UITitleMetadata metadata = new UITitleMetadata();
        AssetModelConverter converter = new AssetModelConverter();
        metadata.setRootAsset(converter.convert(title.getAsset(), thumbnailMap));
        metadata.setActive(title.getIsActive());
        metadata.setTitleStatus((UITitleStatus)UIEnumerationBuilder.getUIStatusEnumValue((Enum)title.getStatus(), (Enum[])UITitleStatus.values()));
        return metadata;
    }

    private Map<Long, TitleAssetResource> getThumbnailMap(Title title) {
        HashMap<Long, TitleAssetResource> thumbnailMap = new HashMap<Long, TitleAssetResource>();
        List resources = null;
        if (title.getId() != null) {
            resources = this.resourceManager.getThumbnails(title.getId().longValue());
        }
        if (resources != null) {
            for (TitleAssetResource resource : resources) {
                thumbnailMap.put(resource.getAssetId(), resource);
            }
        }
        return thumbnailMap;
    }

    private void buildActionResultMessages(String message, List<UITitleValidationMessage> uiMessages) {
        if (message != null && !message.trim().isEmpty()) {
            UITitleValidationMessage uiMessage = new UITitleValidationMessage(message, UITitleValidationMessageType.Warning);
            uiMessages.add(uiMessage);
        }
    }

    private void throwUIValidationException(TitleValidationException e, String message) throws TitleValidationUIException {
        ArrayList<UITitleValidationMessage> uiMessages = new ArrayList<UITitleValidationMessage>();
        UITitleValidationMessageBuilder messageBuilder = new UITitleValidationMessageBuilder();
        messageBuilder.buildValidationMessages(e.getMessages(), uiMessages);
        boolean fatal = e instanceof FatalTitleValidationException;
        if (fatal) {
            message = this.buildLocalizedMessage((FatalTitleValidationException)e);
        }
        throw new TitleValidationUIException(uiMessages, fatal, message);
    }

    @Override
    public void sendSelectAssetNotification(Long titleId, Long assetId, Long requestKey) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"});
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"CM0107");
        WPCLCommand command = new WPCLCommand("task-complete");
        message.setCommand(command);
        MessageKeyImpl key = new MessageKeyImpl((Object)requestKey);
        message.setKey((IMessageKey)key);
        message.getPayload().putValue("Title Id", String.valueOf(titleId));
        message.getPayload().putValue("Asset Id", String.valueOf(assetId));
        SoapRouter router = new SoapRouter();
        try {
            router.send(new WPCLConverter().convert(message));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to send select asset message, error: " + e.getLocalizedMessage()), (Throwable)e);
            throw this.exceptionHandler.handleException(e);
        }
    }

    @Override
    public void sendValidationSuccessConfirmation(Long requestKey) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"});
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"CM0108");
        WPCLCommand command = new WPCLCommand("task-complete");
        message.setCommand(command);
        MessageKeyImpl key = new MessageKeyImpl((Object)requestKey);
        message.setKey((IMessageKey)key);
        SoapRouter router = new SoapRouter();
        try {
            router.send(new WPCLConverter().convert(message));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to send validation success message, error: " + e.getLocalizedMessage()), (Throwable)e);
            throw this.exceptionHandler.handleException(e);
        }
    }

    @Override
    public void sendMEDeconflictSuccessConfirmation(Long requestKey) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"});
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"CM0110");
        WPCLCommand command = new WPCLCommand("task-complete");
        message.setCommand(command);
        MessageKeyImpl key = new MessageKeyImpl((Object)requestKey);
        message.setKey((IMessageKey)key);
        SoapRouter router = new SoapRouter();
        try {
            router.send(new WPCLConverter().convert(message));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to send Metadata Enhancement Deconflict success message, error: " + e.getLocalizedMessage()), (Throwable)e);
            throw this.exceptionHandler.handleException(e);
        }
    }

    @Override
    public Boolean hasViewPermission(Long titleId) throws NeptuneException {
        Boolean hasPermission = NeptuneAuthorizationManager.hasPermission((String[])new String[]{"AssetManagement_View"});
        if (titleId != null && hasPermission.booleanValue() && !this.partnerUserManager.isSelfPartnerUser()) {
            boolean foundPartner = false;
            Long partnerId = this.titleManagerService.getPartnerId(titleId);
            for (Partner partner : this.partnerUserManager.getPartnersByCurrentUser()) {
                if (!partnerId.equals(partner.getId())) continue;
                foundPartner = true;
                break;
            }
            if (!foundPartner) {
                hasPermission = false;
            }
        }
        return hasPermission;
    }

    @Override
    public UIViewInfo getViewInfo(UITitle uiTitle) throws NeptuneException {
        UIViewInfo info = new UIViewInfo();
        Long titleId = uiTitle.getId();
        info.setViewPermission(this.hasViewPermission(titleId));
        if (titleId == null) {
            info.setIsSiteTitle(false);
            info.setIsMediaPathSiteTitle(false);
            try {
                Long contentClassId = uiTitle.getContentClassId();
                ContentClass.Type contentClassType = this.contentClassService.getContentClassById(contentClassId.longValue()).getType();
                boolean isPackage = contentClassType.equals((Object)ContentClass.Type.Package);
                boolean isOffer = contentClassType.equals((Object)ContentClass.Type.Offer);
                info.setIsPackageTitle(isPackage);
                info.setIsOfferTitle(isOffer);
            }
            catch (ContentClassPersistenceException e) {
                logger.error((Object)e);
                throw new TitleServiceException(e.getMessage(), false);
            }
        }
        Title title = null;
        try {
            title = this.titleManagerService.get(titleId);
            info.setIsPackageTitle(this.titleManagerService.isPackage(titleId));
            info.setIsOfferTitle(this.titleManagerService.isOffer(titleId));
        }
        catch (RuntimeException e) {
            logger.error((Object)e);
            throw new TitleServiceException("Invalid Title ID " + titleId, false);
        }
        catch (TitleValidationException e) {
            logger.error((Object)e);
            throw new TitleServiceException(e.getMessage(), false);
        }
        boolean isSiteTitle = title.isCopy();
        info.setIsSiteTitle(isSiteTitle);
        if (isSiteTitle) {
            info.setIsMediaPathSiteTitle(this.isMediaPathSiteTitle(titleId));
        } else {
            info.setIsMediaPathSiteTitle(false);
        }
        return info;
    }

    @Override
    public Boolean isMediaPathSiteTitle(Long titleId) throws NeptuneException {
        return this.msoOverridesManager.isMediaPathSiteTitle(titleId);
    }

    private String buildLocalizedMessage(FatalTitleValidationException e) {
        Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(ERROR_MESSAGE_BUNDLE, locale);
        return bundle.getString(e.getErrorCode());
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    private void validateActiveTitle(Title title) {
        if (!title.getIsActive().booleanValue()) {
            String msg = "Failed to get title[" + title.getId() + "], error: title has been deleted.";
            String errorCode = "TPS-003";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg);
            error.getParameters().add(String.valueOf(title.getId()));
            error.getParameters().add(Long.toString(title.getAsset().getId()));
            error.getParameters().add(msg);
            throw error;
        }
    }

    @Override
    @Transactional
    public UITitleInfo getTitleMetadataInfoForBatch(Long contentClassId) throws NeptuneException {
        Long l = contentClassId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = TitleViewService.class.getDeclaredMethod("getTitleMetadataInfoForBatch", Long.class).getAnnotation(Transactional.class);
        }
        return (UITitleInfo)TitleViewService.getTitleMetadataInfoForBatch_aroundBody25$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitleInfo getTitleMetadataInfo(Long titleId, Long contentClassId, Long partnerId) throws NeptuneException {
        Long l = titleId;
        Long l2 = contentClassId;
        Long l3 = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = TitleViewService.class.getDeclaredMethod("getTitleMetadataInfo", Long.class, Long.class, Long.class).getAnnotation(Transactional.class);
        }
        return (UITitleInfo)TitleViewService.getTitleMetadataInfo_aroundBody27$advice(this, l, l2, l3, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public UIMetadataEnhInfo searchMetadataEnhancement(UITitle title) throws NeptuneException {
        UIMetadataEnhInfo info = new UIMetadataEnhInfo();
        Title titleToEnhance = this.buildTitle(title);
        String requestKey = UUID.randomUUID().toString();
        try {
            TreEvent event = title.getId() == null ? TreEvent.UICREATED : TreEvent.UIUPDATED;
            Collection profiles = this.subProfileProvider.getSubscriptionProfiles(titleToEnhance, event);
            info.setSubProfileIds(profiles);
            if (profiles == null || profiles.isEmpty()) {
                logger.info((Object)("No Subscription profile(s) found for this title" + profiles.toString()));
                return info;
            }
            Boolean multipleMatches = this.meManager.searchEnhancement(profiles, titleToEnhance, requestKey);
            info.setRequestKey(requestKey.toString());
            info.setIsMultipleMatches(multipleMatches);
        }
        catch (RuntimeException e) {
            logger.error((Object)e);
            this.meManager.deleteRequest(requestKey);
            throw this.exceptionHandler.handleException(e);
        }
        return info;
    }

    @Override
    public void cleanUpMetadataEnhancementRequest(String meRequestKey) throws NeptuneException {
        try {
            this.meManager.deleteRequest(meRequestKey);
        }
        catch (RuntimeException e) {
            logger.error((Object)e);
            throw this.exceptionHandler.handleException(e);
        }
    }

    @Override
    public UITitleMetadataPluginsSyncedResult syncAllMetadataSpecIdIndexWithPlugins() throws NeptuneException {
        UITitleMetadataPluginsSyncedResult result = null;
        IClusterService hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        HazelcastInstance hazelcastInstance = hzcs.getInstance();
        IMap map = hazelcastInstance.getMap(IS_SYNCING_METADATA_PLUGINS_MAP);
        if (map.get((Object)IS_SYNCING_METADATA_PLUGINS) != null && ((Boolean)map.get((Object)IS_SYNCING_METADATA_PLUGINS)).booleanValue()) {
            logger.info((Object)"Other node is doing the metadata plugin sync work, return now");
            return result;
        }
        map.put((Object)IS_SYNCING_METADATA_PLUGINS, (Object)Boolean.TRUE);
        logger.info((Object)"Begin sync metadata plugin identifiers");
        try {
            result = this.syncMetadataPlugins();
        }
        finally {
            map.put((Object)IS_SYNCING_METADATA_PLUGINS, (Object)Boolean.FALSE);
        }
        return result;
    }

    private UITitleMetadataPluginsSyncedResult syncMetadataPlugins() throws TitleServiceException {
        UITitleMetadataPluginsSyncedResult result = new UITitleMetadataPluginsSyncedResult();
        ISpecificationManager specMgr = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        Map<String, Map<String, List<String>>> allFields = this.getAllIndexesOnMdmIdentifierTable(specMgr);
        Map<String, List<String>> uniqueIndexes = allFields.get(UNIQUE_INDEX);
        Map<String, List<String>> nonUniqueIndexes = allFields.get(NON_UNIQUE_INDEX);
        boolean isResyncRequired = false;
        ArrayList<String> titleWithDuplicateIdentifiers = new ArrayList<String>();
        ArrayList<String> existingSpecs = new ArrayList<String>();
        for (ISpecHandler handler : specMgr.getAllSpecificationForValidate()) {
            String titleIds;
            String specName = handler.getSpecName();
            logger.info((Object)("Now handling spec : " + specName));
            existingSpecs.add(handler.getSpecName().toLowerCase());
            Collection<String> specTTVPaths = this.getSpecTTVPaths(handler);
            if (this.isUniqueIndexSyncWithPlugins(handler.getSpecName(), specTTVPaths, uniqueIndexes)) continue;
            if (!this.isNonUniqueIndexContainsAllTTVPaths(specTTVPaths, nonUniqueIndexes)) {
                isResyncRequired = true;
            }
            if (!StringUtils.isNotBlank((String)(titleIds = handler.createUniqueIndex(specName, specTTVPaths)))) continue;
            titleWithDuplicateIdentifiers.add(titleIds);
        }
        this.dropNonUniqueIndexes(specMgr, nonUniqueIndexes);
        if (this.dropNonExistingIndexes(specMgr, uniqueIndexes, existingSpecs)) {
            isResyncRequired = true;
        }
        result.setResyncRequired(isResyncRequired);
        result.setTitleIdsWithDuplicateIdentifiers(StringUtils.join(titleWithDuplicateIdentifiers, (String)","));
        return result;
    }

    private boolean dropNonExistingIndexes(ISpecificationManager specMgr, Map<String, List<String>> uniqueIndexes, List<String> existingSpecs) {
        Set<String> nonExisting = this.getNonExistingUniqueIndexs(uniqueIndexes.keySet(), existingSpecs);
        if (nonExisting.isEmpty()) {
            return false;
        }
        Specification internalSpecification = specMgr.getInternalSpecification();
        ISpecHandler specHandler = internalSpecification.getSpecHandler();
        logger.info((Object)("Deleting the not existing metadata spec unique indexes: " + StringUtils.join(nonExisting, (String)",")));
        specHandler.dropIndexes(nonExisting);
        return true;
    }

    private void dropNonUniqueIndexes(ISpecificationManager specMgr, Map<String, List<String>> nonUniqueIndexes) {
        if (!nonUniqueIndexes.isEmpty()) {
            Specification internalSpecification = specMgr.getInternalSpecification();
            ISpecHandler specHandler = internalSpecification.getSpecHandler();
            specHandler.dropIndexes(nonUniqueIndexes.keySet());
        }
    }

    private Map<String, Map<String, List<String>>> getAllIndexesOnMdmIdentifierTable(ISpecificationManager specMgr) throws TitleServiceException {
        Specification internalSpecification = specMgr.getInternalSpecification();
        ISpecHandler specHandler = internalSpecification.getSpecHandler();
        try {
            return specHandler.getAllIndexFields();
        }
        catch (MetadataException e) {
            logger.error((Object)e);
            throw this.exceptionHandler.handleException(e);
        }
    }

    private boolean isUniqueIndexSyncWithPlugins(String specAlias, Collection<String> ttvPath, Map<String, List<String>> uniqueIndexs) {
        boolean result = false;
        Collection<List<String>> uniqueIndexValues = uniqueIndexs.values();
        for (List<String> indexes : uniqueIndexValues) {
            if (!indexes.containsAll(ttvPath) || !ttvPath.containsAll(indexes)) continue;
            logger.info((Object)("The unique index is already sync with metadata specification: " + specAlias));
            result = true;
            break;
        }
        return result;
    }

    private boolean isNonUniqueIndexContainsAllTTVPaths(Collection<String> ttvPath, Map<String, List<String>> nonUniqueIndexs) {
        HashSet<String> theNonUniqueIndexFields = new HashSet<String>();
        for (List<String> indexs : nonUniqueIndexs.values()) {
            theNonUniqueIndexFields.addAll(indexs);
        }
        return theNonUniqueIndexFields.containsAll(ttvPath);
    }

    private String getSpecNameFromIndexName(String indexName) {
        return indexName.split(IdDAO.assetKeyTableUniqueIndexName)[1];
    }

    private Set<String> getNonExistingUniqueIndexs(Set<String> allUniqueIndexesName, List<String> allSpecNames) {
        HashSet<String> nonExistedUniqueIndexes = new HashSet<String>();
        for (String indexName : allUniqueIndexesName) {
            if (allSpecNames.contains(this.getSpecNameFromIndexName(indexName))) continue;
            nonExistedUniqueIndexes.add(indexName);
        }
        return nonExistedUniqueIndexes;
    }

    private Collection<String> getSpecTTVPaths(ISpecHandler handler) {
        return handler.getIdentifier().getTTVPaths().values();
    }

    private AssetsManager getAssetsManager() {
        return AssetsManager.getThreadLocalInstance();
    }

    private IPMMUIService getPMMUIService() {
        return (IPMMUIService)ServiceRegistry.getDefault().lookup(IPMMUIService.class);
    }

    private ITitleActionSource getTitleActionSource() {
        return new TitleActionSource(COMPONENT_NAME, ENTITY_NAME, this.getUserName());
    }

    private String getUserName() {
        return NeptuneAuthorizationManager.getAuthorizationService().getUserName();
    }

    private static final /* synthetic */ UITitle createTitle_aroundBody0(TitleViewService ajc$this, UITitle title, String meRequestKey) {
        SaveResult result;
        block9: {
            NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Create"});
            Title titleToSave = ajc$this.buildTitle(title);
            result = null;
            try {
                result = ajc$this.getPMMUIService().createTitle(titleToSave, COMPONENT_NAME, ENTITY_NAME, ajc$this.getUserName(), meRequestKey);
            }
            catch (TitleValidationException e) {
                if (e instanceof FatalTitleValidationException) {
                    String error = "Failed to create the title because of fatal validation errors.";
                    logger.error((Object)error, (Throwable)e);
                }
                String message = "Failed to create the title because of validation errors.";
                ajc$this.throwUIValidationException(e, message);
                if (meRequestKey != null) {
                    ajc$this.meManager.deleteRequest(meRequestKey);
                }
                break block9;
            }
            catch (RuntimeException e) {
                try {
                    logger.error((Object)"Failed to create title.", (Throwable)e);
                    throw ajc$this.exceptionHandler.handleException(e);
                }
                catch (Throwable throwable) {
                    if (meRequestKey != null) {
                        ajc$this.meManager.deleteRequest(meRequestKey);
                    }
                    throw throwable;
                }
            }
            if (meRequestKey == null) break block9;
            ajc$this.meManager.deleteRequest(meRequestKey);
        }
        return ajc$this.buildUITitleWithMetadata(result.getTitle(), result.getValidationMessages());
    }

    private static final /* synthetic */ Object createTitle_aroundBody1$advice(TitleViewService ajc$this, UITitle title, String meRequestKey, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.createTitle_aroundBody0(ajc$this, title, meRequestKey);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitle object = TitleViewService.createTitle_aroundBody0(ajc$this, title, meRequestKey);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitle createTitleAsDraft_aroundBody2(TitleViewService ajc$this, UITitle title) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Create"});
        Title titleToSave = ajc$this.buildTitle(title);
        Title savedTitle = null;
        try {
            savedTitle = ajc$this.getPMMUIService().createTitleAsDraft(titleToSave, COMPONENT_NAME, ENTITY_NAME, ajc$this.getUserName());
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                String error = "Failed to create title as draft because of fatal validation errors.";
                logger.error((Object)error, (Throwable)e);
            }
            String message = "Failed to create title as draft because of validation errors.";
            ajc$this.throwUIValidationException(e, message);
        }
        catch (RuntimeException e) {
            logger.error((Object)"Failed to create title as draft.", (Throwable)e);
            throw ajc$this.exceptionHandler.handleException(e);
        }
        return ajc$this.buildUITitleWithMetadata(savedTitle, null);
    }

    private static final /* synthetic */ Object createTitleAsDraft_aroundBody3$advice(TitleViewService ajc$this, UITitle title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.createTitleAsDraft_aroundBody2(ajc$this, title);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitle object = TitleViewService.createTitleAsDraft_aroundBody2(ajc$this, title);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitle updateTitleMetadata_aroundBody4(TitleViewService ajc$this, UITitle title, Long requestKey, String action, String listOfAssetIds, String meRequestKey) {
        SaveResult result;
        block10: {
            NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"});
            Title titleToSave = ajc$this.buildTitle(title);
            result = null;
            try {
                result = ajc$this.getPMMUIService().updateTitleMetadata(titleToSave, requestKey, action, listOfAssetIds, COMPONENT_NAME, ENTITY_NAME, ajc$this.getUserName(), meRequestKey);
            }
            catch (TitleValidationException e) {
                if (e instanceof FatalTitleValidationException) {
                    String error = "Failed to update title because of fatal validation errors.";
                    logger.error((Object)error, (Throwable)e);
                }
                String message = "Failed to update title because of validation errors.";
                ajc$this.throwUIValidationException(e, message);
                if (meRequestKey != null) {
                    ajc$this.meManager.deleteRequest(meRequestKey);
                }
                break block10;
            }
            catch (RuntimeException e) {
                try {
                    logger.error((Object)("Failed to update title[" + title.getId() + "]."), (Throwable)e);
                    throw ajc$this.exceptionHandler.handleException(e);
                }
                catch (Throwable throwable) {
                    if (meRequestKey != null) {
                        ajc$this.meManager.deleteRequest(meRequestKey);
                    }
                    throw throwable;
                }
            }
            if (meRequestKey == null) break block10;
            ajc$this.meManager.deleteRequest(meRequestKey);
        }
        UITitle uiTitle = ajc$this.buildUITitleWithMetadata(result.getTitle(), result.getValidationMessages());
        Map actionMap = result.getActionResponseMap();
        if (actionMap != null) {
            String message = "The following asset(s) (" + (String)actionMap.get("unmappedAssets") + ") do not have original files. " + "Manual task will not be closed until original files are specified.";
            ajc$this.buildActionResultMessages(message, uiTitle.getMetadata().getValidationMessages());
        }
        return uiTitle;
    }

    private static final /* synthetic */ Object updateTitleMetadata_aroundBody5$advice(TitleViewService ajc$this, UITitle title, Long requestKey, String action, String listOfAssetIds, String meRequestKey, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.updateTitleMetadata_aroundBody4(ajc$this, title, requestKey, action, listOfAssetIds, meRequestKey);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitle object = TitleViewService.updateTitleMetadata_aroundBody4(ajc$this, title, requestKey, action, listOfAssetIds, meRequestKey);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitle updateTitleMetadataAsDraft_aroundBody6(TitleViewService ajc$this, UITitle title) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"});
        Title titleToSave = ajc$this.buildTitle(title);
        Title savedTitle = null;
        try {
            savedTitle = ajc$this.getPMMUIService().updateTitleMetadataAsDraft(titleToSave, COMPONENT_NAME, ENTITY_NAME, ajc$this.getUserName());
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                String error = "Failed to update title as draft because of fatal validation errors.";
                logger.error((Object)error, (Throwable)e);
            }
            String message = "Failed to update title as draft because of validation errors.";
            ajc$this.throwUIValidationException(e, message);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to update title[" + title.getId() + "] as draft."), (Throwable)e);
            throw ajc$this.exceptionHandler.handleException(e);
        }
        return ajc$this.buildUITitleWithMetadata(savedTitle, null);
    }

    private static final /* synthetic */ Object updateTitleMetadataAsDraft_aroundBody7$advice(TitleViewService ajc$this, UITitle title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.updateTitleMetadataAsDraft_aroundBody6(ajc$this, title);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitle object = TitleViewService.updateTitleMetadataAsDraft_aroundBody6(ajc$this, title);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void batchUpdateTitleMetadata_aroundBody8(TitleViewService ajc$this, UITitle updates, List titleIds, boolean draft, boolean currentState) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"});
        Title updatesToSave = ajc$this.buildTitle(updates);
        updatesToSave.setStatus(draft ? TitleStatus.DRAFT : TitleStatus.COMMITTED);
        try {
            ajc$this.getPMMUIService().batchUpdateTitleMetadata(updatesToSave, titleIds, currentState, COMPONENT_NAME, ENTITY_NAME, ajc$this.getUserName());
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                String error = "Failed to update titles as draft because of fatal validation errors.";
                logger.error((Object)error, (Throwable)e);
            }
            String message = "Failed to update titles as draft because of validation errors.";
            ajc$this.throwUIValidationException(e, message);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to update title[" + updates.getId() + "] as draft."), (Throwable)e);
            throw ajc$this.exceptionHandler.handleException(e);
        }
    }

    private static final /* synthetic */ Object batchUpdateTitleMetadata_aroundBody9$advice(TitleViewService ajc$this, UITitle updates, List titleIds, boolean draft, boolean currentState, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleViewService.batchUpdateTitleMetadata_aroundBody8(ajc$this, updates, titleIds, draft, currentState);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleViewService.batchUpdateTitleMetadata_aroundBody8(ajc$this, updates, titleIds, draft, currentState);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitle getTitle_aroundBody10(TitleViewService ajc$this, Long titleId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        if (titleId == null) {
            return null;
        }
        Title title = null;
        try {
            title = ajc$this.titleManagerService.get(titleId);
            ajc$this.validateActiveTitle(title);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to read title[" + titleId + "] from the server."), (Throwable)e);
            throw ajc$this.exceptionHandler.handleException(e);
        }
        UITitle uiTitle = ajc$this.buildUITitleWithMetadata(title, null);
        return uiTitle;
    }

    private static final /* synthetic */ Object getTitle_aroundBody11$advice(TitleViewService ajc$this, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.getTitle_aroundBody10(ajc$this, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitle object = TitleViewService.getTitle_aroundBody10(ajc$this, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitle getTitleHistory_aroundBody12(TitleViewService ajc$this, Long titleId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        Title title = null;
        boolean isSeriesTitle = false;
        try {
            title = ajc$this.titleManagerService.get(titleId);
            isSeriesTitle = title.getContentClassId().longValue() == ajc$this.contentClassService.getSeriesContentClassId().longValue();
            ajc$this.validateActiveTitle(title);
        }
        catch (ContentClassPersistenceException ex) {
            logger.error((Object)("Failed to read title[" + titleId + "] from the server."), (Throwable)ex);
            throw ajc$this.exceptionHandler.handleException(ex);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to read title[" + titleId + "] from the server."), (Throwable)e);
            throw ajc$this.exceptionHandler.handleException(e);
        }
        return ajc$this.buildUITitleWithHistory(title, isSeriesTitle);
    }

    private static final /* synthetic */ Object getTitleHistory_aroundBody13$advice(TitleViewService ajc$this, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.getTitleHistory_aroundBody12(ajc$this, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitle object = TitleViewService.getTitleHistory_aroundBody12(ajc$this, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitleInfo getTitleRevisionInfo_aroundBody14(TitleViewService ajc$this, Long titleId, String titleRevision) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        Title title = null;
        try {
            title = ajc$this.titleManagerService.get(titleId, titleRevision);
            ajc$this.validateActiveTitle(title);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to read versioned title[" + titleId + ", " + titleRevision + "] from the server."), (Throwable)e);
            throw ajc$this.exceptionHandler.handleException(e);
        }
        if (title == null) {
            throw new NeptuneException("Invalid title id: " + titleId);
        }
        Group rootAsset = (Group)title.getAsset();
        int rev = Integer.parseInt(titleRevision);
        RootAssetRevision revDetail = rootAsset.getRevision(rev);
        boolean isDraft = revDetail.isDraft();
        UITitleInfo info = new UITitleInfo();
        UIRevisionInfo revInfo = new UIRevisionInfo(rev, isDraft);
        info.setRevisionInfo(revInfo);
        UITitle uiTitle = new UITitle();
        uiTitle.setId(titleId);
        uiTitle.setMetadata(ajc$this.buildMetadata(title));
        info.setTitle(uiTitle);
        ContentClassViewService ccService = new ContentClassViewService();
        UIAssetSpecification spec = ccService.getContentClassSpec(title.getContentClassId(), title.getPartnerId());
        info.setSpecification(spec);
        return info;
    }

    private static final /* synthetic */ Object getTitleRevisionInfo_aroundBody15$advice(TitleViewService ajc$this, Long titleId, String titleRevision, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.getTitleRevisionInfo_aroundBody14(ajc$this, titleId, titleRevision);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitleInfo object = TitleViewService.getTitleRevisionInfo_aroundBody14(ajc$this, titleId, titleRevision);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void rollbackTitle_aroundBody16(TitleViewService ajc$this, Long titleId, String titleRevision) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"});
        try {
            ajc$this.titleManagerService.rollback(titleId, titleRevision, false, ajc$this.getTitleActionSource());
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                ajc$this.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            }
            String message = "Failed to roll back title to revision " + titleRevision + " due to validation errors.";
            ajc$this.throwUIValidationException(e, message);
        }
        catch (RuntimeException e) {
            ajc$this.logRollbackFailure(titleId, titleRevision, e);
            throw ajc$this.exceptionHandler.handleException(e);
        }
    }

    private static final /* synthetic */ Object rollbackTitle_aroundBody17$advice(TitleViewService ajc$this, Long titleId, String titleRevision, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleViewService.rollbackTitle_aroundBody16(ajc$this, titleId, titleRevision);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleViewService.rollbackTitle_aroundBody16(ajc$this, titleId, titleRevision);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void rollbackTitleAsDraft_aroundBody18(TitleViewService ajc$this, Long titleId, String titleRevision) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"});
        try {
            ajc$this.titleManagerService.rollback(titleId, titleRevision, true, ajc$this.getTitleActionSource());
        }
        catch (TitleValidationException e) {
            if (e instanceof FatalTitleValidationException) {
                ajc$this.logRollbackFailure(titleId, titleRevision, (Exception)((Object)e));
            }
            String message = "Failed to roll back title to revision " + titleRevision + " due to validation errors.";
            ajc$this.throwUIValidationException(e, message);
        }
        catch (RuntimeException e) {
            ajc$this.logRollbackFailure(titleId, titleRevision, e);
            throw ajc$this.exceptionHandler.handleException(e);
        }
    }

    private static final /* synthetic */ Object rollbackTitleAsDraft_aroundBody19$advice(TitleViewService ajc$this, Long titleId, String titleRevision, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleViewService.rollbackTitleAsDraft_aroundBody18(ajc$this, titleId, titleRevision);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleViewService.rollbackTitleAsDraft_aroundBody18(ajc$this, titleId, titleRevision);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitleCompareData compareTitles_aroundBody20(TitleViewService ajc$this, TitleCompareRequest request) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        Title title1 = ajc$this.getTitle(request.title1);
        Title title2 = ajc$this.getTitle(request.title2);
        ITitleCompareReport report = ajc$this.titleCompareService.compareTitles(title1, title2);
        UITitleCompareDataBuilder builder = new UITitleCompareDataBuilder(request.specName, request.specificationType);
        return builder.build(report);
    }

    private static final /* synthetic */ Object compareTitles_aroundBody21$advice(TitleViewService ajc$this, TitleCompareRequest request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.compareTitles_aroundBody20(ajc$this, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitleCompareData object = TitleViewService.compareTitles_aroundBody20(ajc$this, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitleCompareXmlData compareTitlePreviews_aroundBody22(TitleViewService ajc$this, UIActionTitle uiTitle1, UIActionTitle uiTitle2, String specificationName, boolean useHtml) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        Title title1 = ajc$this.getTitle(uiTitle1);
        Title title2 = ajc$this.getTitle(uiTitle2);
        UITitleCompareXmlData preview = new UITitleCompareXmlData();
        preview.preview1URL = ajc$this.previewTitle(title1, specificationName, useHtml);
        preview.preview2URL = ajc$this.previewTitle(title2, specificationName, useHtml);
        return preview;
    }

    private static final /* synthetic */ Object compareTitlePreviews_aroundBody23$advice(TitleViewService ajc$this, UIActionTitle uiTitle1, UIActionTitle uiTitle2, String specificationName, boolean useHtml, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.compareTitlePreviews_aroundBody22(ajc$this, uiTitle1, uiTitle2, specificationName, useHtml);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitleCompareXmlData object = TitleViewService.compareTitlePreviews_aroundBody22(ajc$this, uiTitle1, uiTitle2, specificationName, useHtml);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitleInfo getTitleMetadataInfoForBatch_aroundBody24(TitleViewService ajc$this, Long contentClassId) {
        UITitleInfo info = new UITitleInfo();
        if (contentClassId == null) {
            throw new NeptuneException("Invalid content class id: null");
        }
        ContentClassViewService ccService = new ContentClassViewService();
        UIAssetSpecification spec = ccService.getContentClassSpec(contentClassId);
        info.setSpecification(spec);
        return info;
    }

    private static final /* synthetic */ Object getTitleMetadataInfoForBatch_aroundBody25$advice(TitleViewService ajc$this, Long contentClassId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.getTitleMetadataInfoForBatch_aroundBody24(ajc$this, contentClassId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitleInfo object = TitleViewService.getTitleMetadataInfoForBatch_aroundBody24(ajc$this, contentClassId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitleInfo getTitleMetadataInfo_aroundBody26(TitleViewService ajc$this, Long titleId, Long contentClassId, Long partnerId) {
        ContentClassViewService ccService;
        UIAssetSpecification spec;
        UITitleInfo info = new UITitleInfo();
        if (titleId == null || titleId == 0L) {
            if (contentClassId == null) {
                throw new NeptuneException("Invalid content class id: null");
            }
            if (partnerId == null) {
                throw new NeptuneException("Invalid partner id: null");
            }
        } else {
            UITitle title = ajc$this.getTitle(titleId);
            if (title == null) {
                throw new NeptuneException("Invalid title id: " + titleId);
            }
            info.setTitle(title);
            contentClassId = title.getContentClassId();
            partnerId = title.getPartnerId();
        }
        if ((spec = (ccService = new ContentClassViewService()).getContentClassSpec(contentClassId, partnerId)).getContentClassTypeId() == 2) {
            if (titleId == null || titleId == 0L) {
                info.setCategoryTitleAssociated(false);
            } else {
                CategoryTitleService categoryTitleService = new CategoryTitleService();
                info.setCategoryTitleAssociated(categoryTitleService.isTitleAssociated(titleId));
            }
        }
        info.setSpecification(spec);
        return info;
    }

    private static final /* synthetic */ Object getTitleMetadataInfo_aroundBody27$advice(TitleViewService ajc$this, Long titleId, Long contentClassId, Long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleViewService.getTitleMetadataInfo_aroundBody26(ajc$this, titleId, contentClassId, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitleInfo object = TitleViewService.getTitleMetadataInfo_aroundBody26(ajc$this, titleId, contentClassId, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

