/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.cms.portal.content.client.rpc.title.SearchColumnPreference;
import com.tandbergtv.cms.portal.content.client.rpc.title.SearchPreferenceDisplayColumn;
import com.tandbergtv.cms.portal.content.client.rpc.title.UiTitleCriteriaService;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchNotFoundException;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchNameUniqueException;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleSearch;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleSearchBase;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.server.search.UiTitleFilterService;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.ITitleSearchPersistenceService;
import com.tandbergtv.cms.title.search.entities.TitleSearch;
import com.tandbergtv.cms.title.search.entities.TitleSearchResultColumn;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.neptune.realm.persist.UserPreference;
import com.tandbergtv.neptune.userprefmgmt.service.IUserPreferenceManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.title.TitleSearchNotFoundException;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class UiTitleCriteriaServiceImpl
implements UiTitleCriteriaService,
NeptuneRemoteService {
    private static final Logger logger = Logger.getLogger(UiTitleCriteriaServiceImpl.class);
    private UiTitleFilterService titleFilterService = new UiTitleFilterService();
    private ITitleSearchPersistenceService tsps;
    private final String SEARCH_RESULT_SELECTED_COLUMN_PREFERENCE_TYPE = "search.result.selected.column";
    private final String SEARCH_RESULT_SORT_COLUMN_PREFERENCE_TYPE = "search.result.sort.column";
    private final String SEARCH_RESULT_SORT_ORDER_PREFERENCE_TYPE = "search.result.sort.order";
    private final String SERIES_SEARCH_RESULT_SELECTED_COLUMN_PREFERENCE_TYPE = "series.search.result.selected.column";
    private final String SERIES_SEARCH_RESULT_SORT_COLUMN_PREFERENCE_TYPE = "series.search.result.sort.column";
    private final String SERIES_SEARCH_RESULT_SORT_ORDER_PREFERENCE_TYPE = "series.search.result.sort.order";
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;

    public UiTitleCriteriaServiceImpl() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        this.tsps = (ITitleSearchPersistenceService)registry.lookup(ITitleSearchPersistenceService.class);
    }

    public String getRelativePath() {
        return "service/title/uiTitleCriteriaService";
    }

    public Class<?> getServiceImplementation() {
        return UiTitleCriteriaServiceImpl.class;
    }

    private CriteriaMode createCriteriaMode(UiCriteriaMode uiMode) {
        if (UiCriteriaMode.SERIES == uiMode) {
            return CriteriaMode.SERIES;
        }
        return CriteriaMode.MASTER;
    }

    @Override
    @Transactional
    public List<UITitleSearchBase> getTitleSearches(int offset, int count, String userName, UiCriteriaMode uiCriteriaMode) throws NeptuneException {
        int n = offset;
        int n2 = count;
        String string = userName;
        UiCriteriaMode uiCriteriaMode2 = uiCriteriaMode;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = UiTitleCriteriaServiceImpl.class.getDeclaredMethod("getTitleSearches", Integer.TYPE, Integer.TYPE, String.class, UiCriteriaMode.class).getAnnotation(Transactional.class);
        }
        return (List)UiTitleCriteriaServiceImpl.getTitleSearches_aroundBody1$advice(this, n, n2, string, uiCriteriaMode2, transactionEnforcer, (Transactional)annotation, null);
    }

    private boolean hasSelections(TitleSearch ts) {
        return ts.getDisplayCols() != null && ts.getDisplayCols().size() > 0;
    }

    @Override
    @Transactional
    public UITitleSearch getTitleSearch(int titleSearchId) throws NeptuneException {
        int n = titleSearchId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = UiTitleCriteriaServiceImpl.class.getDeclaredMethod("getTitleSearch", Integer.TYPE).getAnnotation(Transactional.class);
        }
        return (UITitleSearch)UiTitleCriteriaServiceImpl.getTitleSearch_aroundBody3$advice(this, n, transactionEnforcer, (Transactional)annotation, null);
    }

    private UiColumn convertToUiCol(TitleSearchResultColumn c) {
        if (c == null) {
            return null;
        }
        UiColumn col = new UiColumn();
        col.setInternalName(c.getName());
        return col;
    }

    private List<UiColumn> convertToUiCols(List<TitleSearchResultColumn> displayCols) {
        ArrayList<UiColumn> cols = new ArrayList<UiColumn>();
        if (displayCols == null) {
            return cols;
        }
        for (TitleSearchResultColumn c : displayCols) {
            UiColumn uiCol = this.convertToUiCol(c);
            if (uiCol == null) continue;
            cols.add(uiCol);
        }
        return cols;
    }

    @Override
    public int saveTitleSearch(UITitleSearch ts) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        this.isUserAuthorized(ts.getUserName());
        try {
            if (ts.getTitleSearchId() != -1) {
                try {
                    return this.updateTitleSearch(ts).getTitleSearchId();
                }
                catch (TitleSearchNotFoundException e) {
                    String msg = "Unable to locate title search with id " + ts.getTitleSearchId() + "Will save title search as a new one.";
                    logger.warn((Object)msg, (Throwable)e);
                }
            }
            return this.saveNewTitleSearch(ts).getTitleSearchId();
        }
        catch (RuntimeException runtimeException) {
            throw new TitleSearchNameUniqueException();
        }
    }

    @Transactional
    private TitleSearch saveNewTitleSearch(UITitleSearch ts) throws NeptuneException {
        UITitleSearch uITitleSearch = ts;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = UiTitleCriteriaServiceImpl.class.getDeclaredMethod("saveNewTitleSearch", UITitleSearch.class).getAnnotation(Transactional.class);
        }
        return (TitleSearch)UiTitleCriteriaServiceImpl.saveNewTitleSearch_aroundBody5$advice(this, uITitleSearch, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<TitleSearchResultColumn> getDisplayColumns(List<UiColumn> displayColumns) {
        ArrayList<TitleSearchResultColumn> cols = new ArrayList<TitleSearchResultColumn>();
        int i = 0;
        while (i < displayColumns.size()) {
            cols.add(this.convertToBackendColumn(displayColumns.get(i), i));
            ++i;
        }
        return cols;
    }

    private TitleSearchResultColumn convertToBackendColumn(UiColumn c, int index) {
        TitleSearchResultColumn rsCol = new TitleSearchResultColumn();
        rsCol.setName(c.getInternalName());
        rsCol.setOrder(index);
        return rsCol;
    }

    @Transactional
    private TitleSearch updateTitleSearch(UITitleSearch ts) throws NeptuneException, TitleSearchNotFoundException {
        UITitleSearch uITitleSearch = ts;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = UiTitleCriteriaServiceImpl.class.getDeclaredMethod("updateTitleSearch", UITitleSearch.class).getAnnotation(Transactional.class);
        }
        return (TitleSearch)UiTitleCriteriaServiceImpl.updateTitleSearch_aroundBody7$advice(this, uITitleSearch, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public void deleteTitleSearch(int titleSearchId) throws NeptuneException {
        int n = titleSearchId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = UiTitleCriteriaServiceImpl.class.getDeclaredMethod("deleteTitleSearch", Integer.TYPE).getAnnotation(Transactional.class);
        }
        UiTitleCriteriaServiceImpl.deleteTitleSearch_aroundBody9$advice(this, n, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public void deleteTitleSearches(Set<Integer> titleSearchIds) throws NeptuneException {
        Set<Integer> set = titleSearchIds;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = UiTitleCriteriaServiceImpl.class.getDeclaredMethod("deleteTitleSearches", Set.class).getAnnotation(Transactional.class);
        }
        UiTitleCriteriaServiceImpl.deleteTitleSearches_aroundBody11$advice(this, set, transactionEnforcer, (Transactional)annotation, null);
    }

    private void isUserAuthorized(String user) throws NeptuneException {
        String currentUser = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        if (currentUser == null || !currentUser.equals(user)) {
            throw new InsufficientRolesException();
        }
    }

    @Override
    @Transactional
    public void saveSearchColumnsAsPreference(SearchColumnPreference searchPreferences, UiCriteriaMode criteriaMode) {
        SearchColumnPreference searchColumnPreference = searchPreferences;
        UiCriteriaMode uiCriteriaMode = criteriaMode;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = UiTitleCriteriaServiceImpl.class.getDeclaredMethod("saveSearchColumnsAsPreference", SearchColumnPreference.class, UiCriteriaMode.class).getAnnotation(Transactional.class);
        }
        UiTitleCriteriaServiceImpl.saveSearchColumnsAsPreference_aroundBody13$advice(this, searchColumnPreference, uiCriteriaMode, transactionEnforcer, (Transactional)annotation, null);
    }

    private void addSelectedColumnPreferences(String currentUser, List<SearchPreferenceDisplayColumn> selectedColumns, List<UserPreference> preferences, UiCriteriaMode criteriaMode) {
        int i = 0;
        while (i < selectedColumns.size()) {
            UserPreference preference = new UserPreference();
            preference.setUserName(currentUser);
            preference.setComponent("Content Management");
            if (criteriaMode == UiCriteriaMode.EPISODE) {
                preference.setType("search.result.selected.column");
            } else if (criteriaMode == UiCriteriaMode.SERIES) {
                preference.setType("series.search.result.selected.column");
            }
            preference.setKey(selectedColumns.get(i).getName());
            preference.setValue(String.valueOf(i));
            preferences.add(preference);
            ++i;
        }
    }

    private void addSortColumnPreferences(String currentUser, SearchPreferenceDisplayColumn sortColumn, int sortOrder, List<UserPreference> preferences, UiCriteriaMode criteriaMode) {
        UserPreference sortPreference = new UserPreference();
        sortPreference.setUserName(currentUser);
        sortPreference.setComponent("Content Management");
        if (criteriaMode == UiCriteriaMode.EPISODE) {
            sortPreference.setType("search.result.sort.column");
        } else if (criteriaMode == UiCriteriaMode.SERIES) {
            sortPreference.setType("series.search.result.sort.column");
        }
        sortPreference.setKey(sortColumn.getName());
        sortPreference.setValue(sortColumn.getName());
        preferences.add(sortPreference);
        UserPreference sortOrderPreference = new UserPreference();
        sortOrderPreference.setUserName(currentUser);
        sortOrderPreference.setComponent("Content Management");
        if (criteriaMode == UiCriteriaMode.EPISODE) {
            sortOrderPreference.setType("search.result.sort.order");
            sortOrderPreference.setKey("search.result.sort.order");
        } else if (criteriaMode == UiCriteriaMode.SERIES) {
            sortOrderPreference.setType("series.search.result.sort.order");
            sortOrderPreference.setKey("series.search.result.sort.order");
        }
        sortOrderPreference.setValue(String.valueOf(sortOrder));
        preferences.add(sortOrderPreference);
    }

    @Override
    @Transactional
    public SearchColumnPreference getSearchColumnPreferences(UiCriteriaMode criteriaMode) {
        UiCriteriaMode uiCriteriaMode = criteriaMode;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = UiTitleCriteriaServiceImpl.class.getDeclaredMethod("getSearchColumnPreferences", UiCriteriaMode.class).getAnnotation(Transactional.class);
        }
        return (SearchColumnPreference)UiTitleCriteriaServiceImpl.getSearchColumnPreferences_aroundBody15$advice(this, uiCriteriaMode, transactionEnforcer, (Transactional)annotation, null);
    }

    private static final /* synthetic */ List getTitleSearches_aroundBody0(UiTitleCriteriaServiceImpl ajc$this, int offset, int count, String userName, UiCriteriaMode uiCriteriaMode) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        CriteriaMode criteriaMode = ajc$this.createCriteriaMode(uiCriteriaMode);
        List titleFilters = ajc$this.tsps.getTitleSearchByUserName(userName, true, criteriaMode, offset, count);
        ArrayList<UITitleSearchBase> resultFilters = new ArrayList<UITitleSearchBase>();
        for (TitleSearch ts : titleFilters) {
            UITitleSearchBase uiTitleSearch = ajc$this.hasSelections(ts) ? new UITitleSearchBase(ts.getTitleSearchId().intValue(), ts.getName(), ts.getUserName(), ts.getShared().booleanValue(), ajc$this.convertToUiCols(ts.getDisplayCols())) : new UITitleSearchBase(ts.getTitleSearchId().intValue(), ts.getName(), ts.getUserName(), ts.getShared().booleanValue());
            resultFilters.add(uiTitleSearch);
        }
        return resultFilters;
    }

    private static final /* synthetic */ Object getTitleSearches_aroundBody1$advice(UiTitleCriteriaServiceImpl ajc$this, int offset, int count, String userName, UiCriteriaMode uiCriteriaMode, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiTitleCriteriaServiceImpl.getTitleSearches_aroundBody0(ajc$this, offset, count, userName, uiCriteriaMode);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UiTitleCriteriaServiceImpl.getTitleSearches_aroundBody0(ajc$this, offset, count, userName, uiCriteriaMode);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitleSearch getTitleSearch_aroundBody2(UiTitleCriteriaServiceImpl ajc$this, int titleSearchId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        try {
            TitleSearch ts = ajc$this.tsps.getTitleSearch((Serializable)Integer.valueOf(titleSearchId));
            UITitleFilter filter = ajc$this.titleFilterService.convertTitleFilter(ts.getFilter());
            UITitleSearch result = ajc$this.hasSelections(ts) ? new UITitleSearch(ts.getTitleSearchId().intValue(), ts.getUserName(), ts.getName(), filter, ts.getShared().booleanValue(), ajc$this.convertToUiCols(ts.getDisplayCols())) : new UITitleSearch(ts.getTitleSearchId().intValue(), ts.getUserName(), ts.getName(), filter, ts.getShared().booleanValue());
            return result;
        }
        catch (TitleSearchNotFoundException e) {
            logger.warn((Object)("Unable to locate title search with id " + titleSearchId), (Throwable)e);
            throw new SearchNotFoundException("Search not found.");
        }
    }

    private static final /* synthetic */ Object getTitleSearch_aroundBody3$advice(UiTitleCriteriaServiceImpl ajc$this, int titleSearchId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiTitleCriteriaServiceImpl.getTitleSearch_aroundBody2(ajc$this, titleSearchId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitleSearch object = UiTitleCriteriaServiceImpl.getTitleSearch_aroundBody2(ajc$this, titleSearchId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleSearch saveNewTitleSearch_aroundBody4(UiTitleCriteriaServiceImpl ajc$this, UITitleSearch ts) {
        TitleFilter tf = new TitleFilter();
        ajc$this.titleFilterService.convertTitleFilter(tf, ts.getTitleFilter());
        TitleSearch titleSearch = new TitleSearch(ts.getName(), ts.getUserName(), Boolean.valueOf(ts.isShare()), tf, ajc$this.getDisplayColumns(ts.getDisplayColumns()));
        for (TitleSearchResultColumn c : titleSearch.getDisplayCols()) {
            c.setTs(titleSearch);
        }
        ajc$this.tsps.saveTitleSearch(titleSearch);
        return titleSearch;
    }

    private static final /* synthetic */ Object saveNewTitleSearch_aroundBody5$advice(UiTitleCriteriaServiceImpl ajc$this, UITitleSearch ts, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiTitleCriteriaServiceImpl.saveNewTitleSearch_aroundBody4(ajc$this, ts);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleSearch object = UiTitleCriteriaServiceImpl.saveNewTitleSearch_aroundBody4(ajc$this, ts);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleSearch updateTitleSearch_aroundBody6(UiTitleCriteriaServiceImpl ajc$this, UITitleSearch ts) {
        TitleSearch result = ajc$this.tsps.getTitleSearch((Serializable)Integer.valueOf(ts.getTitleSearchId()));
        HibernateContext.getContext().getCurrentSession().evict((Object)result);
        if (result.getDisplayCols().size() > 0) {
            for (TitleSearchResultColumn c : result.getDisplayCols()) {
                HibernateContext.getContext().getCurrentSession().delete((Object)c);
            }
        }
        HibernateContext.getContext().getCurrentSession().flush();
        result.setName(ts.getName());
        result.setUserName(ts.getUserName());
        result.setShared(Boolean.valueOf(ts.isShare()));
        result.getFilter().setCountIncluded(ts.getTitleFilter().isCountIncluded());
        result.getDisplayCols().clear();
        ArrayList<TitleSearchResultColumn> displayCols = new ArrayList<TitleSearchResultColumn>();
        int i = 0;
        while (i < ts.getDisplayColumns().size()) {
            TitleSearchResultColumn col = ajc$this.convertToBackendColumn((UiColumn)ts.getDisplayColumns().get(i), i);
            col.setTs(result);
            displayCols.add(col);
            ++i;
        }
        result.setDisplayCols(displayCols);
        ajc$this.titleFilterService.convertTitleFilter(result.getFilter(), ts.getTitleFilter());
        ajc$this.tsps.saveTitleSearch(result);
        return result;
    }

    private static final /* synthetic */ Object updateTitleSearch_aroundBody7$advice(UiTitleCriteriaServiceImpl ajc$this, UITitleSearch ts, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiTitleCriteriaServiceImpl.updateTitleSearch_aroundBody6(ajc$this, ts);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleSearch object = UiTitleCriteriaServiceImpl.updateTitleSearch_aroundBody6(ajc$this, ts);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteTitleSearch_aroundBody8(UiTitleCriteriaServiceImpl ajc$this, int titleSearchId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        try {
            TitleSearch ts = ajc$this.tsps.getTitleSearch((Serializable)Integer.valueOf(titleSearchId));
            ajc$this.isUserAuthorized(ts.getUserName());
            ajc$this.tsps.deleteTitleSearch((Serializable)Integer.valueOf(titleSearchId));
        }
        catch (TitleSearchNotFoundException titleSearchNotFoundException) {}
    }

    private static final /* synthetic */ Object deleteTitleSearch_aroundBody9$advice(UiTitleCriteriaServiceImpl ajc$this, int titleSearchId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            UiTitleCriteriaServiceImpl.deleteTitleSearch_aroundBody8(ajc$this, titleSearchId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiTitleCriteriaServiceImpl.deleteTitleSearch_aroundBody8(ajc$this, titleSearchId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteTitleSearches_aroundBody10(UiTitleCriteriaServiceImpl ajc$this, Set titleSearchIds) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        for (Integer titleSearchId : titleSearchIds) {
            try {
                TitleSearch ts = ajc$this.tsps.getTitleSearch((Serializable)titleSearchId);
                ajc$this.isUserAuthorized(ts.getUserName());
            }
            catch (TitleSearchNotFoundException titleSearchNotFoundException) {}
        }
        ajc$this.tsps.deleteTitleSearches(titleSearchIds);
    }

    private static final /* synthetic */ Object deleteTitleSearches_aroundBody11$advice(UiTitleCriteriaServiceImpl ajc$this, Set titleSearchIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            UiTitleCriteriaServiceImpl.deleteTitleSearches_aroundBody10(ajc$this, titleSearchIds);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiTitleCriteriaServiceImpl.deleteTitleSearches_aroundBody10(ajc$this, titleSearchIds);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveSearchColumnsAsPreference_aroundBody12(UiTitleCriteriaServiceImpl ajc$this, SearchColumnPreference searchPreferences, UiCriteriaMode criteriaMode) {
        String currentUser = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        IUserPreferenceManager userPreferenceManager = (IUserPreferenceManager)InjectionUtil.injectInstance((String)"cms/UserPreferenceManager/local", IUserPreferenceManager.class);
        ArrayList<UserPreference> preferences = new ArrayList<UserPreference>();
        ajc$this.addSelectedColumnPreferences(currentUser, searchPreferences.getSelectedColumns(), preferences, criteriaMode);
        ajc$this.addSortColumnPreferences(currentUser, searchPreferences.getSortColumn(), searchPreferences.getSortOrder(), preferences, criteriaMode);
        if (criteriaMode == UiCriteriaMode.EPISODE) {
            userPreferenceManager.deletePreferences("Content Management", "search.result.selected.column");
            userPreferenceManager.deletePreferences("Content Management", "search.result.sort.column");
            userPreferenceManager.deletePreferences("Content Management", "search.result.sort.order");
        } else if (criteriaMode == UiCriteriaMode.SERIES) {
            userPreferenceManager.deletePreferences("Content Management", "series.search.result.selected.column");
            userPreferenceManager.deletePreferences("Content Management", "series.search.result.sort.column");
            userPreferenceManager.deletePreferences("Content Management", "series.search.result.sort.order");
        }
        userPreferenceManager.create(preferences);
    }

    private static final /* synthetic */ Object saveSearchColumnsAsPreference_aroundBody13$advice(UiTitleCriteriaServiceImpl ajc$this, SearchColumnPreference searchPreferences, UiCriteriaMode criteriaMode, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            UiTitleCriteriaServiceImpl.saveSearchColumnsAsPreference_aroundBody12(ajc$this, searchPreferences, criteriaMode);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiTitleCriteriaServiceImpl.saveSearchColumnsAsPreference_aroundBody12(ajc$this, searchPreferences, criteriaMode);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ SearchColumnPreference getSearchColumnPreferences_aroundBody14(UiTitleCriteriaServiceImpl ajc$this, UiCriteriaMode criteriaMode) {
        IUserPreferenceManager userPreferenceManager = (IUserPreferenceManager)InjectionUtil.injectInstance((String)"cms/UserPreferenceManager/local", IUserPreferenceManager.class);
        String selectedColumn = criteriaMode == UiCriteriaMode.EPISODE ? "search.result.selected.column" : "series.search.result.selected.column";
        String selectedSortColumn = criteriaMode == UiCriteriaMode.EPISODE ? "search.result.sort.column" : "series.search.result.sort.column";
        String selectedSortOrder = criteriaMode == UiCriteriaMode.EPISODE ? "search.result.sort.order" : "series.search.result.sort.order";
        List selectedColumnPrefs = userPreferenceManager.getPreferences("Content Management", selectedColumn);
        List sortColumnPrefs = userPreferenceManager.getPreferences("Content Management", selectedSortColumn);
        List sortOrderColumnPrefs = userPreferenceManager.getPreferences("Content Management", selectedSortOrder);
        ArrayList<SearchPreferenceDisplayColumn> selectedColumns = new ArrayList<SearchPreferenceDisplayColumn>();
        int i = 0;
        while (i < selectedColumnPrefs.size()) {
            selectedColumns.add(new SearchPreferenceDisplayColumn());
            ++i;
        }
        for (UserPreference pref : selectedColumnPrefs) {
            int position = Integer.parseInt(pref.getValue());
            selectedColumns.set(position, new SearchPreferenceDisplayColumn(pref.getKey()));
        }
        SearchPreferenceDisplayColumn sortColumn = null;
        if (sortColumnPrefs != null && sortColumnPrefs.size() == 1) {
            sortColumn = new SearchPreferenceDisplayColumn(((UserPreference)sortColumnPrefs.get(0)).getKey());
        }
        int sortOrder = 0;
        if (sortOrderColumnPrefs != null && sortOrderColumnPrefs.size() == 1) {
            sortOrder = Integer.parseInt(((UserPreference)sortOrderColumnPrefs.get(0)).getValue());
        }
        return new SearchColumnPreference(selectedColumns, sortColumn, sortOrder);
    }

    private static final /* synthetic */ Object getSearchColumnPreferences_aroundBody15$advice(UiTitleCriteriaServiceImpl ajc$this, UiCriteriaMode criteriaMode, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiTitleCriteriaServiceImpl.getSearchColumnPreferences_aroundBody14(ajc$this, criteriaMode);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SearchColumnPreference object = UiTitleCriteriaServiceImpl.getSearchColumnPreferences_aroundBody14(ajc$this, criteriaMode);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

