/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.tandbergtv.cms.portal.content.client.title.model.UIStillImage;
import com.tandbergtv.cms.portal.content.client.title.model.UIVideoPlayer;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerService;
import com.tandbergtv.cms.portal.content.server.infoprovider.PreferenceProvider;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.server.dispatcher.NeptuneRemoteServiceDispatcher;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.io.FileInputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VideoPlayerService
implements IVideoPlayerService,
NeptuneRemoteService {
    private String TEMPLATE_NAME = "_template";
    private String MESSAGE_UID = "CM0104";
    private String COMMAND_NAME = "create";
    private static final String KEYFRAMES_PROPERTY_FILE = "keyframes.properties";
    private static final String SEEK_TO_POSITION_PROPERTY = "SEEK_TO_POSITION";
    private Logger logger = Logger.getLogger(VideoPlayerService.class);
    private static /* synthetic */ Annotation ajc$anno$0;

    @Override
    public UIVideoPlayer getSettings() throws NeptuneException {
        PreferenceProvider parmsConfFile;
        Map<String, String> defParms;
        UIVideoPlayer settings = new UIVideoPlayer();
        LinkedHashMap<String, String> basicVars = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> flashVars = new LinkedHashMap<String, String>();
        HttpServletRequest req = NeptuneRemoteServiceDispatcher.getRequest();
        if (req != null) {
            NeptunePrincipal nsp;
            HttpSession session = req.getSession();
            if (session != null && (nsp = (NeptunePrincipal)session.getAttribute("neptune_sso_oauth2_principal")) != null) {
                basicVars.put("access_token", nsp.getToken());
                this.logger.info((Object)(">>>>Access Token = " + nsp.getToken()));
            }
        } else {
            this.logger.warn((Object)">>>> req is null");
        }
        if ((defParms = (parmsConfFile = new PreferenceProvider()).getVideoPlayerParams()) != null) {
            Object[] keys = defParms.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                String key = (String)keys[i];
                String value = defParms.get(key);
                if (value != null) {
                    if (key.startsWith("flash_")) {
                        flashVars.put(key.substring(6).trim(), value.trim());
                    } else if (key.startsWith("param_")) {
                        flashVars.put(key.substring(6).trim(), value.trim());
                    } else {
                        basicVars.put(key.trim(), value.trim());
                    }
                }
                ++i;
            }
        }
        settings.setBasicVars(basicVars);
        settings.setFlashVars(flashVars);
        return settings;
    }

    @Override
    public void createImageFromVideoFile(Long assetId, Long titleId, String providerId, String fileURI, String timePosition) throws NeptuneException {
        HashMap<String, String> allVariables = new HashMap<String, String>();
        allVariables.put("assetId", assetId.toString());
        allVariables.put("titleId", titleId.toString());
        allVariables.put("providerId", providerId);
        allVariables.put("videoFilePath", fileURI);
        allVariables.put("position", timePosition);
        allVariables.put("numOfFramesPerSec", "");
        allVariables.put("numOfFrames", "");
        allVariables.put("videoDuration", "");
        allVariables.put("imageSize", "");
        allVariables.put("imageFilePath", "");
        String templateName = "Generate SnapShot Image";
        this.logger.debug((Object)("In createImageFromVideoFile() : variables = " + ((Object)allVariables).toString()));
        WorkflowMessage wMsg = this.createWorkFlowMessage(templateName, allVariables);
        this.logger.debug((Object)("WorkflowMessage created successfully : " + wMsg.toString()));
        SoapRouter router = new SoapRouter();
        try {
            IMessage msg = this.convert(wMsg);
            router.send(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Transactional
    public List<UIStillImage> getStillImageURIs(Long assetId, Long titleId) throws NeptuneException {
        Long l = assetId;
        Long l2 = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = VideoPlayerService.class.getDeclaredMethod("getStillImageURIs", Long.class, Long.class).getAnnotation(Transactional.class);
        }
        return (List)VideoPlayerService.getStillImageURIs_aroundBody1$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    private String getPositionFromPropertyFile(String imageURI) {
        String timelinePosition = "";
        int lastIndexOfFileSeparator = imageURI.lastIndexOf("/");
        if (lastIndexOfFileSeparator < 0) {
            lastIndexOfFileSeparator = imageURI.lastIndexOf("\\");
        }
        String imageFileFolder = imageURI.substring(0, lastIndexOfFileSeparator + 1);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(String.valueOf(imageFileFolder) + KEYFRAMES_PROPERTY_FILE));
            timelinePosition = properties.getProperty(SEEK_TO_POSITION_PROPERTY).trim();
        }
        catch (Exception e) {
            this.logger.warn((Object)("Error getting SEEK_TO_POSITION_PROPERTY: " + e.getMessage()));
        }
        return timelinePosition;
    }

    private ITitleAssetResourceManager getService() {
        return (ITitleAssetResourceManager)ServiceRegistry.getDefault().lookup(ITitleAssetResourceManager.class);
    }

    private IMessage convert(WorkflowMessage message) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(message);
        StringPayload payload = new StringPayload(XMLDocumentUtility.convertToString((Node)document));
        return new MessageImpl((IPayload)payload, message.getAttachment());
    }

    private WorkflowMessage createWorkFlowMessage(String templateName, Map<String, String> variables) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)this.MESSAGE_UID);
        WPCLCommand command = new WPCLCommand(this.COMMAND_NAME);
        command.addParameter(this.TEMPLATE_NAME, templateName);
        message.setCommand(command);
        WorkflowPayload payload = message.getPayload();
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            payload.putValue(variable.getKey(), variable.getValue());
        }
        return message;
    }

    public String getRelativePath() {
        return "service/content/title/IVideoPlayerService";
    }

    public Class<? extends VideoPlayerService> getServiceImplementation() {
        return this.getClass();
    }

    private static final /* synthetic */ List getStillImageURIs_aroundBody0(VideoPlayerService ajc$this, Long assetId, Long titleId) {
        ajc$this.logger.debug((Object)("In getSnapshotImageURIs() : assetId=" + assetId + "  titleId=" + titleId));
        ArrayList<UIStillImage> imageInfos = new ArrayList<UIStillImage>();
        ITitleAssetResourceManager titleAssetResManager = ajc$this.getService();
        List assetResources = titleAssetResManager.getStillImages(titleId.longValue(), assetId.longValue());
        for (TitleAssetResource assetResource : assetResources) {
            UIStillImage imageInfo = new UIStillImage();
            String imageURI = assetResource.getResourcePath();
            imageInfo.setImageURI(imageURI);
            imageInfo.setTimelinePosition(ajc$this.getPositionFromPropertyFile(imageURI));
            imageInfos.add(imageInfo);
            ajc$this.logger.debug((Object)("In getSnapshotImageURIs() : stillImage: " + imageInfo.toString()));
        }
        return imageInfos;
    }

    private static final /* synthetic */ Object getStillImageURIs_aroundBody1$advice(VideoPlayerService ajc$this, Long assetId, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return VideoPlayerService.getStillImageURIs_aroundBody0(ajc$this, assetId, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = VideoPlayerService.getStillImageURIs_aroundBody0(ajc$this, assetId, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

