/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.create;

import com.tandbergtv.cms.portal.content.client.create.model.ContentCreateData;
import com.tandbergtv.cms.portal.content.client.create.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.create.model.UISourcePartner;
import com.tandbergtv.cms.portal.content.client.create.service.IContentCreateViewService;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassPartnerList;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ContentCreateViewService
implements IContentCreateViewService,
NeptuneRemoteService {
    private final IContentClassService contentClassService = ServiceLocator.getService("ContentClassService", IContentClassService.class);

    @Override
    public ContentCreateData getContentCreateData() throws NeptuneException {
        ContentCreateData data = new ContentCreateData();
        try {
            String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
            Map map = this.contentClassService.getContentClassPartnerMap(userName);
            this.addContentCreateData(data, map);
        }
        catch (Exception exception) {
            throw new NeptuneException("Unable to get a list of content classes");
        }
        data.sort();
        return data;
    }

    @Override
    public ContentCreateData getCategoryContentCreateData() throws NeptuneException {
        ContentCreateData data = new ContentCreateData();
        try {
            String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
            Map map = this.contentClassService.getCategoryContentClassPartnerMap(userName);
            this.addContentCreateData(data, map);
        }
        catch (Exception exception) {
            throw new NeptuneException("Unable to get a list of content classes");
        }
        data.sort();
        return data;
    }

    private void addContentCreateData(ContentCreateData data, Map<Long, ContentClassPartnerList> map) {
        if (map != null) {
            Collection<ContentClassPartnerList> partners = map.values();
            for (ContentClassPartnerList partner : partners) {
                UISourcePartner uiPartner = new UISourcePartner(partner.getPartnerId(), partner.getPartnerName());
                List ccList = partner.getContentClasses();
                if (ccList != null) {
                    for (ContentClass cc : ccList) {
                        uiPartner.addContentClass(new UIContentClass(cc.getId(), cc.getType().ordinal(), cc.getName()));
                    }
                }
                data.addSourcePartner(uiPartner);
            }
        }
    }

    public String getRelativePath() {
        return "service/content/create/IContentCreateViewService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }
}

