/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.metadata;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIAssetVisitor;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIItemAsset;
import com.tandbergtv.cms.portal.content.server.title.metadata.FieldTreeBuilder;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import java.util.HashMap;

class AssetBuilder
implements IUIAssetVisitor {
    private transient Asset builtAsset = null;

    public Asset build(UIAsset uiAsset) {
        uiAsset.accept(this);
        return this.getBuiltAsset();
    }

    private Asset getBuiltAsset() {
        Asset asset = this.builtAsset;
        this.builtAsset = null;
        return asset;
    }

    @Override
    public void visit(UIGroupAsset uiGroup) {
        Group group = new Group();
        group.setSeriesDocumentId(uiGroup.getSeriesDocumentId());
        group.setSeasonAssetId(uiGroup.getSeasonAssetId());
        this.copyProperties(uiGroup, (Asset)group);
        group.setType(uiGroup.getAssetType());
        if (group.getType().equalsIgnoreCase(Group.GroupType.PACKAGE.name())) {
            group.setReferencedTitleIds(uiGroup.getReferencedTitleIds());
        }
        for (UIAsset uiChildAsset : uiGroup.getChildren().getAll()) {
            Asset childAsset = this.build(uiChildAsset);
            group.addChild(childAsset);
        }
        this.builtAsset = group;
    }

    @Override
    public void visit(UIItemAsset uiItem) {
        Item item = new Item();
        this.copyProperties(uiItem, (Asset)item);
        item.setType(uiItem.getAssetType());
        this.builtAsset = item;
    }

    private void copyProperties(UIAsset uiAsset, Asset asset) {
        if (uiAsset.getId() != null) {
            asset.setId(uiAsset.getId().longValue());
        }
        asset.setOriginalAssetID(uiAsset.getOriginalAssetId());
        asset.setOriginalRevisionNumber(uiAsset.getOriginalAssetRevision());
        if (uiAsset.getVersion() != null) {
            asset.setLatestRevisionNumber(Integer.parseInt(uiAsset.getVersion()));
        }
        asset.setState(this.getAssetState(uiAsset));
        this.buildFields(uiAsset, asset);
        this.buildFiles(uiAsset, asset);
    }

    private void buildFields(UIAsset uiAsset, Asset asset) {
        FieldTreeBuilder builder = new FieldTreeBuilder();
        FieldTree fieldTree = builder.build(uiAsset);
        asset.setFieldTree(fieldTree);
    }

    private void buildFiles(UIAsset uiAsset, Asset asset) {
        HashMap<UIAssetFile, UIAssetFile> childParentRelationship = new HashMap<UIAssetFile, UIAssetFile>();
        for (UIAssetFile uiFile : uiAsset.getFiles()) {
            UIAssetFile parentUiFile = uiFile.getParentFile();
            childParentRelationship.put(uiFile, parentUiFile);
        }
        HashMap<UIAssetFile, File> fileMap = new HashMap<UIAssetFile, File>();
        for (UIAssetFile uiFile : uiAsset.getFiles()) {
            File file = new File();
            Long fileId = uiFile.getId();
            file.setDisplayId(fileId == null ? null : String.valueOf(Math.abs(fileId)));
            if (uiFile.getId() != null && uiFile.getId() > -1L) {
                file.setId(uiFile.getId().longValue());
            }
            file.setState(this.getAssetState(uiFile));
            FieldTreeBuilder builder = new FieldTreeBuilder();
            for (UIAssetFileField uiField : uiFile.getFields().values()) {
                FieldTreeNode treeNode = builder.build(uiField);
                if (treeNode == null || treeNode.getField() == null) continue;
                treeNode.getField().setTtvXPath(uiField.getField().getName());
                file.addField(treeNode.getField());
            }
            fileMap.put(uiFile, file);
        }
        for (UIAssetFile uiFile : childParentRelationship.keySet()) {
            UIAssetFile uiParentFile = (UIAssetFile)childParentRelationship.get(uiFile);
            File file = (File)fileMap.get(uiFile);
            if (uiParentFile != null) {
                File parentFile = (File)fileMap.get(uiParentFile);
                parentFile.addChild((Asset)file);
                continue;
            }
            asset.addChild((Asset)file);
        }
    }

    private AssetState getAssetState(UIAsset asset) {
        return asset.isActive() ? AssetState.ACTIVE : AssetState.INACTIVE;
    }

    private AssetState getAssetState(UIAssetFile assetFile) {
        return assetFile.isActive() ? AssetState.ACTIVE : AssetState.INACTIVE;
    }
}

