/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.metadata;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIFieldVisitor;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIBooleanField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIDateField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIFloatField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIIntegerField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeCodeField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import java.text.SimpleDateFormat;
import java.util.Date;

class FieldTreeBuilder
implements IUIFieldVisitor {
    private transient FieldTreeNode builtFieldTreeNode = null;

    public FieldTree build(UIAsset uiAsset) {
        FieldTree fieldTree = new FieldTree();
        FieldTreeNode rootNode = this.buildFieldTreeNode(uiAsset.getRootField());
        fieldTree.getRootElement().setChildren(rootNode.getChildren());
        return fieldTree;
    }

    public FieldTreeNode build(UIAssetFileField fileField) {
        return this.buildFieldTreeNode(fileField.getField());
    }

    private FieldTreeNode buildFieldTreeNode(UIField uiField) {
        uiField.accept(this);
        return this.getBuiltFieldTreeNode();
    }

    private FieldTreeNode getBuiltFieldTreeNode() {
        FieldTreeNode fieldTreeNode = this.builtFieldTreeNode;
        this.builtFieldTreeNode = null;
        return fieldTreeNode;
    }

    @Override
    public void visit(UIComplexField complexField) {
        FieldTreeNode treeNode = new FieldTreeNode();
        treeNode.setName(complexField.getName());
        for (UIField child : complexField.getChildren().getAll()) {
            FieldTreeNode childTreeNode = this.buildFieldTreeNode(child);
            if (this.isWrappedNode(childTreeNode)) {
                treeNode.setField(childTreeNode.getField());
                continue;
            }
            if (childTreeNode == null) continue;
            treeNode.addChild(childTreeNode);
        }
        this.builtFieldTreeNode = treeNode;
    }

    @Override
    public void visit(UIBooleanField simpleField) {
        this.visitSimpleField(simpleField, simpleField.getValue(), simpleField.getStringValue());
    }

    @Override
    public void visit(UIIntegerField simpleField) {
        this.visitSimpleField(simpleField, simpleField.getValue(), simpleField.getStringValue());
    }

    @Override
    public void visit(UIFloatField simpleField) {
        Float value = null;
        String stringValue = (String)simpleField.getValue();
        String unparsableValue = simpleField.getStringValue();
        if (stringValue != null && stringValue.trim().length() > 0) {
            try {
                value = Float.valueOf(Float.parseFloat(stringValue.trim()));
            }
            catch (Exception exception) {
                unparsableValue = stringValue;
            }
        }
        this.visitSimpleField(simpleField, value, unparsableValue);
    }

    @Override
    public void visit(UIDateField simpleField) {
        Date value = null;
        String stringValue = (String)simpleField.getValue();
        String unparsableValue = simpleField.getStringValue();
        if (stringValue != null && stringValue.trim().length() > 0) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                value = format.parse(stringValue.trim());
            }
            catch (Exception exception) {
                unparsableValue = stringValue;
            }
        }
        this.visitSimpleField(simpleField, value, unparsableValue);
    }

    @Override
    public void visit(UITimeField simpleField) {
        this.visitSimpleField(simpleField, simpleField.getValue(), simpleField.getStringValue());
    }

    @Override
    public void visit(UIStringField simpleField) {
        this.visitSimpleField(simpleField, simpleField.getValue(), simpleField.getStringValue());
    }

    @Override
    public void visit(UITimeCodeField simpleField) {
        this.visitSimpleField(simpleField, simpleField.getValue(), simpleField.getStringValue());
    }

    private void visitSimpleField(UISimpleField<?> simpleField, Object value, String stringValue) {
        boolean hasBatchProperties;
        boolean bl = hasBatchProperties = simpleField.isAutoFill() || simpleField.isNullify();
        if (!hasBatchProperties && this.isValueBlank(value, stringValue)) {
            return;
        }
        FieldTreeNode treeNode = new FieldTreeNode();
        treeNode.setName(simpleField.getName());
        treeNode.setAttribute(simpleField.isAttribute());
        Field field = new Field();
        if (simpleField.getId() != null) {
            field.setId(simpleField.getId().longValue());
        }
        if (value != null) {
            field.setTypedValue(value);
        } else {
            field.setValue(stringValue);
        }
        field.setNullify(simpleField.isNullify());
        field.setAutoFill(simpleField.isAutoFill());
        treeNode.setField(field);
        this.builtFieldTreeNode = treeNode;
    }

    private boolean isWrappedNode(FieldTreeNode node) {
        String wrappedFieldName;
        if (node == null) {
            return false;
        }
        String name = node.getName();
        return name == (wrappedFieldName = UISimpleFieldDefinition.WRAPPED_FIELD_NAME) || name != null && name.equals(wrappedFieldName);
    }

    private boolean isValueBlank(Object value, String stringValue) {
        String typedValue;
        if (value == null && (stringValue == null || stringValue.length() == 0)) {
            return true;
        }
        return value instanceof String && (typedValue = (String)value).length() == 0;
    }
}

