/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.metadata;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIItemAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.server.title.metadata.UISimpleFieldBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataTypeProvider;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.ParentChildRelation;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class UIAssetBuilder {
    private static final Logger logger = Logger.getLogger(UIAssetBuilder.class);
    private final Map<String, UIFieldDataType> dataTypes;
    private transient Map<Long, TitleAssetResource> thumbnailMap;
    private AssetUtil assetUtil = new AssetUtil();

    public UIAssetBuilder() {
        this.dataTypes = new UIFieldDataTypeProvider().getAll();
    }

    public UIAsset build(Asset asset, Map<Long, TitleAssetResource> thumbnailMap) {
        this.thumbnailMap = thumbnailMap;
        UIAsset uiAsset = this.build(asset);
        this.thumbnailMap = null;
        return uiAsset;
    }

    private UIAsset build(Asset asset) {
        UIAsset uiAsset = null;
        if ((asset = this.assetUtil.unWrap(asset)).getClass().equals(Group.class)) {
            uiAsset = this.buildGroup((Group)Group.class.cast(asset));
        } else if (asset.getClass().equals(Item.class)) {
            uiAsset = this.buildItem((Item)Item.class.cast(asset));
        } else {
            logger.debug((Object)("Ignoring asset subclass: " + asset.getClass().getName() + " when building UI Asset."));
        }
        uiAsset.setVersion(asset.getVersion());
        return uiAsset;
    }

    private UIGroupAsset buildGroup(Group group) {
        UIGroupAsset uiGroup = new UIGroupAsset();
        uiGroup.setSeriesDocumentId(group.getSeriesDocumentId());
        uiGroup.setSeasonAssetId(group.getSeasonAssetId());
        if (group.getType().equalsIgnoreCase(Group.GroupType.PACKAGE.name())) {
            uiGroup.setReferencedTitleIds(group.getReferencedTitleIds());
        }
        this.copyProperties((Asset)group, uiGroup);
        uiGroup.setAssetType(group.getType());
        for (Relation relation : group.getRelations()) {
            Asset child;
            if (!ParentChildRelation.class.isInstance(relation) || (child = this.assetUtil.unWrap(relation.getTargetAsset())) instanceof File) continue;
            uiGroup.addChild(this.build(child));
        }
        return uiGroup;
    }

    private UIItemAsset buildItem(Item item) {
        UIItemAsset uiItem = new UIItemAsset();
        this.copyProperties((Asset)item, uiItem);
        uiItem.setAssetType(item.getType());
        return uiItem;
    }

    private void copyProperties(Asset asset, UIAsset uiAsset) {
        uiAsset.setId(asset.getId());
        uiAsset.setOriginalAssetId(asset.getOriginalAssetID());
        uiAsset.setOriginalAssetRevision(asset.getOriginalRevisionNumber());
        uiAsset.setActive(AssetState.ACTIVE.equals((Object)asset.getState()));
        boolean hasThumbnail = this.thumbnailMap != null && this.thumbnailMap.containsKey(asset.getId());
        uiAsset.setThumbnailAvailable(hasThumbnail);
        this.buildFields(asset, uiAsset);
        this.buildFiles(asset, uiAsset, null);
        Collections.sort(uiAsset.getFiles(), new Comparator<UIAssetFile>(){

            @Override
            public int compare(UIAssetFile o1, UIAssetFile o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
    }

    private void buildFields(Asset asset, UIAsset uiAsset) {
        FieldTreeNode rootFieldTreeNode = asset.getFieldTree().getRootElement();
        UIComplexField uiRootField = uiAsset.getRootField();
        for (FieldTreeNode fieldTreeNode : rootFieldTreeNode.getChildren()) {
            UIField uiField = this.buildField(fieldTreeNode);
            uiRootField.addField(uiField);
        }
    }

    private UIField buildField(FieldTreeNode fieldNode) {
        UIField uiField = null;
        List childNodes = fieldNode.getChildren();
        int childCount = childNodes != null ? childNodes.size() : 0;
        boolean wrapField = false;
        if (fieldNode.getField() != null) {
            String xpath = fieldNode.getField().getTtvXPath();
            wrapField = DataTypeMappingReader.getInstance().hasChildren(xpath);
        }
        UIComplexField complexField = null;
        if (wrapField || childCount > 0) {
            complexField = new UIComplexField();
            complexField.setName(fieldNode.getName());
            if (childCount > 0) {
                for (FieldTreeNode childFieldNode : fieldNode.getChildren()) {
                    UIField childField = this.buildField(childFieldNode);
                    complexField.addField(childField);
                }
            }
            uiField = complexField;
        }
        if (fieldNode.getField() != null) {
            String dataTypeName = fieldNode.getField().getDataType();
            UIFieldDataType dataType = this.dataTypes.get(dataTypeName);
            UISimpleFieldBuilder fieldBuilder = new UISimpleFieldBuilder();
            UISimpleField<?> simpleField = fieldBuilder.build(fieldNode, dataType);
            if (complexField != null) {
                simpleField.setName(UISimpleFieldDefinition.WRAPPED_FIELD_NAME);
                complexField.addField(simpleField);
            } else {
                uiField = simpleField;
            }
        }
        return uiField;
    }

    private void buildFiles(Asset asset, UIAsset uiAsset, UIAssetFile uiAssetFile) {
        for (Relation relation : asset.getRelations()) {
            Asset child;
            if (!ParentChildRelation.class.isInstance(relation) || !((child = this.assetUtil.unWrap(relation.getTargetAsset())) instanceof File)) continue;
            UIAssetFile uiFile = this.buildFile((File)File.class.cast(child));
            uiAsset.addFile(uiFile);
            uiFile.setParentFile(uiAssetFile);
            this.buildFiles(child, uiAsset, uiFile);
        }
    }

    private UIAssetFile buildFile(File file) {
        UIAssetFile uiFile = new UIAssetFile();
        uiFile.setId(file.getId());
        uiFile.setActive(AssetState.ACTIVE.equals((Object)file.getState()));
        UISimpleFieldBuilder fieldBuilder = new UISimpleFieldBuilder();
        for (Field field : file.getFields()) {
            FieldTreeNode fieldNode = new FieldTreeNode();
            fieldNode.setName(field.getTtvXPath());
            fieldNode.setField(field);
            String dataTypeName = field.getDataType();
            UIFieldDataType dataType = this.dataTypes.get(dataTypeName);
            UISimpleField<?> uiField = fieldBuilder.build(fieldNode, dataType);
            UIAssetFileField uiFileField = new UIAssetFileField();
            uiFileField.setField(uiField);
            uiFile.addField(uiFileField);
        }
        return uiFile;
    }
}

