/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.metadata;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIBooleanField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIDateField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIFloatField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIIntegerField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeCodeField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IUIFieldDataTypeVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeCodeDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.TimeCodeType;
import java.text.SimpleDateFormat;
import java.util.Date;

class UISimpleFieldBuilder
implements IUIFieldDataTypeVisitor {
    private transient FieldTreeNode fieldNode = null;
    private transient UISimpleField<?> builtField = null;

    public UISimpleField<?> build(FieldTreeNode fieldNode, UIFieldDataType dataType) {
        this.fieldNode = fieldNode;
        dataType.accept((IUIFieldDataTypeVisitor)this);
        return this.getBuiltField();
    }

    private UISimpleField<?> getBuiltField() {
        this.fieldNode = null;
        UISimpleField<?> field = this.builtField;
        this.builtField = null;
        return field;
    }

    public void visit(BooleanDataType datatype) {
        UIBooleanField field = new UIBooleanField();
        this.buildSimpleField(field);
        try {
            if (this.isParsable()) {
                Boolean value = (Boolean)this.fieldNode.getField().getTypedValue();
                field.setValue(value);
            }
        }
        catch (Exception exception) {
            field.setStringValue(this.fieldNode.getField().getValue());
        }
        this.builtField = field;
    }

    public void visit(IntegerDataType datatype) {
        UIIntegerField field = new UIIntegerField();
        this.buildSimpleField(field);
        try {
            if (this.isParsable()) {
                Long value = (Long)this.fieldNode.getField().getTypedValue();
                field.setValue(value);
            }
        }
        catch (Exception exception) {
            field.setStringValue(this.fieldNode.getField().getValue());
        }
        this.builtField = field;
    }

    public void visit(FloatDataType datatype) {
        UIFloatField field = new UIFloatField();
        this.buildSimpleField(field);
        try {
            if (this.isParsable()) {
                Float value = (Float)this.fieldNode.getField().getTypedValue();
                String stringValue = value != null ? value.toString() : null;
                field.setValue(stringValue);
            }
        }
        catch (Exception exception) {
            field.setStringValue(this.fieldNode.getField().getValue());
        }
        this.builtField = field;
    }

    public void visit(DateDataType datatype) {
        UIDateField field = new UIDateField();
        this.buildSimpleField(field);
        try {
            if (this.isParsable()) {
                Date value = (Date)this.fieldNode.getField().getTypedValue();
                String stringValue = null;
                if (value != null) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    stringValue = format.format(value);
                }
                field.setValue(stringValue);
            }
        }
        catch (Exception exception) {
            field.setStringValue(this.fieldNode.getField().getValue());
        }
        this.builtField = field;
    }

    public void visit(TimeDataType datatype) {
        UITimeField field = new UITimeField();
        this.buildSimpleField(field);
        try {
            if (this.isParsable()) {
                String value = (String)this.fieldNode.getField().getTypedValue();
                if (value != null && value.trim().length() > 0) {
                    SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
                    format.parse(value.trim());
                }
                field.setValue(value);
            }
        }
        catch (Exception exception) {
            field.setStringValue(this.fieldNode.getField().getValue());
        }
        this.builtField = field;
    }

    public void visit(StringDataType datatype) {
        UIStringField field = new UIStringField();
        this.buildSimpleField(field);
        try {
            if (this.isParsable()) {
                String value = (String)this.fieldNode.getField().getTypedValue();
                field.setValue(value);
            }
        }
        catch (Exception exception) {
            field.setStringValue(this.fieldNode.getField().getValue());
        }
        this.builtField = field;
    }

    public void visit(TimeCodeDataType datatype) {
        UITimeCodeField field = new UITimeCodeField();
        this.buildSimpleField(field);
        try {
            if (this.isParsable()) {
                TimeCodeType value = (TimeCodeType)this.fieldNode.getField().getTypedValue();
                field.setValue(value.getValue());
            }
        }
        catch (Exception exception) {
            field.setStringValue(this.fieldNode.getField().getValue());
        }
        this.builtField = field;
    }

    private void buildSimpleField(UISimpleField<?> simpleField) {
        Field field = this.fieldNode.getField();
        simpleField.setName(this.fieldNode.getName());
        simpleField.setXpath(field.getTtvXPath());
        simpleField.setId(field.getId());
        simpleField.setAttribute(this.fieldNode.isAttribute());
        if (!this.isParsable() || field.getTypedValue() == null) {
            simpleField.setStringValue(field.getValue());
        }
    }

    private boolean isParsable() {
        Boolean parsable = this.fieldNode.getField().getParsable();
        return parsable != null ? parsable : false;
    }
}

