/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.modelbuilder;

import com.tandbergtv.cms.portal.content.client.title.model.activity.UIActivityItem;
import com.tandbergtv.cms.portal.content.client.title.model.activity.UITitleActivity;
import com.tandbergtv.cms.portal.content.server.infoprovider.PreferenceProvider;
import com.tandbergtv.watchpoint.pmm.entities.activity.ITitleActivity;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivityType;
import com.tandbergtv.watchpoint.pmm.title.ITitleActivityService;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class UITitleActivityBuilder {
    private static final Logger logger = Logger.getLogger(UITitleActivityBuilder.class);
    ITitleActivityService activityManger;
    private static final String MAX_WORKORDERS_key = "ContentComponent.TitleActivityView.WorkOrders.max";
    PreferenceProvider preferenceProvider = new PreferenceProvider();

    public UITitleActivityBuilder(ITitleActivityService activityManger) {
        this.activityManger = activityManger;
    }

    public void buildActivityItemsForTitle(Long titleId, UITitleActivity uiActivity) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        int maxWorkOrders = this.preferenceProvider.getMaxWorkOrderCount(MAX_WORKORDERS_key);
        uiActivity.setTitleId(titleId);
        List curActivityList = this.activityManger.getActivity(titleId.longValue(), TitleActivityType.CURRENT, maxWorkOrders);
        ArrayList<UIActivityItem> uiCurActivityList = new ArrayList<UIActivityItem>();
        for (ITitleActivity curActivity : curActivityList) {
            UIActivityItem activityItem = new UIActivityItem();
            WFSearchResult wf = curActivity.getShallowWorkFlowProcess();
            activityItem.setWorkOrderId(wf.getProcessId());
            if (wf.getToken() != null) {
                if (wf.getToken().getStartTime() != null) {
                    activityItem.setStartTime(dateFormat.format(wf.getToken().getStartTime()));
                }
                int statusCode = wf.getToken().getOperationalStatus();
                String toolTip = this.buidStatusToolTip(statusCode, wf.getToken());
                activityItem.setStatus(ProcessStatus.values()[statusCode].toString());
                activityItem.setStatusToolTip(toolTip);
                activityItem.setCurrentTask(wf.getToken().getNodeName());
            }
            activityItem.setTemplate(wf.getProcessDefinitionName());
            uiCurActivityList.add(activityItem);
        }
        uiActivity.setCurrentItems(uiCurActivityList);
        ArrayList<UIActivityItem> uiHistActivityList = new ArrayList<UIActivityItem>();
        List histActivityList = this.activityManger.getActivity(titleId.longValue(), TitleActivityType.HISTORICAL, maxWorkOrders);
        for (ITitleActivity histActivity : histActivityList) {
            UIActivityItem activityItem = new UIActivityItem();
            WFSearchResult wf = histActivity.getShallowWorkFlowProcess();
            activityItem.setWorkOrderId(wf.getProcessId());
            if (wf.getToken() != null) {
                if (wf.getToken().getStartTime() != null) {
                    activityItem.setStartTime(dateFormat.format(wf.getToken().getStartTime()));
                }
                if (wf.getToken().getEndTime() != null) {
                    activityItem.setEndTime(dateFormat.format(wf.getToken().getEndTime()));
                }
                int statusCode = wf.getToken().getOperationalStatus();
                String toolTip = this.buidStatusToolTip(statusCode, wf.getToken());
                activityItem.setStatus(ProcessStatus.values()[statusCode].toString());
                activityItem.setStatusToolTip(toolTip);
                activityItem.setCurrentTask(wf.getToken().getNodeName());
            }
            activityItem.setTemplate(wf.getProcessDefinitionName());
            uiHistActivityList.add(activityItem);
        }
        uiActivity.setHistoryItems(uiHistActivityList);
    }

    public String buidStatusToolTip(int statusCode, WFToken token) {
        if (ProcessStatus.ERROR.ordinal() == statusCode) {
            String comment;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            logger.debug((Object)String.format("token=%s", token == null ? "null" : token.toString()));
            Date errorTime = token.getErrorTime();
            if (errorTime == null) {
                logger.error((Object)"null error time");
                errorTime = new Date();
            }
            if ((comment = token.getErrorComment()) == null) {
                logger.error((Object)"null comment");
            }
            return String.valueOf(sdf.format(errorTime)) + " " + comment;
        }
        return null;
    }
}

