/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.modelbuilder;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleOverview;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UIEnumerationBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITitleStatus;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import java.util.List;

public class UITitleBuilder {
    private final ISiteManager siteManager;
    private final ITitleCopyService titleCopyService;
    private static final IContentClassService contentClassService = ServiceLocator.getService("ContentClassService", IContentClassService.class);
    private static final String TITLE_HEADING_ASSET_TYPE = Item.ItemType.TITLE.name();
    private static final String TITLE_HEADING_FIELD_XPATH = "/Fields/Title/DisplayTitle/Value";

    public UITitleBuilder(ISiteManager siteManager, ITitleCopyService titleCopyService) {
        this.siteManager = siteManager;
        this.titleCopyService = titleCopyService;
    }

    public UITitle buildUITitle(Title title) {
        UITitle uiTitle = new UITitle();
        uiTitle.setId(title.getId());
        uiTitle.setContentClassId(title.getContentClassId());
        uiTitle.setPartnerId(title.getPartnerId());
        uiTitle.setOverview(this.buildUITitleOverview(title));
        return uiTitle;
    }

    public UITitleOverview buildUITitleOverview(Title title) {
        DistributionSiteTitle siteTitle = null;
        if (title.isCopy()) {
            siteTitle = this.siteManager.getDistributionSiteTitle(title.getId().longValue());
            if (siteTitle != null) {
                Title original = this.titleCopyService.getOriginalTitle(title.getId().longValue());
                return this.buildSiteTitleOverview(siteTitle, original);
            }
            return this.buildTitleOverview(title);
        }
        UITitleOverview overview = this.buildTitleOverview(title);
        overview.setDistributionStatus(title.getDistributionStatus().toString());
        overview.setProcessingStatus(title.getProcessingStatus().toString());
        return overview;
    }

    private UITitleOverview buildTitleOverview(Title title) {
        UITitleOverview overview = new UITitleOverview();
        overview.setId(title.getId());
        overview.setOriginalId(title.getOriginalId());
        overview.setVersion(title.getAsset().getVersion());
        overview.setOriginalVersion(title.getOriginalVersion());
        overview.setHeading(this.getHeading(title));
        overview.setStatus((UITitleStatus)UIEnumerationBuilder.getUIStatusEnumValue((Enum)title.getStatus(), (Enum[])UITitleStatus.values()));
        try {
            ContentClass contentClass = contentClassService.getContentClassById(title.getContentClassId().longValue());
            overview.setContentClassName(contentClass.getName());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return overview;
    }

    private UITitleOverview buildSiteTitleOverview(DistributionSiteTitle siteTitle, Title originalTitle) {
        UITitleOverview overview = this.buildTitleOverview(siteTitle.getTitle());
        overview.setSiteID(siteTitle.getDistributionSite().getId());
        if (originalTitle != null) {
            overview.setCurrentOriginalVersion(originalTitle.getAsset().getVersion());
        }
        overview.setDistributedVersion(siteTitle.getDistributedVersion());
        overview.setDistributionStatus(siteTitle.getStatus().toString());
        overview.setChangedAfterDistribution(siteTitle.isChangedAfterDistribution());
        overview.setDistributionStatusDetail(siteTitle.getStatusDetail());
        return overview;
    }

    private String getHeading(Title title) {
        List fields;
        String headingValue = null;
        Asset rootAsset = title.getAsset();
        if (rootAsset != null && (fields = rootAsset.getAllFieldsForXpath(TITLE_HEADING_ASSET_TYPE, TITLE_HEADING_FIELD_XPATH)) != null && fields.size() > 0) {
            headingValue = ((Field)fields.get(0)).getValue();
        }
        return headingValue;
    }
}

