/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.modelbuilder;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifference;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIComparedTitle;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIFieldDifference;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareReport;
import com.tandbergtv.cms.portal.content.server.SpecificationServiceImpl;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIAssetDefinitionVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIItemAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.IUISpecificationManager;
import com.tandbergtv.cms.portal.ui.title.server.specification.UISpecificationManager;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldBase;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.compare.IAssetDifference;
import com.tandbergtv.metadatamanager.model.compare.IFieldDifference;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.compare.ITitleCompareReport;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UITitleCompareDataBuilder {
    private final UIAssetSpecification specification;
    private final List<UIAssetDefinition> assetDefinitions;
    private final IAssetSpecificationManager specificationManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    private final IUISpecificationManager uiSpecificationManager = new UISpecificationManager();
    private final SpecificationService specificationService = new SpecificationServiceImpl();
    private static final String SPECIFICATION_MANAGER_JNDI_NAME = "cms/AssetSpecificationManager/local";
    private static final String ASSET_TABLE_NAME = "title.AssetDifference";
    private static final String FILE_TABLE_NAME = "title.FileAssetDifference";

    public UITitleCompareDataBuilder(String specificationName) throws NeptuneException {
        this.specification = this.uiSpecificationManager.getUISpecification();
        this.assetDefinitions = this.getAllAssetDefinitions();
    }

    public UITitleCompareDataBuilder(String specificationName, String type) throws NeptuneException {
        this.specification = this.uiSpecificationManager.getUIAssetSpecification(type);
        this.assetDefinitions = this.getAllAssetDefinitions();
    }

    public UITitleCompareData build(ITitleCompareReport report) throws NeptuneException {
        UITitleCompareData uiData = new UITitleCompareData();
        uiData.setReport(this.buildReport(report));
        uiData.setAssetMetadataTable(this.getTable(ASSET_TABLE_NAME));
        uiData.setFileMetadataTable(this.getTable(FILE_TABLE_NAME));
        uiData.setSpecifications(this.uiSpecificationManager.getPreviewSpecs());
        return uiData;
    }

    private UITitleCompareReport buildReport(ITitleCompareReport report) {
        UITitleCompareReport uiReport = new UITitleCompareReport();
        uiReport.setTitle1(this.buildUIComparedTitle(report.getTitle1()));
        uiReport.setTitle2(this.buildUIComparedTitle(report.getTitle2()));
        uiReport.setAssetDifference(this.buildUIAssetDifference(report));
        return uiReport;
    }

    private UiTable getTable(String tableName) throws NeptuneException {
        return this.specificationService.getTable(tableName);
    }

    private UIComparedTitle buildUIComparedTitle(Title title) {
        if (title == null) {
            return null;
        }
        UIComparedTitle uiTitle = new UIComparedTitle();
        uiTitle.setId(title.getId());
        uiTitle.setOriginalId(title.getOriginalId());
        uiTitle.setOriginalVersion(title.getOriginalVersion());
        return uiTitle;
    }

    private UIAssetDifference buildUIAssetDifference(ITitleCompareReport report) {
        if (!report.isDifferent()) {
            return null;
        }
        IAssetDifference difference = report.getAssetCompareReport().getDifference();
        return this.buildUIAssetDifference(difference, null);
    }

    private UIAssetDifference buildUIAssetDifference(IAssetDifference difference, String parentAssetType) {
        UIAssetDefinition definition;
        String assetType;
        boolean fileAssetType;
        UIAssetDifference uiDifference = new UIAssetDifference();
        Asset asset = null;
        if (difference.isAsset1Defined()) {
            uiDifference.setAsset1Id(difference.getAsset1().getId());
            asset = difference.getAsset1();
        }
        if (difference.isAsset2Defined()) {
            uiDifference.setAsset2Id(difference.getAsset2().getId());
            if (asset == null) {
                asset = difference.getAsset2();
            }
        }
        if (!(fileAssetType = this.isFileAssetType(assetType = asset.getAssetType()))) {
            parentAssetType = assetType;
        }
        String assetTypeName = (definition = this.findAssetDefinition(parentAssetType)) != null && !fileAssetType ? definition.getDisplayName() : assetType;
        uiDifference.setAssetType(assetType);
        uiDifference.setAssetTypeDisplayName(assetTypeName);
        uiDifference.setMetadata(this.getAssetMetadata(asset));
        if (difference.hasFieldDifferences()) {
            Map<String, UIFieldDefinition> fields = null;
            Map<String, String> fieldNames = null;
            if (!fileAssetType) {
                fields = this.getFieldMap(definition);
                fieldNames = this.getFieldNames(fields);
            } else {
                fieldNames = this.getFieldNames(definition.getFileDefinition());
            }
            for (IFieldDifference fieldDifference : difference.getFieldDifferences()) {
                UIFieldDifference uiFieldDifference = this.buildUIFieldDifference(fieldDifference, fieldNames, fields);
                uiDifference.addFieldDifference(uiFieldDifference);
            }
        }
        if (difference.hasChildAssetDifferences()) {
            for (IAssetDifference childDifference : difference.getChildAssetDifferences()) {
                UIAssetDifference uiChildDifference = this.buildUIAssetDifference(childDifference, parentAssetType);
                uiDifference.addChildDifference(uiChildDifference);
            }
        }
        return uiDifference;
    }

    private Map<String, String> getAssetMetadata(Asset asset) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Collection<String> xpaths = this.getMetadataXPaths(asset.getAssetType());
        for (String xpath : xpaths) {
            Field field = asset.getFirstField(xpath);
            String value = field != null ? field.getValue() : null;
            metadata.put(xpath, value);
        }
        return metadata;
    }

    private Collection<String> getMetadataXPaths(String assetType) {
        HashSet<String> metadataNames = new HashSet<String>();
        Table table = null;
        if (assetType != null && this.isFileAssetType(assetType)) {
            table = this.specificationManager.getTableConfiguration(FILE_TABLE_NAME);
        } else if (assetType != null) {
            table = this.specificationManager.getTableConfiguration(ASSET_TABLE_NAME);
        }
        if (table != null && table.getColumns() != null) {
            for (Column column : table.getColumns()) {
                String metadataName = column.getParameter();
                if (metadataName == null || metadataName.length() <= 0) continue;
                metadataNames.add(metadataName);
            }
        }
        return metadataNames;
    }

    private UIFieldDifference buildUIFieldDifference(IFieldDifference fieldDifference, Map<String, String> fieldNames, Map<String, UIFieldDefinition> fields) {
        UIFieldDifference uiFieldDifference = new UIFieldDifference();
        IField field = null;
        if (fieldDifference.isField1Defined()) {
            field = fieldDifference.getField1();
            uiFieldDifference.setField1Value(field.getValue());
        }
        if (fieldDifference.isField2Defined()) {
            uiFieldDifference.setField2Value(fieldDifference.getField2().getValue());
            if (field == null) {
                field = fieldDifference.getField2();
            }
        }
        String xpath = field.getTtvXPath();
        String qualifiedName = FieldBase.buildTtvXPathWithIndices((String)xpath, (List)field.getIndices());
        String displayName = fieldNames.get(xpath);
        uiFieldDifference.setQualifiedDisplayName(this.getQualifiedDisplayName(xpath, fields));
        uiFieldDifference.setName(xpath);
        uiFieldDifference.setQualifiedName(qualifiedName);
        uiFieldDifference.setDisplayName(displayName != null ? displayName : xpath);
        uiFieldDifference.setIndices(field.getIndices());
        return uiFieldDifference;
    }

    private List<String> getQualifiedDisplayName(String xpath, Map<String, UIFieldDefinition> fields) {
        UIFieldDefinition definition;
        UIFieldDefinition uIFieldDefinition = definition = fields != null ? fields.get(xpath) : null;
        if (definition == null) {
            return null;
        }
        ArrayList<String> fieldPath = new ArrayList<String>();
        if (this.getFieldPath(definition, fieldPath)) {
            fieldPath.add(definition.getDisplayName());
        }
        return fieldPath;
    }

    private boolean getFieldPath(UIFieldDefinition definition, List<String> fieldPath) {
        boolean ancestorCollapsed = false;
        if (definition.getParent() != null && !(ancestorCollapsed = this.getFieldPath(definition.getParent(), fieldPath))) {
            if (definition instanceof UIComplexFieldDefinition) {
                UIComplexFieldDefinition complexDefinition = (UIComplexFieldDefinition)definition;
                ancestorCollapsed = complexDefinition.isShowCollapsed();
                if (!ancestorCollapsed || complexDefinition.getMaximumCount() > 1) {
                    fieldPath.add(definition.getDisplayName());
                }
            } else {
                fieldPath.add(definition.getDisplayName());
            }
        }
        return ancestorCollapsed;
    }

    private boolean isFileAssetType(String assetType) {
        return Item.ItemType.FILE.toString().equals(assetType);
    }

    private UIAssetDefinition findAssetDefinition(String assetType) {
        if (assetType == null || this.isFileAssetType(assetType)) {
            return null;
        }
        for (UIAssetDefinition assetDefinition : this.assetDefinitions) {
            if (!assetType.equals(assetDefinition.getAssetType())) continue;
            return assetDefinition;
        }
        return null;
    }

    private List<UIAssetDefinition> getAllAssetDefinitions() {
        final ArrayList<UIAssetDefinition> definitions = new ArrayList<UIAssetDefinition>();
        definitions.addAll(this.specification.getAssetDefinitions());
        int counter = 0;
        while (counter < definitions.size()) {
            UIAssetDefinition currentDefinition = (UIAssetDefinition)definitions.get(counter++);
            currentDefinition.accept(new IUIAssetDefinitionVisitor(){

                public void visit(UIGroupAssetDefinition assetDefinition) {
                    definitions.addAll(assetDefinition.getChildren());
                }

                public void visit(UIItemAssetDefinition assetDefinition) {
                }
            });
        }
        return definitions;
    }

    private Map<String, String> getFieldNames(UIAssetFileDefinition definition) {
        HashMap<String, String> definitions = new HashMap<String, String>();
        for (UIAssetFileFieldDefinition fieldDefinition : definition.getFieldDefinitions()) {
            String xpath = fieldDefinition.getFieldDefinition().getXPath();
            definitions.put(xpath, fieldDefinition.getDisplayName());
        }
        return definitions;
    }

    private Map<String, String> getFieldNames(Map<String, UIFieldDefinition> fieldMap) {
        HashMap<String, String> names = new HashMap<String, String>();
        for (String key : fieldMap.keySet()) {
            names.put(key, fieldMap.get(key).getDisplayName());
        }
        return names;
    }

    private Map<String, UIFieldDefinition> getFieldMap(UIAssetDefinition definition) {
        HashMap<String, UIFieldDefinition> fieldMap = new HashMap<String, UIFieldDefinition>();
        this.getFields((UIFieldDefinition)definition.getRootFieldDefinition(), fieldMap);
        return fieldMap;
    }

    private void getFields(UIFieldDefinition definition, Map<String, UIFieldDefinition> definitions) {
        definitions.put(definition.getXPath(), definition);
        if (definition instanceof UIComplexFieldDefinition) {
            UIComplexFieldDefinition complexDefinition = (UIComplexFieldDefinition)definition;
            for (UIFieldDefinition child : complexDefinition.getChildren()) {
                this.getFields(child, definitions);
            }
        }
    }
}

