/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.modelbuilder;

import com.tandbergtv.cms.portal.content.client.title.model.history.UIProgressItem;
import com.tandbergtv.cms.portal.content.client.title.model.history.UITitleHistory;
import com.tandbergtv.cms.portal.content.server.infoprovider.PreferenceProvider;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang.math.NumberUtils;

public class UITitleHistoryBuilder {
    private static final String DATE_FORMAT_KEY = "ContentComponent.portlets.dateFormat";
    PreferenceProvider preferenceProvider = new PreferenceProvider();

    public UITitleHistory build(Title title) {
        UITitleHistory uiHistory = new UITitleHistory();
        uiHistory.setLatestTitleVersion(title.getAsset().getVersion());
        uiHistory.setNormalizedName(ProgressStatusHelper.NORMALIZED);
        uiHistory.addUpdatedNames(ProgressStatusHelper.UPDATED);
        uiHistory.addUpdatedNames(ProgressStatusHelper.UPDATED_AS_DRAFT);
        this.buildProgressItems(title, uiHistory);
        return uiHistory;
    }

    public UITitleHistory build(Title title, boolean isSeriesTitle) {
        UITitleHistory uiHistory = new UITitleHistory();
        uiHistory.setLatestTitleVersion(title.getAsset().getVersion());
        uiHistory.setNormalizedName(ProgressStatusHelper.NORMALIZED);
        uiHistory.addUpdatedNames(ProgressStatusHelper.UPDATED);
        uiHistory.addUpdatedNames(ProgressStatusHelper.UPDATED_AS_DRAFT);
        uiHistory.setSeriesTitle(isSeriesTitle);
        this.buildProgressItems(title, uiHistory);
        return uiHistory;
    }

    private void buildProgressItems(Title title, UITitleHistory history) {
        Collection progressItems = title.getAllProgressItems();
        if (progressItems != null) {
            for (ProgressItem progressItem : progressItems) {
                UIProgressItem uiProgressItem = this.buildProgressItem(title, progressItem);
                history.getProgressItems().add(uiProgressItem);
            }
            Collections.sort(history.getProgressItems(), new Comparator<UIProgressItem>(){

                @Override
                public int compare(UIProgressItem o1, UIProgressItem o2) {
                    Integer revision1 = NumberUtils.toInt((String)o1.getTitleRevision(), (int)-1);
                    Integer revision2 = NumberUtils.toInt((String)o2.getTitleRevision(), (int)-1);
                    int compare = revision2.compareTo(revision1);
                    if (compare != 0) {
                        return compare;
                    }
                    Date date1 = o1.getTimestamp();
                    Date date2 = o2.getTimestamp();
                    compare = date2.compareTo(date1);
                    if (compare == 0) {
                        String name1 = o1.getName();
                        String name2 = o2.getName();
                        if (name1 == null) {
                            name1 = "";
                        }
                        if (name2 == null) {
                            name2 = "";
                        }
                        compare = name1.compareTo(name2);
                    }
                    return compare;
                }
            });
        }
    }

    private UIProgressItem buildProgressItem(Title title, ProgressItem progressItem) {
        DateFormat dateFormat = this.preferenceProvider.getDateFormat(DATE_FORMAT_KEY);
        UIProgressItem uiProgressItem = new UIProgressItem();
        uiProgressItem.setId(progressItem.getId());
        uiProgressItem.setTitleId(progressItem.getTitleId());
        uiProgressItem.setAssetListId(progressItem.getAssetListId());
        uiProgressItem.setName(progressItem.getName());
        uiProgressItem.setValue(progressItem.getValue());
        uiProgressItem.setSuccess(progressItem.getIsSuccess());
        uiProgressItem.setTimestamp(progressItem.getTimestamp());
        uiProgressItem.setFormattedTimestamp(dateFormat.format(progressItem.getTimestamp()));
        uiProgressItem.setTitleRevision(progressItem.getTitleRevision());
        uiProgressItem.setSourceComponentName(progressItem.getSourceComponentName());
        uiProgressItem.setSourceEntityName(progressItem.getSourceEntityName());
        uiProgressItem.setSourceId(progressItem.getSourceId());
        String latestVersion = title.getAsset().getVersion();
        String version = progressItem.getTitleRevision();
        uiProgressItem.setLatestRevision(latestVersion != null && latestVersion.equals(version));
        return uiProgressItem;
    }
}

