/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.modelbuilder;

import com.tandbergtv.cms.portal.content.client.title.service.TitleServiceException;
import com.tandbergtv.cms.portal.content.server.title.TitleActionExceptionHandler;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.XmlToHtml;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import java.io.StringWriter;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class UITitlePreviewBuilder {
    public static final String TITLE_PREVIEW_CONTENTS_ATTR = "TitlePreviewContents-";
    public static final String PREVIEW_REQUEST_PARAM = "TitlePreviewKey";
    private static final String PREVIEW_URL = "cms_contentmgmt_ui/jsps/";
    private static final String XML_PAGE = "title_xml_preview.jsp";
    private static final String XML_PAGE_ALT = "title_xml_preview_alt.jsp";
    private static final String ERROR_PAGE = "title_preview_error.jsp";
    private final HttpSession session;
    private final ITitleManager titleManager;
    private final TitleActionExceptionHandler handler;
    private boolean useHtml;

    public UITitlePreviewBuilder(HttpSession httpSession, ITitleManager titleManager, boolean useHtml) {
        this.session = httpSession;
        this.titleManager = titleManager;
        this.useHtml = useHtml;
        this.handler = new TitleActionExceptionHandler();
    }

    public String generatePreview(Title title, Specification specification) {
        PreviewOutput output = this.generateTitlePreview(title, specification);
        this.session.setAttribute(TITLE_PREVIEW_CONTENTS_ATTR + output.previewKey, (Object)output.contents);
        return output.url;
    }

    private PreviewOutput generateTitlePreview(Title title, Specification specification) {
        PreviewOutput output = new PreviewOutput();
        output.previewKey = this.generateTitlePreviewKey();
        try {
            Document document = this.titleManager.getDocument(title, specification);
            String docContents = this.getDocumentContents(document);
            if (this.useHtml) {
                output.contents = XmlToHtml.getHtml(docContents);
            } else {
                output.contents = docContents;
            }
            output.url = this.buildURL(output, false);
        }
        catch (TransformerException e) {
            output.contents = "Failed to transform the title XML document. Error: " + e.getLocalizedMessage();
            output.url = this.buildURL(output, true);
        }
        catch (RuntimeException e) {
            TitleServiceException se = this.handler.handleException(e);
            if (se.isLocalizedMessage()) {
                output.contents = se.getLocalizedMessage();
            } else {
                output.contents = "Unexpected error when generating title preview. Error: " + se.getLocalizedMessage();
            }
            output.url = this.buildURL(output, true);
        }
        return output;
    }

    private String getDocumentContents(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }

    private String buildURL(PreviewOutput output, boolean isError) {
        String url = PREVIEW_URL;
        url = isError ? String.valueOf(url) + ERROR_PAGE : (this.useHtml ? String.valueOf(url) + XML_PAGE_ALT : String.valueOf(url) + XML_PAGE);
        url = String.valueOf(url) + "?TitlePreviewKey=" + output.previewKey;
        return url;
    }

    private String generateTitlePreviewKey() {
        return UUID.randomUUID().toString();
    }

    private static final class PreviewOutput {
        private String contents;
        private String previewKey;
        private String url;

        private PreviewOutput() {
        }
    }
}

