/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.modelbuilder;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.TrackingSiteTitle;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIActiveDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UILocalTitleSites;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITitleSites;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITrackingSiteItem;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class UITitleSitesBuilder {
    ISiteManager siteManager;

    public UITitleSitesBuilder(ISiteManager siteManager) {
        this.siteManager = siteManager;
    }

    public void buildSiteItemsForMasterTitle(Title masterTitle, UITitleSites uiSites) {
        ArrayList<UIDistributionSiteItem> distSiteItems = new ArrayList<UIDistributionSiteItem>();
        ArrayList<UITrackingSiteItem> trackingSiteItems = new ArrayList<UITrackingSiteItem>();
        TreeMap<String, List<UITrackingSiteItem>> trackingSiteLookUp = new TreeMap<String, List<UITrackingSiteItem>>();
        Long masterTitleId = masterTitle.getId();
        List distSiteTitles = this.siteManager.getDistributionSiteTitles(masterTitleId.longValue());
        for (DistributionSiteTitle distSiteTitle : distSiteTitles) {
            UIDistributionSiteItem siteItem = this.buildDistributionSiteItem(distSiteTitle, masterTitle);
            distSiteItems.add(siteItem);
            List<UITrackingSiteItem> trackSiteItemsForDistSite = this.getUITrackingSiteItems(distSiteTitle, trackingSiteLookUp);
            trackingSiteItems.addAll(trackSiteItemsForDistSite);
        }
        for (UITrackingSiteItem trackingSiteItem : trackingSiteItems) {
            ArrayList<UITrackingSiteItem> val = (ArrayList<UITrackingSiteItem>)trackingSiteLookUp.get(trackingSiteItem.getDistributionSite());
            if (val == null) {
                val = new ArrayList<UITrackingSiteItem>();
                trackingSiteLookUp.put(trackingSiteItem.getDistributionSite(), val);
            }
            val.add(trackingSiteItem);
        }
        uiSites.setTitleId(masterTitle.getId());
        uiSites.setTrackingSiteLookUp(trackingSiteLookUp);
        uiSites.setDistributionSiteItems(distSiteItems);
        uiSites.setActiveDistributionSiteItems(this.buildActiveSiteItems());
    }

    public void buildSiteItemsForLocalTitle(Title localTitle, Title originalTitle, UILocalTitleSites uiSites) {
        Long localTitleId = localTitle.getId();
        DistributionSiteTitle distSiteTitle = this.siteManager.getDistributionSiteTitle(localTitleId.longValue());
        uiSites.setDistributionSiteItem(this.buildDistributionSiteItem(distSiteTitle, originalTitle));
        uiSites.setLocalTitleId(localTitleId);
        uiSites.setMasterTitleId(distSiteTitle.getTitle().getOriginalId());
        uiSites.setTrackingSiteItems(this.getUITrackingSiteItems(distSiteTitle, null));
    }

    private UIDistributionSiteItem buildDistributionSiteItem(DistributionSiteTitle siteTitle, Title masterTitle) {
        UIDistributionSiteItem siteItem = new UIDistributionSiteItem();
        siteItem.setSiteId(siteTitle.getDistributionSite().getId());
        siteItem.setName(siteTitle.getDistributionSite().getName());
        siteItem.setStatus(siteTitle.getStatus() != null ? siteTitle.getStatus().name() : null);
        siteItem.setStatusDetail(siteTitle.getStatusDetail());
        siteItem.setTitleId(siteTitle.getTitle().getId());
        siteItem.setMasterTitleId(masterTitle != null ? masterTitle.getId() : null);
        siteItem.setDistributedVersion(siteTitle.getDistributedVersion());
        siteItem.setIsDifferentFromDistributed(siteTitle.isChangedAfterDistribution());
        String targetedVersion = siteTitle.getTitle().getOriginalVersion();
        siteItem.setMasterTargetedVersion(targetedVersion);
        siteItem.setIsDifferentFromMaster(targetedVersion != null && !targetedVersion.equals(masterTitle.getVersion()));
        return siteItem;
    }

    private UITrackingSiteItem buildTrackingSiteItem(TrackingSiteTitle siteTitle, DistributionSite site) {
        UITrackingSiteItem siteItem = new UITrackingSiteItem();
        siteItem.setSiteId(siteTitle.getTrackingSite().getId());
        siteItem.setTitleId(siteTitle.getTitle().getId());
        siteItem.setName(siteTitle.getTrackingSite().getName());
        siteItem.setStatus(siteTitle.getStatus().name());
        siteItem.setDistributionSiteId(site.getId());
        siteItem.setDistributionSite(site.getName());
        return siteItem;
    }

    private List<UITrackingSiteItem> getUITrackingSiteItems(DistributionSiteTitle siteTitle, Map<String, List<UITrackingSiteItem>> trackingSiteLookUp) {
        Long localTitleId = siteTitle.getTitle().getId();
        List trackSiteTitles = this.siteManager.getTrackingSiteTitles(localTitleId.longValue());
        ArrayList<UITrackingSiteItem> trackingSiteItems = new ArrayList<UITrackingSiteItem>();
        for (TrackingSiteTitle trackSiteTitle : trackSiteTitles) {
            UITrackingSiteItem trackSiteItem = this.buildTrackingSiteItem(trackSiteTitle, siteTitle.getDistributionSite());
            if (trackingSiteLookUp == null) {
                trackingSiteItems.add(trackSiteItem);
                continue;
            }
            List<UITrackingSiteItem> val = trackingSiteLookUp.get(trackSiteItem.getDistributionSite());
            if (val == null) {
                val = new ArrayList<UITrackingSiteItem>();
                trackingSiteLookUp.put(trackSiteItem.getDistributionSite(), val);
            }
            val.add(trackSiteItem);
        }
        return trackingSiteItems;
    }

    private List<UIActiveDistributionSiteItem> buildActiveSiteItems() {
        ArrayList<UIActiveDistributionSiteItem> activeDistSiteItems = new ArrayList<UIActiveDistributionSiteItem>();
        List activeDistSites = this.siteManager.getActiveDistributionSites();
        for (DistributionSite activeDistSite : activeDistSites) {
            UIActiveDistributionSiteItem activeSite = new UIActiveDistributionSiteItem();
            activeSite.setSiteId(activeDistSite.getId());
            activeSite.setName(activeDistSite.getName());
            activeDistSiteItems.add(activeSite);
        }
        Collections.sort(activeDistSiteItems);
        return activeDistSiteItems;
    }
}

