/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.modelbuilder;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UIEnumerationBuilder;
import com.tandbergtv.cms.portal.content.server.util.ResourceUtil;
import com.tandbergtv.cms.portal.content.server.util.TemplateMatcher;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.server.specification.UISpecificationManager;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class UITitleValidationMessageBuilder {
    private static final String ERROR_MESSAGE_BUNDLE = "com.tandbergtv.cms.portal.content.server.title.TitleViewServiceErrorMessages";
    private ResourceBundle errorMessageBundle;
    private UIAssetSpecification uiAssetSpec;

    public UITitleValidationMessageBuilder() {
        Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
        this.errorMessageBundle = ResourceBundle.getBundle(ERROR_MESSAGE_BUNDLE, locale);
        UISpecificationManager specManager = new UISpecificationManager();
        this.uiAssetSpec = specManager.getUISpecification();
    }

    public void buildValidationMessages(List<TitleValidationMessage> validationMessages, List<UITitleValidationMessage> uiMessages) {
        if (validationMessages != null) {
            for (TitleValidationMessage validationMessage : validationMessages) {
                UITitleValidationMessage uiMessage = this.buildValidationMessage(validationMessage);
                uiMessages.add(uiMessage);
            }
        }
    }

    public UITitleValidationMessage buildValidationMessage(TitleValidationMessage validationMessage) {
        String code = validationMessage.getCode();
        String messageTemplate = ResourceUtil.getResourceString(this.errorMessageBundle, code);
        if (messageTemplate != null) {
            return this.buildTemplateMessage(validationMessage);
        }
        return this.buildDefaultMessage(validationMessage);
    }

    private UITitleValidationMessage buildTemplateMessage(TitleValidationMessage validationMessage) {
        UITitleValidationMessageType uiType = (UITitleValidationMessageType)UIEnumerationBuilder.getUIEnumerationValue((Enum)validationMessage.getType(), (Enum[])UITitleValidationMessageType.values());
        String messageCode = validationMessage.getCode();
        String messageTemplate = ResourceUtil.getResourceString(this.errorMessageBundle, messageCode);
        Map<String, String> variables = this.createMessageTemplateVariables(validationMessage);
        TemplateMatcher matcher = new TemplateMatcher();
        String message = matcher.replace(messageTemplate, variables);
        return new UITitleValidationMessage(message, uiType, messageCode);
    }

    private Map<String, String> createMessageTemplateVariables(TitleValidationMessage message) {
        UIAssetFileFieldDefinition fileFieldDef;
        HashMap<String, String> map = new HashMap<String, String>();
        UIAssetDefinition assetDef = null;
        if (message.getAssetType() != null && (assetDef = this.uiAssetSpec.findFirstAssetDefinition(message.getAssetType())) != null) {
            map.put("assetName", assetDef.getDisplayName());
        }
        if (message.getFieldXPath() != null && assetDef != null && (fileFieldDef = assetDef.findUIAssetFileFieldDefinitionByXPath(message.getFieldXPath())) != null && fileFieldDef.getFieldDefinition() != null) {
            map.put("fieldName", fileFieldDef.getFieldDefinition().getDisplayName());
        }
        if (message.getDisplayId() != null) {
            map.put("fileId", message.getDisplayId());
        }
        return map;
    }

    private UITitleValidationMessage buildDefaultMessage(TitleValidationMessage validationMessage) {
        String message = validationMessage.getMessage();
        UITitleValidationMessageType uiType = (UITitleValidationMessageType)UIEnumerationBuilder.getUIEnumerationValue((Enum)validationMessage.getType(), (Enum[])UITitleValidationMessageType.values());
        return new UITitleValidationMessage(message, uiType, validationMessage.getCode());
    }
}

