/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.modelbuilder;

import java.io.StringReader;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlToHtml {
    public static String getHtml(String xml) {
        Document doc = XmlToHtml.getDocument(xml);
        Node node = doc.getFirstChild();
        StringBuffer html = new StringBuffer();
        html.append("<html><script src=\"/portal/cms_contentmgmt_ui/javascript/visibility.js\"></script><body bgcolor=\"white\">");
        XmlToHtml.getHtmlRec(node, html, new AtomicInteger(0));
        html.append("</body></html>");
        return html.toString();
    }

    private static void getHtmlRec(Node node, StringBuffer html, AtomicInteger buttonCnt) {
        int i;
        NamedNodeMap attributes = node.getAttributes();
        String nodeName = node.getNodeName();
        String textContent = "";
        boolean hasChildren = false;
        boolean isTextNode = false;
        if (node.getChildNodes().getLength() == 1 && node.getChildNodes().item(0).getNodeType() == 3) {
            isTextNode = true;
            textContent = StringEscapeUtils.escapeXml((String)node.getTextContent());
        } else if (node.getChildNodes().getLength() > 0) {
            hasChildren = true;
        }
        html.append("");
        int buttonNum = 0;
        if (hasChildren) {
            buttonNum = buttonCnt.incrementAndGet();
            html.append("\r\n<table><tr><td ><span style=\"cursor:default; font-family: Courier New;\" id = \"sec" + buttonNum + "\" onclick=\"setInvisible(this);\">-</span></td><td>");
        } else {
            html.append("\r\n<div style=\"margin-left:15px\">");
        }
        html.append("&lt;");
        html.append("<span style=\"color:purple;font-weight:bold;\">");
        html.append(nodeName);
        html.append("</span>");
        if (attributes != null) {
            i = 0;
            while (i < attributes.getLength()) {
                Node att = attributes.item(i);
                html.append(" <span style=\"font-weight:bold;\">");
                html.append(att.getNodeName());
                html.append("</span>");
                html.append("=");
                html.append("<span style=\"color:blue\">");
                html.append("&quot;");
                if (att.getTextContent() != null && !att.getTextContent().isEmpty()) {
                    html.append(StringEscapeUtils.escapeXml((String)att.getTextContent()));
                }
                html.append("&quot;");
                html.append("</span>");
                ++i;
            }
        }
        if (textContent != null && !textContent.trim().isEmpty() || node.getChildNodes().getLength() > 0) {
            html.append("&gt;");
        }
        if (hasChildren) {
            html.append("</td><tr id =\"sec" + buttonNum + "Div\"><td></td><td><div style=\"margin-left:10px\">");
            i = 0;
            while (i < node.getChildNodes().getLength()) {
                Node child = node.getChildNodes().item(i);
                XmlToHtml.getHtmlRec(child, html, buttonCnt);
                ++i;
            }
            html.append("</div>");
        }
        if (hasChildren) {
            html.append("\r\n");
            html.append("&lt/<span style=\"color:purple;font-weight:bold;\">");
            html.append(nodeName);
            html.append("</span>&gt;</td></tr></table>");
        } else if (isTextNode) {
            html.append(textContent);
            html.append("\r\n ");
            html.append("&lt;/<span style=\"color:purple;font-weight:bold;\">");
            html.append(nodeName);
            html.append("</span>&gt;</div>");
        } else {
            html.append("/&gt;</div>");
        }
    }

    private static Document getDocument(String xml) {
        try {
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

