/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.series;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.title.search.entities.BasicSearchField;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.BooleanVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.DateVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.FloatVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.IntegerVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EpisodeSearchFieldProvider {
    public static final String EPISODE_DEF_FILE = "episodeFields.xml";
    public static final String BSEARCH_FILE_DIRECTORY = "conf" + File.separator + "contentMgmt";
    public static final String BSEARCH_FILE_PATH = String.valueOf(BSEARCH_FILE_DIRECTORY) + File.separator + "episodeFields.xml";
    public static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String RESOURCE_BUNDLE_BASE_NAME = "EpisodeFieldNames";
    private static final String RESOURCE_BUNDLE_FULL_PATH = "com/tandbergtv/cms/portal/content/server/title/series/EpisodeFieldNames";
    private static final String TITLE_STATUS_PROPERTY = "status";
    private IAssetSpecificationManager specificationManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    private static final Logger logger = Logger.getLogger(EpisodeSearchFieldProvider.class);
    private Map<String, Boolean> multivalueLookUp = new HashMap<String, Boolean>();
    private static EpisodeSearchFieldProvider instance;

    public static synchronized EpisodeSearchFieldProvider getInstance() {
        if (instance == null) {
            instance = new EpisodeSearchFieldProvider();
        }
        return instance;
    }

    private EpisodeSearchFieldProvider() {
    }

    public List<UiColumn> getColumnInfos() throws NeptuneException {
        Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
        ArrayList<UiColumn> result = new ArrayList<UiColumn>();
        List<BasicSearchField> fields = this.getEpisodeSearchFieldBase(locale);
        UISpecification spec = this.specificationManager.getUISpecification(UISpecification.Type.PACKAGE);
        List allConfs = spec.getAllTitleConf();
        block0: for (BasicSearchField f : fields) {
            for (TitleConf conf : allConfs) {
                Variable v;
                if (!conf.getName().equals(f.getAssetType()) || (v = conf.getMetadataVariableByXPath(f.getXpath())) == null || !(v instanceof SimpleVariable)) continue;
                SimpleVariable sv = (SimpleVariable)v;
                result.add(this.buildField(f.getAssetType(), f.getDisplayName(), sv));
                continue block0;
            }
        }
        return result;
    }

    private UiColumn buildField(String assetType, String displayName, SimpleVariable variable) {
        UiColumn.DataType fieldDataType;
        if (variable instanceof StringVariable) {
            fieldDataType = UiColumn.DataType.STRING;
        } else if (variable instanceof BooleanVariable) {
            fieldDataType = UiColumn.DataType.BOOLEAN;
        } else if (variable instanceof IntegerVariable) {
            fieldDataType = UiColumn.DataType.INTEGER;
        } else if (variable instanceof FloatVariable) {
            fieldDataType = UiColumn.DataType.FLOAT;
        } else if (variable instanceof DateVariable) {
            fieldDataType = UiColumn.DataType.DATE;
        } else if (variable instanceof TimeVariable) {
            fieldDataType = UiColumn.DataType.TIME;
        } else {
            throw new RuntimeException("Unexpected variable type " + variable.getClass().getName());
        }
        UiColumn col = new UiColumn();
        String sectionName = !assetType.equalsIgnoreCase("PACKAGE") ? "PACKAGE/" + assetType : assetType;
        col.setSectionName(sectionName);
        col.setDisplayName(displayName);
        col.setFieldType(UIFieldType.ASSET);
        col.setName(variable.getXPath());
        col.setDataType(fieldDataType);
        Boolean isMultiValued = this.multivalueLookUp.get(variable.getXPath());
        if (isMultiValued != null) {
            col.setIsMultiValued(isMultiValued.booleanValue());
        }
        return col;
    }

    private File getConfFile() {
        String installFolder = System.getProperty(PRODUCT_DIR);
        File searchFieldsFile = new File(String.valueOf(installFolder) + File.separator + BSEARCH_FILE_PATH);
        return searchFieldsFile;
    }

    private List<BasicSearchField> getEpisodeSearchFieldBase(Locale locale) {
        ArrayList<BasicSearchField> searchFields = new ArrayList<BasicSearchField>();
        try {
            ResourceBundle bundle;
            Document doc;
            URL schemaUrl = EpisodeSearchFieldProvider.class.getResource("EpisodeSearch.xsd");
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            DocumentBuilderFactory dbmFactory = DocumentBuilderFactory.newInstance();
            dbmFactory.setSchema(schema);
            DocumentBuilder builder = dbmFactory.newDocumentBuilder();
            File searchFieldsFile = this.getConfFile();
            if (searchFieldsFile.exists()) {
                doc = builder.parse(searchFieldsFile);
                bundle = EpisodeSearchFieldProvider.getResourceBundle(locale);
            } else {
                URL fileUrl = EpisodeSearchFieldProvider.class.getResource(EPISODE_DEF_FILE);
                InputStream is = fileUrl.openStream();
                doc = builder.parse(is);
                bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_FULL_PATH, locale);
            }
            NodeList nodes = doc.getElementsByTagName("mdmsearchfield");
            int i = 0;
            while (i < nodes.getLength()) {
                String displayName;
                Element e = (Element)nodes.item(i);
                String assetType = e.getAttribute("assetType");
                String xpath = e.getAttribute("xpath");
                String displayNameKey = e.getAttribute("displayName");
                try {
                    displayName = bundle.getString(displayNameKey);
                }
                catch (MissingResourceException missingResourceException) {
                    logger.error((Object)("ResourceBundle for basic search is missing: " + displayNameKey));
                    displayName = "!" + displayNameKey + "!";
                }
                searchFields.add(new BasicSearchField(assetType, xpath, displayName));
                String isMultiValue = e.getAttribute("isMultiValued");
                if (isMultiValue != null) {
                    this.multivalueLookUp.put(xpath, new Boolean(isMultiValue));
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while looking up basic search fields.", (Throwable)e);
            return new ArrayList<BasicSearchField>();
        }
        return searchFields;
    }

    private static ResourceBundle getResourceBundle(Locale locale) throws MalformedURLException {
        String installFolder = System.getProperty(PRODUCT_DIR);
        File directory = new File(String.valueOf(installFolder) + File.separator + BSEARCH_FILE_DIRECTORY);
        URL[] urls = new URL[]{directory.toURL()};
        URLClassLoader aUrlCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME, locale, aUrlCL);
        return bundle;
    }

    public UiColumn getTitleStatusColumn() {
        String displayName = "Status";
        UiColumn col = new UiColumn();
        String sectionName = "";
        col.setSectionName(sectionName);
        col.setDisplayName(displayName);
        col.setFieldType(UIFieldType.PMM_TITLE);
        col.setName(TITLE_STATUS_PROPERTY);
        col.setDataType(UiColumn.DataType.STRING);
        return col;
    }
}

