/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.series;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeasonListItem;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeriesListItem;
import com.tandbergtv.cms.portal.content.server.infoprovider.PreferenceProvider;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SeriesFieldsBuilder {
    private static final Logger logger = Logger.getLogger(SeriesFieldsBuilder.class);
    private String seriesLabelXpath = "";
    private String seasonLabelXpath = "";
    public static String SERIES_ID_XPATH = "series_identifier";
    public static String SEASON_ID_XPATH = "season_identifier";
    private static SeriesFieldsBuilder instance;

    public static synchronized SeriesFieldsBuilder getInstance() {
        if (instance == null) {
            instance = new SeriesFieldsBuilder();
        }
        return instance;
    }

    private SeriesFieldsBuilder() {
        this.readXpathsForSeriesIdentifiers();
    }

    public List<UISeriesListItem> getSeriesList(Long partnerId) throws Exception {
        ArrayList<UISeriesListItem> seriesItems = new ArrayList<UISeriesListItem>();
        IElasticSearchService service = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        SearchParameters params = new SearchParameters();
        params.titleIndexType = ElasticSearchIndexType.SERIES;
        params.pageSize = 2000;
        if (partnerId != null) {
            params.partnerIds = new long[1];
            params.partnerIds[0] = partnerId;
        }
        params.fields = new ArrayList();
        params.fields.add(new SearchParameters.FieldInfo("documentId", "integer"));
        params.fields.add(new SearchParameters.FieldInfo(this.seriesLabelXpath, "string"));
        TitleSearchResult results = service.advancedSearch(null, params);
        for (TitleSearchResult.SearchRow row : results.getRows()) {
            String seriesDocId = row.getFirstValueAsString(0);
            String label = row.getFirstValueAsString(1);
            if (label == null || label.trim().isEmpty()) {
                label = "Series (id: " + row.getId() + ")";
            }
            seriesItems.add(new UISeriesListItem(row.getId(), label, seriesDocId));
        }
        Collections.sort(seriesItems);
        return seriesItems;
    }

    public List<UISeasonListItem> getSeasonList(String seriesDocId) throws Exception {
        ArrayList<UISeasonListItem> seasonItems = new ArrayList<UISeasonListItem>();
        if (seriesDocId == null || seriesDocId.trim().isEmpty()) {
            return seasonItems;
        }
        IElasticSearchService service = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        SearchParameters params = new SearchParameters();
        params.titleIndexType = ElasticSearchIndexType.SEASON;
        params.pageSize = 1000;
        params.fields = new ArrayList();
        params.fields.add(new SearchParameters.FieldInfo(this.seasonLabelXpath, "string"));
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft("seriesDocumentId");
        predicate.setDataType("integer");
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setOperator(LogicalOperator.EQUAL);
        predicate.setValue(seriesDocId);
        ExpList rootNode = new ExpList();
        ExpValue valNode = new ExpValue((Predicate)predicate);
        rootNode.addItem((ExpNode)valNode);
        TitleSearchResult results = service.advancedSearch((ExpNode)rootNode, params);
        for (TitleSearchResult.SearchRow row : results.getRows()) {
            String label = row.getFirstValueAsString(0);
            if (label == null || label.trim().isEmpty()) {
                label = "Season (id: " + row.getId() + ")";
            }
            seasonItems.add(new UISeasonListItem("" + row.getId(), label));
        }
        Collections.sort(seasonItems);
        return seasonItems;
    }

    private void readXpathsForSeriesIdentifiers() {
        PreferenceProvider parmsConfFile = new PreferenceProvider();
        Map<String, String> defParms = parmsConfFile.getSeriesIdentifiers();
        if (defParms != null) {
            Object[] keys = defParms.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                String key = (String)keys[i];
                String value = defParms.get(key);
                if (key.equalsIgnoreCase(SERIES_ID_XPATH)) {
                    this.seriesLabelXpath = value;
                } else if (key.equalsIgnoreCase(SEASON_ID_XPATH)) {
                    this.seasonLabelXpath = value;
                }
                ++i;
            }
        }
        if (this.seriesLabelXpath.isEmpty() || this.seasonLabelXpath.isEmpty()) {
            throw new RuntimeException("Error reading property file for Series identifier xpaths.");
        }
        this.validateXpath(this.seriesLabelXpath);
        this.validateXpath(this.seasonLabelXpath);
        this.seriesLabelXpath = SeriesFieldsBuilder.fixXPath(this.seriesLabelXpath);
        this.seasonLabelXpath = SeriesFieldsBuilder.fixXPath(this.seasonLabelXpath);
    }

    private void validateXpath(String xpath) {
        int ndx = xpath.indexOf("/Fields");
        if (ndx >= 0) {
            String fldXpath = xpath.substring(ndx).trim();
            String type = DataTypeMappingReader.getInstance().determineDataType(fldXpath);
            if (type == null) {
                throw new RuntimeException("Invalid xpath in seriesidentifiers.properties.");
            }
        }
    }

    private static String fixXPath(String str) {
        if (str == null) {
            return null;
        }
        String assetPath = "/SERIES";
        String fieldPath = str;
        int idx = str.indexOf("/Fields");
        if (idx > 0) {
            assetPath = str.substring(0, idx).toUpperCase();
            if (!assetPath.startsWith("/")) {
                assetPath = "/" + assetPath;
            }
            if (!assetPath.startsWith("/SERIES/")) {
                assetPath = "/SERIES" + assetPath;
            }
            fieldPath = str.substring(idx);
        }
        return ElasticSearchUtil.createElasticSearchKey((String)assetPath, (String)fieldPath);
    }
}

