/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.util;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class HostnameResolver {
    public static String replaceURIWithIP(String urlValue) throws Exception {
        URI uri = new URI(urlValue);
        String ip = HostnameResolver.getIPByHostname(uri.getHost());
        URI updatedUrl = new URI(uri.getScheme(), uri.getUserInfo(), ip, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        return updatedUrl.toString();
    }

    private static String getIPByHostname(String hostname) throws UnknownHostException {
        return InetAddress.getByName(hostname).getHostAddress();
    }

    public static String resolveLocalName(String hostname) throws IOException {
        String addr = null;
        try {
            addr = HostnameResolver.getIPByHostname(hostname);
        }
        catch (UnknownHostException unknownHostException) {
            List<String> addresses = HostnameResolver.getHostAddresses();
            if (addresses.isEmpty()) {
                throw new IOException("No IP addresses configured");
            }
            addr = addresses.get(0);
        }
        return addr;
    }

    private static List<String> getHostAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            InetAddress localhost = InetAddress.getByName("localhost");
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (ip instanceof Inet6Address || ip.getHostAddress().equals(localhost.getHostAddress())) continue;
                    addresses.add(ip.getHostAddress());
                }
            }
        }
        catch (IOException iOException) {}
        return addresses;
    }
}

