/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateMatcher {
    private Pattern pattern;

    public TemplateMatcher(String leftBrace, String rightBrace) {
        leftBrace = Pattern.quote(leftBrace);
        rightBrace = Pattern.quote(rightBrace);
        this.pattern = Pattern.compile(String.valueOf(leftBrace) + "(.*?)" + rightBrace);
    }

    public TemplateMatcher(String prefix) {
        prefix = Pattern.quote(prefix);
        this.pattern = Pattern.compile(String.valueOf(prefix) + "(\\w*)");
    }

    public TemplateMatcher() {
        this("${", "}");
    }

    public String replace(String template, VariableResolver resolver) {
        if (template == null || resolver == null) {
            return template;
        }
        StringBuilder buff = new StringBuilder();
        Matcher matcher = this.pattern.matcher(template);
        int cursor = 0;
        while (cursor < template.length() && matcher.find(cursor)) {
            buff.append(template.subSequence(cursor, matcher.start()));
            String variableName = matcher.group(1).trim();
            String value = resolver.resolve(variableName);
            buff.append(value != null ? value : matcher.group());
            cursor = matcher.end();
        }
        buff.append(template.subSequence(cursor, template.length()));
        return buff.toString();
    }

    public String replace(String template, Map<String, String> variables) {
        return this.replace(template, new MapVariableResolver(variables));
    }

    public static class MapVariableResolver
    implements VariableResolver {
        private Map<String, String> variables;

        private MapVariableResolver(Map<String, String> variables) {
            this.variables = variables;
        }

        @Override
        public String resolve(String variable) {
            return this.variables.get(variable);
        }
    }

    public static interface VariableResolver {
        public String resolve(String var1);
    }
}

