/*
 * There are 2 copy of Yinyang Paint in CMS. One is in PMM, the other one is in Content Mgr.
 * The ImageEditor.js file is the only difference between the 2 copies.
 * 
 * In PMM's version, change 2 things:
 * 		a) Add a TrackEventHandlers.js to intercept the GWT.
 * 		b) Change ImageEditor.init(), add more initialization.  
 * 
 * 
 * When change one copy of the library, do remember to sync it to other library copy.
 */

var isMac = false;
if (navigator.appVersion.indexOf("Mac")!=-1) isMac=true;
var pxRatio = 1;
var isRetina = false;
var scaleUp = function(that){
	var w = $(that).attr("width");
	var h = $(that).attr("height");
	var ctx = that.getContext("2d")
	$(that).css("width", w + "px");
	$(that).css("height", h + "px");
	$(that).attr("width", w*pxRatio);
	$(that).attr("height", h*pxRatio);
	that.getContext("2d").scale(pxRatio,pxRatio);
	ctx.lineJoin = "round";
}

pxRatio = Math.round(window.devicePixelRatio);
if(pxRatio > 1){
	isRetina = true;
}
if(isRetina){
	$(".canvas_menu, #copyright_canvas, #hover-text-canvas, #helper-text-canvas, #helper-text-canvas-arrow").each(function(){
		scaleUp(this);
	});
}
	
var ImageEditor = {
		
		fileName: null,
		buttonHold: null,
		wind: null,
		
		backupDocEvents :null,
		backupWinEvents : null,
	
        init: function(container) {
        	this.reset();
        	
        	this.saveDocJqueryHandlers();
        	
        	this.removeDocJqueryHandlers(); 
        	this.removeDocWindRawHandlers();
        	
        	GUI.drawUI(container);
        	Menus.init();
	
        	this.initCanvases();
        	Input.init();
	
        	jscolor.init();
        	Yang.init();
       	    Yang.imageEditor = this;
	
	        Sliders.init();
	        this.initEvents();
	        
        },
        
        cleanup : function() {
        	//restore the handlers before reset
        	this.restoreDocJqueryHandlers();
        	
        	this.reset();
        },


        loadImage : function (imageData, fileName) {
		if(fileName != undefined){
			Tools.upload.addImage(imageData, fileName);
			this.fileName = fileName;
                        Pic.title = fileName;
		}else{
			Tools.upload.addImage(imageData);
			this.fileName = null;
		}
        },
        loadImageUrl : function (dataUri, fileName) {
           	// make ajax call to get image data url
	        var request = new XMLHttpRequest();
        	request.open('GET', dataUri, true);
        	request.onreadystatechange = function() {
                	// Makes sure the document is ready to parse.
	                if(request.readyState == 4) {
       	                	// Makes sure it's found the file.
	            	       	if(request.status == 200) {
	            	       		ImageEditor.loadImage(request.responseText, fileName);
			                this.fileName = fileName;
                                        Pic.title = fileName;
            		       	}
          	       	}
           	};
       	        request.send(null);
        },
        clear: function () {
                GUI.clear();
        },
        getImageDataBase64 : function () {
                return Tools.downloadfile.getImageDataBase64();
        },
        uploadImage : function () {
                Tools.openfile.click();
        },
        getImageFileName : function () {
                return Pic.title;
        },
	setCursor: function(){
                return;
	},
	drawCursor: function(toolName){
                return;
	},
	initEvents : function(){
		
		Tools.upload.init();
		this.wind = window;
		
		this.spot = this.wind.location;
		
		$('canvas').attr('unselectable','on');

		this.box = this.spot.host;
		
		$('.button_cover').bind("touchstart click", function(){
			
			var clicked = Tools[$(this).attr("data-key")];
			
			if(Tools.sortlayers.enabled && $(this).attr("data-key") != "sortlayers"){
				Tools.sortlayers.unselect();
			}
			
			if(is_mobile){
					clicked.click(1);
			}if(clicked == undefined){
				Yang.tool.unselect();
				$(".active_button_cover").removeClass("active_button_cover");
				clicked = "selectbox";
			}else if(clicked.selectable){
				if(Yang.tool && Yang.tool.unselect != undefined){
					Yang.tool.unselect(clicked);
				}
				$(".active_button_cover").removeClass("active_button_cover");
				$(this).addClass("active_button_cover");
				Yang.toolName = $(this).attr("data-key");
				Yang.tool = clicked;
				Yang.tool.select();
				Yang.imageEditor.setCursor();
			}else{
				clicked.click(1);
			}
			
		}).mousedown(function(){
			var clicked = Tools[$(this).attr("data-key")];
				if(clicked != undefined && clicked.holdable != undefined && clicked.holdable){
					this.buttonHold = setInterval(function(){
						clicked.click();
					}, 30);
				}
		}).mouseleave(function(){
			clearInterval(this.buttonHold);
		}).mouseup(function(){
			clearInterval(this.buttonHold);
		});

	        $(".button_cover").each(function(){
		        if($(this).attr("data-key") == "selectbox"){
			$(this).trigger("click");
		   }
	        });
	},
	initCanvases: function(){
		Yang.ctx = $("#top_canvas")[0].getContext("2d");
	},
	
	showDocHandlers : function() {
		var events = $._data($(document)[0], "events");
		
		if(events == undefined) {
			return;
		} 
		
		$.each(events, function(eventName, eventHandler) {
				console.log("Name:" + eventName + ", count: " + eventHandler.length );				
		});
	},
	
	saveDocJqueryHandlers : function() {
		var events = $._data($(document)[0], "events");
		if(events == undefined) {
			return;
		}
		
		this.docEvents = [];
		this.docHandlers = [];
		var that = this;
		$.each(events, function(eventName, eventHandlers) {
			that.docEvents.push(eventName);
			
			var tmpDocHandlers = [];
			for(var i =0; i< eventHandlers.length; i++) {
					tmpDocHandlers.push(eventHandlers[i].handler);
			}
			that.docHandlers.push(tmpDocHandlers);
		});
	}, 
	
	restoreDocJqueryHandlers: function() {
		$(document).off();
		
		for(var eventIndex = 0; eventIndex< this.docHandlers.length; eventIndex++) {
			for(var handlerIndex = 0; handlerIndex < this.docHandlers[eventIndex].length; handlerIndex++) {
				$(document).on(this.docEvents[eventIndex], this.docHandlers[eventIndex][handlerIndex]);
			}
		}		
	},
	
	reset : function() {
		this.fileName = null;
		this.buttonHold= null;
		this.wind = null;
	
		this.docEvents =[];
		this.docHandlers =[];
		
		this.backupDocEvents = null;
		this.backupWinEvents = null;

		Yang.reset();
		Input.reset();
		Pic.reset();
		Tools.size.reset();
		jscolor.reset();
	}, 
	
	removeDocJqueryHandlers : function() {
		$(document).off("mousedown mousemove mouseout mouseup keyup keydown keypress");
	},
	
	removeDocWindRawHandlers: function() {
		document.removeEvents("mousemove", "mouseup", "mousedown", "mouseout", "mouseover");
		window.removeEvents("mousemove", "mouseup", "mousedown", "mouseout", "mouseover");
	} 
	
};
