initCache = function(type) {
	    if(!this.EventList) { this.EventList = []; }
	    if(!this.EventList[type]) { this.EventList[type] = []; }
	    if(!this.EventList[type][true]) { this.EventList[type][true] = []; }
	    if(!this.EventList[type][false]) { this.EventList[type][false] = []; }
}

addEventListener_x = function(type, listener,isCapture) {
		this.initCache(type);
		this.addEventListenerBase.apply(this, arguments);
	        
	    if(arguments.length ==2) {
	    	isCapture = false;
	    } 
	        
	    this.EventList[type][isCapture].push(listener);
}

removeEventsBase = function(type) {
		this.initCache(type);
		if(!this.EventList[type]) {
			return;
		}
		
		var captueEvents = this.EventList[type][true];
		for(var i=0; i< captueEvents.length; i++) {
			this.removeEventListener(type, captueEvents[i], true);
		}
		
		var bubblingEvents = this.EventList[type][false];
		for(var i=0; i < bubblingEvents.length; i++) {
			this.removeEventListener(type, bubblingEvents[i],false);
		}
}

removeEvents = function() {
		for(var i = 0; i< arguments.length; i++) {
			var type = arguments[i];
			this.removeEventsBase(type);
		}
}

if ((typeof EventTarget) === 'undefined') {
	//IE
	document.addEventListenerBase = document.addEventListener;
	document.addEventListener = addEventListener_x;
	document.initCache = initCache;
	document.removeEventsBase = removeEventsBase;
	document.removeEvents = removeEvents;	
	
	window.addEventListenerBase = window.addEventListener;
	window.addEventListener = addEventListener_x;
	window.initCache = initCache;
	window.removeEventsBase = removeEventsBase;
	window.removeEvents = removeEvents;	
	
	
} else {
	//standard browser: Chrome, Firefox
	EventTarget.prototype.addEventListenerBase = EventTarget.prototype.addEventListener;
	EventTarget.prototype.addEventListener = addEventListener_x;
	EventTarget.prototype.initCache = initCache;
	EventTarget.prototype.removeEventsBase = removeEventsBase;
	EventTarget.prototype.removeEvents = removeEvents;
}
