
function isVLCPluginInstalled() {
    var name = "VLC";
    if (navigator.plugins && (navigator.plugins.length > 0)) {
        for(var i=0;i<navigator.plugins.length;++i)
            if (navigator.plugins[i].name.indexOf(name) != -1)
              return true;
    }
    else {
        try {
            new ActiveXObject("VideoLAN.VLCPlugin.2");
            return true;
        } catch (err) {}
    }
    return false;   
}


function getIEVersion() {  
	  var rv = -1;
	  if (navigator.appName == 'Microsoft Internet Explorer')
	  {
	    var ua = navigator.userAgent;
	    var re  = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
	    if (re.exec(ua) != null)
	      //rv = parseFloat( RegExp.$1 );
	      rv = parseInt( RegExp.$1 );
	  }
	  else if (navigator.appName == 'Netscape')
	  {
	    var ua = navigator.userAgent;
	    var re  = new RegExp("Trident/.*rv:([0-9]{1,}[\.0-9]{0,})");
	    if (re.exec(ua) != null)
	      //rv = parseFloat( RegExp.$1 );
	      rv = parseInt( RegExp.$1 );
	  }
	  //alert ("IE version = " + rv);
	  return rv; 	  
}

function registerVLCEvent(event, handler) {
    var vlc = document.getElementById('vlc');
    if (vlc) {
    	if (vlc.attachEvent) {
            // Microsoft
            vlc.attachEvent (event, handler);
        } else if (vlc.addEventListener) {
            // Mozilla: DOM level 2
            vlc.addEventListener (event, handler, false);
        } else{
            // DOM level 0
            vlc["on" + event] = handler;
        }
    }
}


function selectAudio(track)
{
    var vlc = document.getElementById('vlc');
    if (vlc) {       
        if (track == 0) {
            if (!vlc.audio.mute) vlc.audio.toggleMute();
        } else if (track <= vlc.audio.count) {
            vlc.audio.track = parseInt(track);
            //if (vlc.audio.track != track) { alert("Unable to set audio track."); }
            if (vlc.audio.mute) vlc.audio.toggleMute();
        }
    }
}

function ff(rate)
{
    var vlc = document.getElementById('vlc');
    if (vlc) {
        var i = 1.0 * rate;
        vlc.input.rate = i;
        if (!vlc.audio.mute) { vlc.audio.toggleMute() }
    }
}

function play()
{
    var vlc = document.getElementById('vlc');
    if (vlc) {
        vlc.input.rate = 1.0;
        if (vlc.audio.mute) { vlc.audio.toggleMute() }
        if(vlc.playlist.isPlaying != true)
        	vlc.playlist.play();
    }
}

function reset()
{
    var vlc = document.getElementById('vlc');
    if (vlc) {
        vlc.input.rate = 1.0;
        if (vlc.audio.mute) { vlc.audio.toggleMute() }
    }
}


