<%--
Serves image.
--%>
<%@page import="java.nio.file.Paths"%>
<%@page import="java.nio.file.Files"%>
<%@page pageEncoding="utf8" contentType="text/html;charset=UTF-8" %>
<%@page import="java.net.URI"%>
<%@page import="java.io.*" %>
<%@page import="org.apache.commons.codec.binary.Base64" %>
<%@page import="org.apache.commons.io.IOUtils" %>
<%@page import="java.util.*" %>

<%
String fileURI = request.getParameter("fileURI");
if(fileURI == null || fileURI.isEmpty())
{
	PrintWriter writer = response.getWriter();
	writer.println("File URI cannot be empty. ");
	out.clear();
	out = pageContext.pushBody();
	return;
}
String encodeFileURI = new String(fileURI.getBytes("ISO-8859-1"),"UTF-8");
String responseType = request.getParameter("responseType");

if(encodeFileURI.startsWith("/content/")) {
	String contentType = null;
	try {
		contentType = Files.probeContentType(Paths.get(encodeFileURI));
	} catch(IOException ex) {
	}
	
	if(contentType == null) {
		PrintWriter writer = response.getWriter();
		writer.println("Invalid file access for: " + fileURI);
	} else if(contentType.contains("image")) {
		FileInputStream is = null;
		OutputStream outStream = null;
		try {
			is = new FileInputStream(encodeFileURI);
			outStream = response.getOutputStream();
			
			if("BASE64".equals(responseType)) {
	        	IOUtils.write("data:image/png;base64,", outStream, "UTF-8");
	        	byte[] imgBuf = IOUtils.toByteArray(is);
	        	Base64 util = new Base64();
	        	byte[] encImgBuf = util.encode(imgBuf);
	        	outStream.write(encImgBuf);
	        	outStream.flush();
			} else {
				IOUtils.copy(is,outStream);
			}			
		} catch(Exception ex) {
			PrintWriter writer = response.getWriter();
			writer.println("Error: " + ex.getMessage());
		} finally {
			IOUtils.closeQuietly(is);
			IOUtils.closeQuietly(outStream);
		}
	} else {
		PrintWriter writer = response.getWriter();
		writer.println("Permission denied: access non-image files prohibited. ");
	}
} else {
	PrintWriter writer = response.getWriter();
	writer.println("Permission denied. ");
}


out.clear();
out = pageContext.pushBody();
%>
