/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.LicenseDetails;
import com.ericsson.ejb.RevenuePricing;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="CM_CURRENCY")
public class Currency
implements Serializable {
    private static final long serialVersionUID = 6201307392748674857L;
    private Long idCurrency;
    private String name;
    private String symbol;
    private Set<RevenuePricing> revenuePricings = new HashSet<RevenuePricing>(0);
    private Set<LicenseDetails> licenseDetails = new HashSet<LicenseDetails>(0);

    public Currency() {
    }

    public Currency(Long idCurrency) {
        this.idCurrency = idCurrency;
    }

    public Currency(String name, String symbol) {
        this.name = name;
        this.symbol = symbol;
    }

    @Id
    @Column(name="ID_CURRENCY", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="CurrencyID Sequence Generator", sequenceName="CM_CURRENCY_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CurrencyID Sequence Generator")
    public Long getIdCurrency() {
        return this.idCurrency;
    }

    public void setIdCurrency(Long idCurrency) {
        this.idCurrency = idCurrency;
    }

    @Column(name="NAME", nullable=false, length=50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="SYMBOL", nullable=false, length=50)
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="currency")
    public Set<RevenuePricing> getRevenuePricings() {
        return this.revenuePricings;
    }

    public void setRevenuePricings(Set<RevenuePricing> revenuePricings) {
        this.revenuePricings = revenuePricings;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="currency")
    public Set<LicenseDetails> getLicenseDetails() {
        return this.licenseDetails;
    }

    public void setLicenseDetails(Set<LicenseDetails> licenseDetails) {
        this.licenseDetails = licenseDetails;
    }

    @Transient
    public String getNameAndSymbol() {
        return this.name + " (" + this.symbol + ")";
    }
}

